(function (root, factory) {
  if (typeof define === 'function' && define.amd)
    define(['exports', 'kotlin'], factory);
  else if (typeof exports === 'object')
    factory(module.exports, require('kotlin'));
  else {
    if (typeof kotlin === 'undefined') {
      throw new Error("Error loading module 'klog'. Its dependency 'kotlin' was not found. Please, check whether 'kotlin' is loaded prior to 'klog'.");
    }
    root.klog = factory(typeof klog === 'undefined' ? {} : klog, kotlin);
  }
}(this, function (_, Kotlin) {
  'use strict';
  var $$importsForInline$$ = _.$$importsForInline$$ || (_.$$importsForInline$$ = {});
  var Kind_CLASS = Kotlin.Kind.CLASS;
  var Kind_OBJECT = Kotlin.Kind.OBJECT;
  var defineInlineFunction = Kotlin.defineInlineFunction;
  var wrapFunction = Kotlin.wrapFunction;
  var equals = Kotlin.equals;
  var Error_init = Kotlin.kotlin.Error_init_pdl1vj$;
  var lazy = Kotlin.kotlin.lazy_klfg04$;
  var throwCCE = Kotlin.throwCCE;
  var trim = Kotlin.kotlin.text.trim_gw00vp$;
  var substringBeforeLast = Kotlin.kotlin.text.substringBeforeLast_8cymmc$;
  var toSet = Kotlin.kotlin.collections.toSet_7wnvza$;
  var startsWith = Kotlin.kotlin.text.startsWith_7epoxm$;
  var LinkedHashMap_init = Kotlin.kotlin.collections.LinkedHashMap_init_q3lmfv$;
  var stackTraceToString = Kotlin.kotlin.stackTraceToString_dbl4o4$;
  var toString = Kotlin.toString;
  var unboxChar = Kotlin.unboxChar;
  var isWhitespace = Kotlin.kotlin.text.isWhitespace_myv2d0$;
  var until = Kotlin.kotlin.ranges.until_dqglrj$;
  var substring = Kotlin.kotlin.text.substring_fc3b62$;
  var getCallableRef = Kotlin.getCallableRef;
  var StringBuilder_init = Kotlin.kotlin.text.StringBuilder_init;
  var toBoxedChar = Kotlin.toBoxedChar;
  var Enum = Kotlin.kotlin.Enum;
  var throwISE = Kotlin.throwISE;
  var Unit = Kotlin.kotlin.Unit;
  var println = Kotlin.kotlin.io.println_s8jyv4$;
  var ensureNotNull = Kotlin.ensureNotNull;
  var L_1 = Kotlin.Long.NEG_ONE;
  KLogImpl.prototype = Object.create(KLog.prototype);
  KLogImpl.prototype.constructor = KLogImpl;
  DefaultLogFactory.prototype = Object.create(KLogFactory.prototype);
  DefaultLogFactory.prototype.constructor = DefaultLogFactory;
  Level.prototype = Object.create(Enum.prototype);
  Level.prototype.constructor = Level;
  createKLogRegistry$ObjectLiteral.prototype = Object.create(DefaultLogFactory.prototype);
  createKLogRegistry$ObjectLiteral.prototype.constructor = createKLogRegistry$ObjectLiteral;
  function StatementContext(threadName, threadID, line) {
    if (threadID === void 0)
      threadID = '';
    if (line === void 0)
      line = null;
    this.threadName = threadName;
    this.threadID = threadID;
    this.line = line;
  }
  Object.defineProperty(StatementContext.prototype, 'time', {
    configurable: true,
    get: function () {
      return getTimeMillis();
    }
  });
  function StatementContext$LineContext(lineNumber, functionName, className, fileName) {
    if (lineNumber === void 0)
      lineNumber = -1;
    if (functionName === void 0)
      functionName = null;
    if (className === void 0)
      className = null;
    if (fileName === void 0)
      fileName = null;
    this.lineNumber = lineNumber;
    this.functionName = functionName;
    this.className = className;
    this.fileName = fileName;
  }
  StatementContext$LineContext.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'LineContext',
    interfaces: []
  };
  StatementContext$LineContext.prototype.component1 = function () {
    return this.lineNumber;
  };
  StatementContext$LineContext.prototype.component2 = function () {
    return this.functionName;
  };
  StatementContext$LineContext.prototype.component3 = function () {
    return this.className;
  };
  StatementContext$LineContext.prototype.component4 = function () {
    return this.fileName;
  };
  StatementContext$LineContext.prototype.copy_gtntat$ = function (lineNumber, functionName, className, fileName) {
    return new StatementContext$LineContext(lineNumber === void 0 ? this.lineNumber : lineNumber, functionName === void 0 ? this.functionName : functionName, className === void 0 ? this.className : className, fileName === void 0 ? this.fileName : fileName);
  };
  StatementContext$LineContext.prototype.toString = function () {
    return 'LineContext(lineNumber=' + Kotlin.toString(this.lineNumber) + (', functionName=' + Kotlin.toString(this.functionName)) + (', className=' + Kotlin.toString(this.className)) + (', fileName=' + Kotlin.toString(this.fileName)) + ')';
  };
  StatementContext$LineContext.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.lineNumber) | 0;
    result = result * 31 + Kotlin.hashCode(this.functionName) | 0;
    result = result * 31 + Kotlin.hashCode(this.className) | 0;
    result = result * 31 + Kotlin.hashCode(this.fileName) | 0;
    return result;
  };
  StatementContext$LineContext.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.lineNumber, other.lineNumber) && Kotlin.equals(this.functionName, other.functionName) && Kotlin.equals(this.className, other.className) && Kotlin.equals(this.fileName, other.fileName)))));
  };
  StatementContext.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'StatementContext',
    interfaces: []
  };
  StatementContext.prototype.component1 = function () {
    return this.threadName;
  };
  StatementContext.prototype.component2 = function () {
    return this.threadID;
  };
  StatementContext.prototype.component3 = function () {
    return this.line;
  };
  StatementContext.prototype.copy_hxr5d3$ = function (threadName, threadID, line) {
    return new StatementContext(threadName === void 0 ? this.threadName : threadName, threadID === void 0 ? this.threadID : threadID, line === void 0 ? this.line : line);
  };
  StatementContext.prototype.toString = function () {
    return 'StatementContext(threadName=' + Kotlin.toString(this.threadName) + (', threadID=' + Kotlin.toString(this.threadID)) + (', line=' + Kotlin.toString(this.line)) + ')';
  };
  StatementContext.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.threadName) | 0;
    result = result * 31 + Kotlin.hashCode(this.threadID) | 0;
    result = result * 31 + Kotlin.hashCode(this.line) | 0;
    return result;
  };
  StatementContext.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.threadName, other.threadName) && Kotlin.equals(this.threadID, other.threadID) && Kotlin.equals(this.line, other.line)))));
  };
  function KLog(tag) {
    KLog$Companion_getInstance();
    this.tag = tag;
  }
  function KLog$Conf(level, writer, messageFormatter, displayTagLength, displayTagFormatter) {
    if (displayTagLength === void 0)
      displayTagLength = 12;
    if (displayTagFormatter === void 0)
      displayTagFormatter = DefaultDisplayTagFormatter;
    this.level = level;
    this.writer = writer;
    this.messageFormatter = messageFormatter;
    this.displayTagLength = displayTagLength;
    this.displayTagFormatter = displayTagFormatter;
  }
  KLog$Conf.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Conf',
    interfaces: []
  };
  KLog$Conf.prototype.component1 = function () {
    return this.level;
  };
  KLog$Conf.prototype.component2 = function () {
    return this.writer;
  };
  KLog$Conf.prototype.component3 = function () {
    return this.messageFormatter;
  };
  KLog$Conf.prototype.component4 = function () {
    return this.displayTagLength;
  };
  KLog$Conf.prototype.component5 = function () {
    return this.displayTagFormatter;
  };
  KLog$Conf.prototype.copy_7rkmj0$ = function (level, writer, messageFormatter, displayTagLength, displayTagFormatter) {
    return new KLog$Conf(level === void 0 ? this.level : level, writer === void 0 ? this.writer : writer, messageFormatter === void 0 ? this.messageFormatter : messageFormatter, displayTagLength === void 0 ? this.displayTagLength : displayTagLength, displayTagFormatter === void 0 ? this.displayTagFormatter : displayTagFormatter);
  };
  KLog$Conf.prototype.toString = function () {
    return 'Conf(level=' + Kotlin.toString(this.level) + (', writer=' + Kotlin.toString(this.writer)) + (', messageFormatter=' + Kotlin.toString(this.messageFormatter)) + (', displayTagLength=' + Kotlin.toString(this.displayTagLength)) + (', displayTagFormatter=' + Kotlin.toString(this.displayTagFormatter)) + ')';
  };
  KLog$Conf.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.level) | 0;
    result = result * 31 + Kotlin.hashCode(this.writer) | 0;
    result = result * 31 + Kotlin.hashCode(this.messageFormatter) | 0;
    result = result * 31 + Kotlin.hashCode(this.displayTagLength) | 0;
    result = result * 31 + Kotlin.hashCode(this.displayTagFormatter) | 0;
    return result;
  };
  KLog$Conf.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.level, other.level) && Kotlin.equals(this.writer, other.writer) && Kotlin.equals(this.messageFormatter, other.messageFormatter) && Kotlin.equals(this.displayTagLength, other.displayTagLength) && Kotlin.equals(this.displayTagFormatter, other.displayTagFormatter)))));
  };
  function KLog$Companion() {
    KLog$Companion_instance = this;
    this.ROOT_LOG_TAG = '';
  }
  KLog$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var KLog$Companion_instance = null;
  function KLog$Companion_getInstance() {
    if (KLog$Companion_instance === null) {
      new KLog$Companion();
    }
    return KLog$Companion_instance;
  }
  KLog.prototype.trace_wspj0f$ = defineInlineFunction('klog.klog.KLog.trace_wspj0f$', wrapFunction(function () {
    var Level = _.klog.Level;
    return function (msg, err) {
      if (msg === void 0)
        msg = null;
      if (err === void 0)
        err = null;
      this.log_nofgi1$(Level.TRACE, msg, err, null);
    };
  }));
  KLog.prototype.trace_bj4jp$ = defineInlineFunction('klog.klog.KLog.trace_bj4jp$', wrapFunction(function () {
    var Level = _.klog.Level;
    return function (msg, err, msgProvider) {
      if (msg === void 0)
        msg = null;
      if (err === void 0)
        err = null;
      this.log_nofgi1$(Level.TRACE, msg, err, msgProvider);
    };
  }));
  KLog.prototype.debug_wspj0f$ = defineInlineFunction('klog.klog.KLog.debug_wspj0f$', wrapFunction(function () {
    var Level = _.klog.Level;
    return function (msg, err) {
      if (msg === void 0)
        msg = null;
      if (err === void 0)
        err = null;
      this.log_nofgi1$(Level.DEBUG, msg, err, null);
    };
  }));
  KLog.prototype.debug_bj4jp$ = defineInlineFunction('klog.klog.KLog.debug_bj4jp$', wrapFunction(function () {
    var Level = _.klog.Level;
    return function (msg, err, msgProvider) {
      if (msg === void 0)
        msg = null;
      if (err === void 0)
        err = null;
      this.log_nofgi1$(Level.DEBUG, msg, err, msgProvider);
    };
  }));
  KLog.prototype.info_wspj0f$ = defineInlineFunction('klog.klog.KLog.info_wspj0f$', wrapFunction(function () {
    var Level = _.klog.Level;
    return function (msg, err) {
      if (msg === void 0)
        msg = null;
      if (err === void 0)
        err = null;
      this.log_nofgi1$(Level.INFO, msg, err, null);
    };
  }));
  KLog.prototype.info_bj4jp$ = defineInlineFunction('klog.klog.KLog.info_bj4jp$', wrapFunction(function () {
    var Level = _.klog.Level;
    return function (msg, err, msgProvider) {
      if (msg === void 0)
        msg = null;
      if (err === void 0)
        err = null;
      this.log_nofgi1$(Level.INFO, msg, err, msgProvider);
    };
  }));
  KLog.prototype.warn_wspj0f$ = defineInlineFunction('klog.klog.KLog.warn_wspj0f$', wrapFunction(function () {
    var Level = _.klog.Level;
    return function (msg, err) {
      if (msg === void 0)
        msg = null;
      if (err === void 0)
        err = null;
      this.log_nofgi1$(Level.WARN, msg, err, null);
    };
  }));
  KLog.prototype.warn_bj4jp$ = defineInlineFunction('klog.klog.KLog.warn_bj4jp$', wrapFunction(function () {
    var Level = _.klog.Level;
    return function (msg, err, msgProvider) {
      if (msg === void 0)
        msg = null;
      if (err === void 0)
        err = null;
      this.log_nofgi1$(Level.WARN, msg, err, msgProvider);
    };
  }));
  KLog.prototype.error_wspj0f$ = defineInlineFunction('klog.klog.KLog.error_wspj0f$', wrapFunction(function () {
    var Level = _.klog.Level;
    return function (msg, err) {
      if (msg === void 0)
        msg = null;
      if (err === void 0)
        err = null;
      this.log_nofgi1$(Level.ERROR, msg, err, null);
    };
  }));
  KLog.prototype.error_bj4jp$ = defineInlineFunction('klog.klog.KLog.error_bj4jp$', wrapFunction(function () {
    var Level = _.klog.Level;
    return function (msg, err, msgProvider) {
      if (msg === void 0)
        msg = null;
      if (err === void 0)
        err = null;
      this.log_nofgi1$(Level.ERROR, msg, err, msgProvider);
    };
  }));
  Object.defineProperty(KLog.prototype, 'isTraceEnabled', {
    configurable: true,
    get: defineInlineFunction('klog.klog.KLog.get_isTraceEnabled', wrapFunction(function () {
      var Level = _.klog.Level;
      return function () {
        return this.conf.level.compareTo_11rb$(Level.TRACE) <= 0;
      };
    }))
  });
  Object.defineProperty(KLog.prototype, 'isDebugEnabled', {
    configurable: true,
    get: defineInlineFunction('klog.klog.KLog.get_isDebugEnabled', wrapFunction(function () {
      var Level = _.klog.Level;
      return function () {
        return this.conf.level.compareTo_11rb$(Level.DEBUG) <= 0;
      };
    }))
  });
  Object.defineProperty(KLog.prototype, 'isInfoEnabled', {
    configurable: true,
    get: defineInlineFunction('klog.klog.KLog.get_isInfoEnabled', wrapFunction(function () {
      var Level = _.klog.Level;
      return function () {
        return this.conf.level.compareTo_11rb$(Level.INFO) <= 0;
      };
    }))
  });
  Object.defineProperty(KLog.prototype, 'isWarnEnabled', {
    configurable: true,
    get: defineInlineFunction('klog.klog.KLog.get_isWarnEnabled', wrapFunction(function () {
      var Level = _.klog.Level;
      return function () {
        return this.conf.level.compareTo_11rb$(Level.WARN) <= 0;
      };
    }))
  });
  Object.defineProperty(KLog.prototype, 'isErrorEnabled', {
    configurable: true,
    get: defineInlineFunction('klog.klog.KLog.get_isErrorEnabled', wrapFunction(function () {
      var Level = _.klog.Level;
      return function () {
        return this.conf.level.compareTo_11rb$(Level.ERROR) <= 0;
      };
    }))
  });
  Object.defineProperty(KLog.prototype, 'isEnabled', {
    configurable: true,
    get: function () {
      return this.conf.level.compareTo_11rb$(Level.ERROR) <= 0 && !equals(this.conf.writer, KLogWriters_getInstance().noop);
    }
  });
  KLog.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'KLog',
    interfaces: []
  };
  function KLogImpl(tag, conf) {
    KLog.call(this, tag);
    this.conf_92h4qy$_0 = conf;
    var tmp$, tmp$_0;
    this.displayTag_xe00ta$_0 = (tmp$_0 = (tmp$ = this.conf.displayTagFormatter) != null ? tmp$(tag, this.conf.displayTagLength) : null) != null ? tmp$_0 : tag;
  }
  Object.defineProperty(KLogImpl.prototype, 'conf', {
    get: function () {
      return this.conf_92h4qy$_0;
    }
  });
  Object.defineProperty(KLogImpl.prototype, 'displayTag', {
    configurable: true,
    get: function () {
      return this.displayTag_xe00ta$_0;
    }
  });
  function KLogImpl$log$lambda() {
    return platformStatementContext();
  }
  KLogImpl.prototype.log_nofgi1$ = function (level, msg, err, msgProvider) {
    var tmp$, tmp$_0;
    var logWriter = this.conf.writer;
    if (equals(logWriter, KLogWriters_getInstance().noop))
      return;
    if (msg == null && msgProvider == null)
      throw Error_init('Either provide a message or a message provider');
    if (level.compareTo_11rb$(this.conf.level) < 0)
      return;
    var $receiver = ((tmp$ = msg != null ? msg : err != null ? err.message : null) != null ? tmp$ : '') + ' ' + ((tmp$_0 = msgProvider != null ? msgProvider() : null) != null ? tmp$_0 : '');
    var tmp$_1;
    var message = trim(Kotlin.isCharSequence(tmp$_1 = $receiver) ? tmp$_1 : throwCCE()).toString();
    var ctx = lazy(KLogImpl$log$lambda);
    logWriter(this.displayTag, level, this.conf.messageFormatter(this.tag, level, message, err, ctx.value), err);
  };
  KLogImpl.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'KLogImpl',
    interfaces: [KLog]
  };
  function KLogFactory() {
  }
  KLogFactory.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'KLogFactory',
    interfaces: []
  };
  function DefaultLogFactory(level, formatter, writer) {
    if (level === void 0)
      level = Level$WARN_getInstance();
    if (formatter === void 0)
      formatter = KMessageFormatters_getInstance().simple;
    if (writer === void 0)
      writer = KLogWriters_getInstance().noop;
    KLogFactory.call(this);
    this.logs_gnqqy7$_0 = LinkedHashMap_init();
    var $receiver = this.logs_gnqqy7$_0;
    var key = KLog$Companion_getInstance().ROOT_LOG_TAG;
    var value = new KLogImpl(KLog$Companion_getInstance().ROOT_LOG_TAG, new KLog$Conf(level, writer, formatter));
    $receiver.put_xwzc9p$(key, value);
  }
  DefaultLogFactory.prototype.get_61zpoe$ = function (tag) {
    var tmp$;
    var tmp$_0;
    if ((tmp$ = this.logs_gnqqy7$_0.get_11rb$(tag)) != null)
      tmp$_0 = tmp$;
    else {
      var $receiver = new KLogImpl(tag, this.getParent_qbk354$_0(tag).conf);
      this.logs_gnqqy7$_0.put_xwzc9p$(tag, $receiver);
      tmp$_0 = $receiver;
    }
    return tmp$_0;
  };
  DefaultLogFactory.prototype.getParent_qbk354$_0 = function (tag) {
    var parentTag = substringBeforeLast(tag, 46, KLog$Companion_getInstance().ROOT_LOG_TAG);
    var tmp$;
    return (tmp$ = this.logs_gnqqy7$_0.get_11rb$(parentTag)) != null ? tmp$ : this.getParent_qbk354$_0(parentTag);
  };
  DefaultLogFactory.prototype.getLogs = function () {
    return toSet(this.logs_gnqqy7$_0.values);
  };
  DefaultLogFactory.prototype.applyToBranch_ym4a7$ = function (tag, toApply) {
    var tmp$;
    tmp$ = this.logs_gnqqy7$_0.entries.iterator();
    while (tmp$.hasNext()) {
      var element = tmp$.next();
      if (equals(element.key, tag) || startsWith(element.key, tag + '.'))
        toApply(element.value);
    }
  };
  DefaultLogFactory.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'DefaultLogFactory',
    interfaces: [KLogFactory]
  };
  function KMessageFormatters$colored$lambda(closure$formatter) {
    return function (name, level, msg, exception, context) {
      return '\x1B' + '[0;' + get_color(level) + 'm' + closure$formatter(name, level, msg, exception, context) + '\x1B' + '[0m';
    };
  }
  function get_color($receiver) {
    switch ($receiver.name) {
      case 'TRACE':
        return 35;
      case 'DEBUG':
        return 36;
      case 'INFO':
        return 32;
      case 'WARN':
        return 33;
      default:
        return 31;
    }
  }
  function KMessageFormatters() {
    KMessageFormatters_instance = this;
    this.simple = KMessageFormatters$simple$lambda;
    this.verbose = KMessageFormatters$verbose$lambda;
  }
  KMessageFormatters.prototype.colored_4f6tpk$ = defineInlineFunction('klog.klog.KMessageFormatters.colored_4f6tpk$', wrapFunction(function () {
    var get_color = _.klog.get_color_t1kt7k$;
    function KMessageFormatters$colored$lambda(closure$formatter) {
      return function (name, level, msg, exception, context) {
        return '\x1B' + '[0;' + get_color(level) + 'm' + closure$formatter(name, level, msg, exception, context) + '\x1B' + '[0m';
      };
    }
    return function (formatter) {
      return KMessageFormatters$colored$lambda(formatter);
    };
  }));
  function KMessageFormatters$simple$lambda(tag, level, msg, exception, f) {
    var tmp$, tmp$_0;
    var it = level.toString();
    var l = it.length < 5 ? ' ' + it + ':' : it + ':';
    return l + tag + ': ' + msg + ' ' + ((tmp$_0 = (tmp$ = exception != null ? stackTraceToString(exception) : null) != null ? ' :' + tmp$ : null) != null ? tmp$_0 : '');
  }
  function KMessageFormatters$verbose$lambda(tag, level, msg, exception, ctx) {
    var $receiver = StringBuilder_init();
    var tmp$, tmp$_0, tmp$_1, tmp$_2;
    var it = level.toString();
    $receiver.append_pdl1vj$(it.length < 5 ? ' ' + it + ':' : it + ':');
    $receiver.append_pdl1vj$(tag);
    $receiver.append_s8itvh$(58);
    var threadID = ctx.threadID;
    if (threadID.length > 0)
      $receiver.append_pdl1vj$('<' + threadID + '>:');
    var tmp$_3;
    if ((tmp$_0 = (tmp$ = ctx.line) != null ? tmp$.functionName : null) != null) {
      $receiver.append_pdl1vj$(toString(ctx.line.fileName) + ':' + ctx.line.lineNumber + ':' + tmp$_0 + '(): ');
      tmp$_3 = tmp$_0;
    } else
      tmp$_3 = null;
    (tmp$_1 = tmp$_3) != null ? tmp$_1 : $receiver.append_pdl1vj$(' ');
    $receiver.append_pdl1vj$(msg);
    if ((tmp$_2 = exception != null ? stackTraceToString(exception) : null) != null) {
      $receiver.append_pdl1vj$(' :' + tmp$_2);
    }
    return $receiver.toString();
  }
  KMessageFormatters.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'KMessageFormatters',
    interfaces: []
  };
  var KMessageFormatters_instance = null;
  function KMessageFormatters_getInstance() {
    if (KMessageFormatters_instance === null) {
      new KMessageFormatters();
    }
    return KMessageFormatters_instance;
  }
  function get_colored($receiver) {
    return KMessageFormatters$colored$lambda($receiver);
  }
  function defaultDisplayTagFormatter(t, length) {
    var tmp$;
    var tag = trim(Kotlin.isCharSequence(tmp$ = t) ? tmp$ : throwCCE()).toString();
    if (tag.length <= length)
      return tag;
    var $receiver = tag;
    var destination = StringBuilder_init();
    var tmp$_0;
    tmp$_0 = $receiver.length;
    for (var index = 0; index < tmp$_0; index++) {
      var element = $receiver.charCodeAt(index);
      if (!isWhitespace(unboxChar(toBoxedChar(element))))
        destination.append_s8itvh$(element);
    }
    tag = destination.toString();
    if (tag.length <= length)
      return tag;
    var c = length / 2 | 0;
    return substring(tag, until(0, c)) + substring(tag, until(tag.length - c | 0, tag.length));
  }
  var DefaultDisplayTagFormatter;
  function Level(name, ordinal) {
    Enum.call(this);
    this.name$ = name;
    this.ordinal$ = ordinal;
  }
  function Level_initFields() {
    Level_initFields = function () {
    };
    Level$TRACE_instance = new Level('TRACE', 0);
    Level$DEBUG_instance = new Level('DEBUG', 1);
    Level$INFO_instance = new Level('INFO', 2);
    Level$WARN_instance = new Level('WARN', 3);
    Level$ERROR_instance = new Level('ERROR', 4);
  }
  var Level$TRACE_instance;
  function Level$TRACE_getInstance() {
    Level_initFields();
    return Level$TRACE_instance;
  }
  var Level$DEBUG_instance;
  function Level$DEBUG_getInstance() {
    Level_initFields();
    return Level$DEBUG_instance;
  }
  var Level$INFO_instance;
  function Level$INFO_getInstance() {
    Level_initFields();
    return Level$INFO_instance;
  }
  var Level$WARN_instance;
  function Level$WARN_getInstance() {
    Level_initFields();
    return Level$WARN_instance;
  }
  var Level$ERROR_instance;
  function Level$ERROR_getInstance() {
    Level_initFields();
    return Level$ERROR_instance;
  }
  Level.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Level',
    interfaces: [Enum]
  };
  function Level$values() {
    return [Level$TRACE_getInstance(), Level$DEBUG_getInstance(), Level$INFO_getInstance(), Level$WARN_getInstance(), Level$ERROR_getInstance()];
  }
  Level.values = Level$values;
  function Level$valueOf(name) {
    switch (name) {
      case 'TRACE':
        return Level$TRACE_getInstance();
      case 'DEBUG':
        return Level$DEBUG_getInstance();
      case 'INFO':
        return Level$INFO_getInstance();
      case 'WARN':
        return Level$WARN_getInstance();
      case 'ERROR':
        return Level$ERROR_getInstance();
      default:
        throwISE('No enum constant klog.Level.' + name);
    }
  }
  Level.valueOf_61zpoe$ = Level$valueOf;
  var kLogRegistry;
  var klog = defineInlineFunction('klog.klog.klog_irb06o$', wrapFunction(function () {
    var klog = _.klog;
    var klogName = _.klog.klogName_lr8r8q$;
    return function (T_0, isT, $receiver) {
      return klog.kLogRegistry.get_61zpoe$(klogName(Kotlin.getKClassFromExpression($receiver)));
    };
  }));
  var klog_0 = defineInlineFunction('klog.klog.klog_vpmyry$', wrapFunction(function () {
    var klog = _.klog;
    var klogName = _.klog.klogName_lr8r8q$;
    return function (T_0, isT, $receiver, level) {
      if (level === void 0)
        level = null;
      return klog.kLogRegistry.get_61zpoe$(klogName(Kotlin.getKClassFromExpression($receiver)));
    };
  }));
  var klog_1 = defineInlineFunction('klog.klog.klog_gmd7sl$', wrapFunction(function () {
    var KLog = _.klog.KLog;
    var klog = _.klog;
    var klogName = _.klog.klogName_lr8r8q$;
    return function (T_0, isT, $receiver, tag, config) {
      if (tag === void 0)
        tag = KLog.Companion.ROOT_LOG_TAG;
      var $receiver_0 = klog.kLogRegistry.get_61zpoe$(klogName(Kotlin.getKClassFromExpression($receiver)));
      config($receiver_0.conf);
      return $receiver_0;
    };
  }));
  var klog_2 = defineInlineFunction('klog.klog.klog_ipzvjv$', wrapFunction(function () {
    var Unit = Kotlin.kotlin.Unit;
    var klog = _.klog;
    function klog$lambda($receiver) {
      return Unit;
    }
    return function (tag, config) {
      if (config === void 0)
        config = klog$lambda;
      var $receiver = klog.kLogRegistry.get_61zpoe$(tag);
      config($receiver.conf);
      return $receiver;
    };
  }));
  var klog_3 = defineInlineFunction('klog.klog.klog_xo1ogr$', wrapFunction(function () {
    var klog = _.klog;
    var klogName = _.klog.klogName_lr8r8q$;
    return function (clazz) {
      return klog.kLogRegistry.get_61zpoe$(klogName(clazz));
    };
  }));
  function KLogWriters() {
    KLogWriters_instance = this;
    this.noop = KLogWriters$noop$lambda;
    this.stdOut = KLogWriters$stdOut$lambda;
  }
  function KLogWriters$noop$lambda(f, f_0, f_1, f_2) {
    return Unit;
  }
  function KLogWriters$stdOut$lambda(f, f_0, msg, f_1) {
    println(msg);
    return Unit;
  }
  KLogWriters.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'KLogWriters',
    interfaces: []
  };
  var KLogWriters_instance = null;
  function KLogWriters_getInstance() {
    if (KLogWriters_instance === null) {
      new KLogWriters();
    }
    return KLogWriters_instance;
  }
  function platformStatementContext() {
    return new StatementContext('js', '');
  }
  function createKLogRegistry$ObjectLiteral(level, formatter, writer) {
    DefaultLogFactory.call(this, level, formatter, writer);
  }
  createKLogRegistry$ObjectLiteral.$metadata$ = {
    kind: Kind_CLASS,
    interfaces: [DefaultLogFactory]
  };
  function createKLogRegistry() {
    return new createKLogRegistry$ObjectLiteral();
  }
  function klogName($receiver) {
    return ensureNotNull($receiver.simpleName);
  }
  function getTimeMillis() {
    return L_1;
  }
  StatementContext.LineContext = StatementContext$LineContext;
  var package$klog = _.klog || (_.klog = {});
  package$klog.StatementContext = StatementContext;
  KLog.Conf = KLog$Conf;
  Object.defineProperty(KLog, 'Companion', {
    get: KLog$Companion_getInstance
  });
  package$klog.Level = Level;
  $$importsForInline$$.klog = _;
  package$klog.KLog = KLog;
  package$klog.KLogImpl = KLogImpl;
  package$klog.KLogFactory = KLogFactory;
  package$klog.DefaultLogFactory = DefaultLogFactory;
  package$klog.get_color_t1kt7k$ = get_color;
  Object.defineProperty(package$klog, 'KMessageFormatters', {
    get: KMessageFormatters_getInstance
  });
  package$klog.get_colored_4zcizb$ = get_colored;
  Object.defineProperty(package$klog, 'DefaultDisplayTagFormatter', {
    get: function () {
      return DefaultDisplayTagFormatter;
    }
  });
  Object.defineProperty(Level, 'TRACE', {
    get: Level$TRACE_getInstance
  });
  Object.defineProperty(Level, 'DEBUG', {
    get: Level$DEBUG_getInstance
  });
  Object.defineProperty(Level, 'INFO', {
    get: Level$INFO_getInstance
  });
  Object.defineProperty(Level, 'WARN', {
    get: Level$WARN_getInstance
  });
  Object.defineProperty(Level, 'ERROR', {
    get: Level$ERROR_getInstance
  });
  Object.defineProperty(package$klog, 'kLogRegistry', {
    get: function () {
      return kLogRegistry;
    }
  });
  package$klog.klogName_lr8r8q$ = klogName;
  package$klog.klog_ipzvjv$ = klog_2;
  package$klog.klog_xo1ogr$ = klog_3;
  Object.defineProperty(package$klog, 'KLogWriters', {
    get: KLogWriters_getInstance
  });
  package$klog.platformStatementContext = platformStatementContext;
  package$klog.createKLogRegistry = createKLogRegistry;
  package$klog.getTimeMillis = getTimeMillis;
  DefaultDisplayTagFormatter = getCallableRef('defaultDisplayTagFormatter', function (p1, p2) {
    return defaultDisplayTagFormatter(p1, p2);
  });
  kLogRegistry = createKLogRegistry();
  Kotlin.defineModule('klog', _);
  return _;
}));

//# sourceMappingURL=klog.js.map
