(function (root, factory) {
  if (typeof define === 'function' && define.amd)
    define(['exports', 'kotlin'], factory);
  else if (typeof exports === 'object')
    factory(module.exports, require('kotlin'));
  else {
    if (typeof kotlin === 'undefined') {
      throw new Error("Error loading module 'klog'. Its dependency 'kotlin' was not found. Please, check whether 'kotlin' is loaded prior to 'klog'.");
    }
    root.klog = factory(typeof klog === 'undefined' ? {} : klog, kotlin);
  }
}(this, function (_, Kotlin) {
  'use strict';
  var $$importsForInline$$ = _.$$importsForInline$$ || (_.$$importsForInline$$ = {});
  var toBoxedChar = Kotlin.toBoxedChar;
  var listOf = Kotlin.kotlin.collections.listOf_i5x0yv$;
  var Kind_CLASS = Kotlin.Kind.CLASS;
  var equals = Kotlin.equals;
  var Kind_INTERFACE = Kotlin.Kind.INTERFACE;
  var throwCCE = Kotlin.throwCCE;
  var Unit = Kotlin.kotlin.Unit;
  var Error_init = Kotlin.kotlin.Error_init_pdl1vj$;
  var lazy = Kotlin.kotlin.lazy_klfg04$;
  var wrapFunction = Kotlin.wrapFunction;
  var trim = Kotlin.kotlin.text.trim_gw00vp$;
  var Kind_OBJECT = Kotlin.Kind.OBJECT;
  var defineInlineFunction = Kotlin.defineInlineFunction;
  var substringBeforeLast = Kotlin.kotlin.text.substringBeforeLast_8cymmc$;
  var toSet = Kotlin.kotlin.collections.toSet_7wnvza$;
  var startsWith = Kotlin.kotlin.text.startsWith_7epoxm$;
  var LinkedHashMap_init = Kotlin.kotlin.collections.LinkedHashMap_init_q3lmfv$;
  var stackTraceToString = Kotlin.kotlin.stackTraceToString_dbl4o4$;
  var toString = Kotlin.toString;
  var StringBuilder_init = Kotlin.kotlin.text.StringBuilder_init;
  var Enum = Kotlin.kotlin.Enum;
  var throwISE = Kotlin.throwISE;
  var println = Kotlin.kotlin.io.println_s8jyv4$;
  var ensureNotNull = Kotlin.ensureNotNull;
  var L_1 = Kotlin.Long.NEG_ONE;
  DefaultLogRegistry.prototype = Object.create(KLogRegistry.prototype);
  DefaultLogRegistry.prototype.constructor = DefaultLogRegistry;
  Level.prototype = Object.create(Enum.prototype);
  Level.prototype.constructor = Level;
  createKLogRegistry$ObjectLiteral.prototype = Object.create(DefaultLogRegistry.prototype);
  createKLogRegistry$ObjectLiteral.prototype.constructor = createKLogRegistry$ObjectLiteral;
  function Hex() {
    this.DIGITS_LOWER = listOf([toBoxedChar(48), toBoxedChar(49), toBoxedChar(50), toBoxedChar(51), toBoxedChar(52), toBoxedChar(53), toBoxedChar(54), toBoxedChar(55), toBoxedChar(56), toBoxedChar(57), toBoxedChar(97), toBoxedChar(98), toBoxedChar(99), toBoxedChar(100), toBoxedChar(101), toBoxedChar(102)]);
    this.DIGITS_UPPER = listOf([toBoxedChar(48), toBoxedChar(49), toBoxedChar(50), toBoxedChar(51), toBoxedChar(52), toBoxedChar(53), toBoxedChar(54), toBoxedChar(55), toBoxedChar(56), toBoxedChar(57), toBoxedChar(65), toBoxedChar(66), toBoxedChar(67), toBoxedChar(68), toBoxedChar(69), toBoxedChar(70)]);
  }
  Hex.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Hex',
    interfaces: []
  };
  function KLogImpl$log$lambda() {
    return platformStatementContext();
  }
  function StatementContext(threadName, threadID, line) {
    if (threadID === void 0)
      threadID = '';
    if (line === void 0)
      line = null;
    this.threadName = threadName;
    this.threadID = threadID;
    this.line = line;
  }
  Object.defineProperty(StatementContext.prototype, 'time', {
    configurable: true,
    get: function () {
      return getTimeMillis();
    }
  });
  function StatementContext$LineContext(lineNumber, functionName, className, fileName) {
    if (lineNumber === void 0)
      lineNumber = -1;
    if (functionName === void 0)
      functionName = null;
    if (className === void 0)
      className = null;
    if (fileName === void 0)
      fileName = null;
    this.lineNumber = lineNumber;
    this.functionName = functionName;
    this.className = className;
    this.fileName = fileName;
  }
  StatementContext$LineContext.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'LineContext',
    interfaces: []
  };
  StatementContext$LineContext.prototype.component1 = function () {
    return this.lineNumber;
  };
  StatementContext$LineContext.prototype.component2 = function () {
    return this.functionName;
  };
  StatementContext$LineContext.prototype.component3 = function () {
    return this.className;
  };
  StatementContext$LineContext.prototype.component4 = function () {
    return this.fileName;
  };
  StatementContext$LineContext.prototype.copy_gtntat$ = function (lineNumber, functionName, className, fileName) {
    return new StatementContext$LineContext(lineNumber === void 0 ? this.lineNumber : lineNumber, functionName === void 0 ? this.functionName : functionName, className === void 0 ? this.className : className, fileName === void 0 ? this.fileName : fileName);
  };
  StatementContext$LineContext.prototype.toString = function () {
    return 'LineContext(lineNumber=' + Kotlin.toString(this.lineNumber) + (', functionName=' + Kotlin.toString(this.functionName)) + (', className=' + Kotlin.toString(this.className)) + (', fileName=' + Kotlin.toString(this.fileName)) + ')';
  };
  StatementContext$LineContext.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.lineNumber) | 0;
    result = result * 31 + Kotlin.hashCode(this.functionName) | 0;
    result = result * 31 + Kotlin.hashCode(this.className) | 0;
    result = result * 31 + Kotlin.hashCode(this.fileName) | 0;
    return result;
  };
  StatementContext$LineContext.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.lineNumber, other.lineNumber) && Kotlin.equals(this.functionName, other.functionName) && Kotlin.equals(this.className, other.className) && Kotlin.equals(this.fileName, other.fileName)))));
  };
  StatementContext.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'StatementContext',
    interfaces: []
  };
  StatementContext.prototype.component1 = function () {
    return this.threadName;
  };
  StatementContext.prototype.component2 = function () {
    return this.threadID;
  };
  StatementContext.prototype.component3 = function () {
    return this.line;
  };
  StatementContext.prototype.copy_34jvtj$ = function (threadName, threadID, line) {
    return new StatementContext(threadName === void 0 ? this.threadName : threadName, threadID === void 0 ? this.threadID : threadID, line === void 0 ? this.line : line);
  };
  StatementContext.prototype.toString = function () {
    return 'StatementContext(threadName=' + Kotlin.toString(this.threadName) + (', threadID=' + Kotlin.toString(this.threadID)) + (', line=' + Kotlin.toString(this.line)) + ')';
  };
  StatementContext.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.threadName) | 0;
    result = result * 31 + Kotlin.hashCode(this.threadID) | 0;
    result = result * 31 + Kotlin.hashCode(this.line) | 0;
    return result;
  };
  StatementContext.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.threadName, other.threadName) && Kotlin.equals(this.threadID, other.threadID) && Kotlin.equals(this.line, other.line)))));
  };
  function KLog() {
  }
  Object.defineProperty(KLog.prototype, 'displayName', {
    configurable: true,
    get: function () {
      var tmp$, tmp$_0;
      return (tmp$_0 = (tmp$ = this.nameFormatter) != null ? tmp$(this.name) : null) != null ? tmp$_0 : this.name;
    }
  });
  KLog.prototype.copy_mhvu1s$ = function (name, level, writer, messageFormatter, nameFormatter, callback$default) {
    if (name === void 0)
      name = this.name;
    if (level === void 0)
      level = this.level;
    if (writer === void 0)
      writer = this.writer;
    if (messageFormatter === void 0)
      messageFormatter = this.messageFormatter;
    if (nameFormatter === void 0)
      nameFormatter = this.nameFormatter;
    return callback$default ? callback$default(name, level, writer, messageFormatter, nameFormatter) : this.copy_mhvu1s$$default(name, level, writer, messageFormatter, nameFormatter);
  };
  KLog.prototype.trace_wspj0f$$default = function (msg, err) {
    this.trace_9xgx0a$(msg, err, null);
  };
  KLog.prototype.trace_wspj0f$ = function (msg, err, callback$default) {
    if (msg === void 0)
      msg = null;
    if (err === void 0)
      err = null;
    callback$default ? callback$default(msg, err) : this.trace_wspj0f$$default(msg, err);
  };
  KLog.prototype.trace_9xgx0a$ = function (msg, err, msgProvider, callback$default) {
    if (msg === void 0)
      msg = null;
    if (err === void 0)
      err = null;
    if (msgProvider === void 0)
      msgProvider = null;
    callback$default ? callback$default(msg, err, msgProvider) : this.trace_9xgx0a$$default(msg, err, msgProvider);
  };
  KLog.prototype.debug_wspj0f$$default = function (msg, err) {
    this.debug_9xgx0a$(msg, err, null);
  };
  KLog.prototype.debug_wspj0f$ = function (msg, err, callback$default) {
    if (msg === void 0)
      msg = null;
    if (err === void 0)
      err = null;
    callback$default ? callback$default(msg, err) : this.debug_wspj0f$$default(msg, err);
  };
  KLog.prototype.debug_9xgx0a$ = function (msg, err, msgProvider, callback$default) {
    if (msg === void 0)
      msg = null;
    if (err === void 0)
      err = null;
    if (msgProvider === void 0)
      msgProvider = null;
    callback$default ? callback$default(msg, err, msgProvider) : this.debug_9xgx0a$$default(msg, err, msgProvider);
  };
  KLog.prototype.info_wspj0f$$default = function (msg, err) {
    this.info_9xgx0a$(msg, err, null);
  };
  KLog.prototype.info_wspj0f$ = function (msg, err, callback$default) {
    if (msg === void 0)
      msg = null;
    if (err === void 0)
      err = null;
    callback$default ? callback$default(msg, err) : this.info_wspj0f$$default(msg, err);
  };
  KLog.prototype.info_9xgx0a$ = function (msg, err, msgProvider, callback$default) {
    if (msg === void 0)
      msg = null;
    if (err === void 0)
      err = null;
    if (msgProvider === void 0)
      msgProvider = null;
    callback$default ? callback$default(msg, err, msgProvider) : this.info_9xgx0a$$default(msg, err, msgProvider);
  };
  KLog.prototype.warn_wspj0f$$default = function (msg, err) {
    this.warn_9xgx0a$(msg, err, null);
  };
  KLog.prototype.warn_wspj0f$ = function (msg, err, callback$default) {
    if (msg === void 0)
      msg = null;
    if (err === void 0)
      err = null;
    callback$default ? callback$default(msg, err) : this.warn_wspj0f$$default(msg, err);
  };
  KLog.prototype.warn_9xgx0a$ = function (msg, err, msgProvider, callback$default) {
    if (msg === void 0)
      msg = null;
    if (err === void 0)
      err = null;
    if (msgProvider === void 0)
      msgProvider = null;
    callback$default ? callback$default(msg, err, msgProvider) : this.warn_9xgx0a$$default(msg, err, msgProvider);
  };
  KLog.prototype.error_wspj0f$$default = function (msg, err) {
    this.error_9xgx0a$(msg, err, null);
  };
  KLog.prototype.error_wspj0f$ = function (msg, err, callback$default) {
    if (msg === void 0)
      msg = null;
    if (err === void 0)
      err = null;
    callback$default ? callback$default(msg, err) : this.error_wspj0f$$default(msg, err);
  };
  KLog.prototype.error_9xgx0a$ = function (msg, err, msgProvider, callback$default) {
    if (msg === void 0)
      msg = null;
    if (err === void 0)
      err = null;
    if (msgProvider === void 0)
      msgProvider = null;
    callback$default ? callback$default(msg, err, msgProvider) : this.error_9xgx0a$$default(msg, err, msgProvider);
  };
  Object.defineProperty(KLog.prototype, 'isTraceEnabled', {
    configurable: true,
    get: function () {
      return this.level.compareTo_11rb$(Level$TRACE_getInstance()) <= 0;
    }
  });
  Object.defineProperty(KLog.prototype, 'isDebugEnabled', {
    configurable: true,
    get: function () {
      return this.level.compareTo_11rb$(Level$DEBUG_getInstance()) <= 0;
    }
  });
  Object.defineProperty(KLog.prototype, 'isInfoEnabled', {
    configurable: true,
    get: function () {
      return this.level.compareTo_11rb$(Level$INFO_getInstance()) <= 0;
    }
  });
  Object.defineProperty(KLog.prototype, 'isWarnEnabled', {
    configurable: true,
    get: function () {
      return this.level.compareTo_11rb$(Level$WARN_getInstance()) <= 0;
    }
  });
  Object.defineProperty(KLog.prototype, 'isErrorEnabled', {
    configurable: true,
    get: function () {
      return this.level.compareTo_11rb$(Level$ERROR_getInstance()) <= 0;
    }
  });
  Object.defineProperty(KLog.prototype, 'isEnabled', {
    configurable: true,
    get: function () {
      return this.isErrorEnabled && !equals(this.writer, KLogWriters_getInstance().noop);
    }
  });
  KLog.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'KLog',
    interfaces: []
  };
  function KLogImpl(registry, name, _level, _writer, _messageFormatter, _nameFormatter) {
    if (_nameFormatter === void 0)
      _nameFormatter = null;
    this.registry_0 = registry;
    this.name_hgizof$_0 = name;
    this._level_0 = _level;
    this._writer_0 = _writer;
    this._messageFormatter_0 = _messageFormatter;
    this._nameFormatter_0 = _nameFormatter;
  }
  Object.defineProperty(KLogImpl.prototype, 'name', {
    get: function () {
      return this.name_hgizof$_0;
    }
  });
  function KLogImpl$set_KLogImpl$level$lambda(closure$value) {
    return function ($receiver) {
      var tmp$;
      (Kotlin.isType(tmp$ = $receiver, KLogImpl) ? tmp$ : throwCCE())._level_0 = closure$value;
      return Unit;
    };
  }
  Object.defineProperty(KLogImpl.prototype, 'level', {
    configurable: true,
    get: function () {
      return this._level_0;
    },
    set: function (value) {
      this.registry_0.applyToBranch_4ro1gf$(this.name, KLogImpl$set_KLogImpl$level$lambda(value));
    }
  });
  function KLogImpl$set_KLogImpl$writer$lambda(closure$value) {
    return function ($receiver) {
      var tmp$;
      (Kotlin.isType(tmp$ = $receiver, KLogImpl) ? tmp$ : throwCCE())._writer_0 = closure$value;
      return Unit;
    };
  }
  Object.defineProperty(KLogImpl.prototype, 'writer', {
    configurable: true,
    get: function () {
      return this._writer_0;
    },
    set: function (value) {
      this.registry_0.applyToBranch_4ro1gf$(this.name, KLogImpl$set_KLogImpl$writer$lambda(value));
    }
  });
  function KLogImpl$set_KLogImpl$messageFormatter$lambda(closure$value) {
    return function ($receiver) {
      var tmp$;
      (Kotlin.isType(tmp$ = $receiver, KLogImpl) ? tmp$ : throwCCE())._messageFormatter_0 = closure$value;
      return Unit;
    };
  }
  Object.defineProperty(KLogImpl.prototype, 'messageFormatter', {
    configurable: true,
    get: function () {
      return this._messageFormatter_0;
    },
    set: function (value) {
      this.registry_0.applyToBranch_4ro1gf$(this.name, KLogImpl$set_KLogImpl$messageFormatter$lambda(value));
    }
  });
  function KLogImpl$set_KLogImpl$nameFormatter$lambda(closure$value) {
    return function ($receiver) {
      var tmp$;
      (Kotlin.isType(tmp$ = $receiver, KLogImpl) ? tmp$ : throwCCE())._nameFormatter_0 = closure$value;
      return Unit;
    };
  }
  Object.defineProperty(KLogImpl.prototype, 'nameFormatter', {
    configurable: true,
    get: function () {
      return this._nameFormatter_0;
    },
    set: function (value) {
      this.registry_0.applyToBranch_4ro1gf$(this.name, KLogImpl$set_KLogImpl$nameFormatter$lambda(value));
    }
  });
  KLogImpl.prototype.copy_mhvu1s$$default = function (name, level, writer, messageFormatter, nameFormatter) {
    return new KLogImpl(this.registry_0, name, level, writer, messageFormatter, nameFormatter);
  };
  KLogImpl.prototype.trace_9xgx0a$$default = function (msg, err, msgProvider) {
    var level = Level$TRACE_getInstance();
    log_0$break: do {
      var tmp$, tmp$_0;
      var logWriter = this.writer;
      if (equals(logWriter, KLogWriters_getInstance().noop))
        break log_0$break;
      if (msg == null && msgProvider == null)
        throw Error_init('Either provide a message or a message provider');
      if (level.compareTo_11rb$(this.level) < 0)
        break log_0$break;
      var $receiver = ((tmp$ = msg != null ? msg : err != null ? err.message : null) != null ? tmp$ : '') + ' ' + ((tmp$_0 = msgProvider != null ? msgProvider() : null) != null ? tmp$_0 : '');
      var tmp$_1;
      var message = trim(Kotlin.isCharSequence(tmp$_1 = $receiver) ? tmp$_1 : throwCCE()).toString();
      var ctx = lazy(KLogImpl$log$lambda);
      logWriter(this.displayName, level, this.messageFormatter.call(this, this.name, level, message, err, ctx.value), err);
    }
     while (false);
  };
  KLogImpl.prototype.debug_9xgx0a$$default = function (msg, err, msgProvider) {
    var level = Level$DEBUG_getInstance();
    log_0$break: do {
      var tmp$, tmp$_0;
      var logWriter = this.writer;
      if (equals(logWriter, KLogWriters_getInstance().noop))
        break log_0$break;
      if (msg == null && msgProvider == null)
        throw Error_init('Either provide a message or a message provider');
      if (level.compareTo_11rb$(this.level) < 0)
        break log_0$break;
      var $receiver = ((tmp$ = msg != null ? msg : err != null ? err.message : null) != null ? tmp$ : '') + ' ' + ((tmp$_0 = msgProvider != null ? msgProvider() : null) != null ? tmp$_0 : '');
      var tmp$_1;
      var message = trim(Kotlin.isCharSequence(tmp$_1 = $receiver) ? tmp$_1 : throwCCE()).toString();
      var ctx = lazy(KLogImpl$log$lambda);
      logWriter(this.displayName, level, this.messageFormatter.call(this, this.name, level, message, err, ctx.value), err);
    }
     while (false);
  };
  KLogImpl.prototype.info_9xgx0a$$default = function (msg, err, msgProvider) {
    var level = Level$INFO_getInstance();
    log_0$break: do {
      var tmp$, tmp$_0;
      var logWriter = this.writer;
      if (equals(logWriter, KLogWriters_getInstance().noop))
        break log_0$break;
      if (msg == null && msgProvider == null)
        throw Error_init('Either provide a message or a message provider');
      if (level.compareTo_11rb$(this.level) < 0)
        break log_0$break;
      var $receiver = ((tmp$ = msg != null ? msg : err != null ? err.message : null) != null ? tmp$ : '') + ' ' + ((tmp$_0 = msgProvider != null ? msgProvider() : null) != null ? tmp$_0 : '');
      var tmp$_1;
      var message = trim(Kotlin.isCharSequence(tmp$_1 = $receiver) ? tmp$_1 : throwCCE()).toString();
      var ctx = lazy(KLogImpl$log$lambda);
      logWriter(this.displayName, level, this.messageFormatter.call(this, this.name, level, message, err, ctx.value), err);
    }
     while (false);
  };
  KLogImpl.prototype.warn_9xgx0a$$default = function (msg, err, msgProvider) {
    var level = Level$WARN_getInstance();
    log_0$break: do {
      var tmp$, tmp$_0;
      var logWriter = this.writer;
      if (equals(logWriter, KLogWriters_getInstance().noop))
        break log_0$break;
      if (msg == null && msgProvider == null)
        throw Error_init('Either provide a message or a message provider');
      if (level.compareTo_11rb$(this.level) < 0)
        break log_0$break;
      var $receiver = ((tmp$ = msg != null ? msg : err != null ? err.message : null) != null ? tmp$ : '') + ' ' + ((tmp$_0 = msgProvider != null ? msgProvider() : null) != null ? tmp$_0 : '');
      var tmp$_1;
      var message = trim(Kotlin.isCharSequence(tmp$_1 = $receiver) ? tmp$_1 : throwCCE()).toString();
      var ctx = lazy(KLogImpl$log$lambda);
      logWriter(this.displayName, level, this.messageFormatter.call(this, this.name, level, message, err, ctx.value), err);
    }
     while (false);
  };
  KLogImpl.prototype.error_9xgx0a$$default = function (msg, err, msgProvider) {
    var level = Level$ERROR_getInstance();
    log_0$break: do {
      var tmp$, tmp$_0;
      var logWriter = this.writer;
      if (equals(logWriter, KLogWriters_getInstance().noop))
        break log_0$break;
      if (msg == null && msgProvider == null)
        throw Error_init('Either provide a message or a message provider');
      if (level.compareTo_11rb$(this.level) < 0)
        break log_0$break;
      var $receiver = ((tmp$ = msg != null ? msg : err != null ? err.message : null) != null ? tmp$ : '') + ' ' + ((tmp$_0 = msgProvider != null ? msgProvider() : null) != null ? tmp$_0 : '');
      var tmp$_1;
      var message = trim(Kotlin.isCharSequence(tmp$_1 = $receiver) ? tmp$_1 : throwCCE()).toString();
      var ctx = lazy(KLogImpl$log$lambda);
      logWriter(this.displayName, level, this.messageFormatter.call(this, this.name, level, message, err, ctx.value), err);
    }
     while (false);
  };
  KLogImpl.prototype.log_0 = wrapFunction(function () {
    var throwCCE = Kotlin.throwCCE;
    var trim = Kotlin.kotlin.text.trim_gw00vp$;
    function KLogImpl$log$lambda() {
      return platformStatementContext();
    }
    return function (level, msg, err, msgProvider) {
      var tmp$, tmp$_0;
      var logWriter = this.writer;
      if (equals(logWriter, KLogWriters_getInstance().noop))
        return;
      if (msg == null && msgProvider == null)
        throw Error_init('Either provide a message or a message provider');
      if (level.compareTo_11rb$(this.level) < 0)
        return;
      var $receiver = ((tmp$ = msg != null ? msg : err != null ? err.message : null) != null ? tmp$ : '') + ' ' + ((tmp$_0 = msgProvider != null ? msgProvider() : null) != null ? tmp$_0 : '');
      var tmp$_1;
      var message = trim(Kotlin.isCharSequence(tmp$_1 = $receiver) ? tmp$_1 : throwCCE()).toString();
      var ctx = lazy(KLogImpl$log$lambda);
      logWriter(this.displayName, level, this.messageFormatter.call(this, this.name, level, message, err, ctx.value), err);
    };
  });
  KLogImpl.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'KLogImpl',
    interfaces: [KLog]
  };
  KLogImpl.prototype.component1_0 = function () {
    return this.registry_0;
  };
  KLogImpl.prototype.component2 = function () {
    return this.name;
  };
  KLogImpl.prototype.component3_0 = function () {
    return this._level_0;
  };
  KLogImpl.prototype.component4_0 = function () {
    return this._writer_0;
  };
  KLogImpl.prototype.component5_0 = function () {
    return this._messageFormatter_0;
  };
  KLogImpl.prototype.component6_0 = function () {
    return this._nameFormatter_0;
  };
  KLogImpl.prototype.copy_5rt4tr$ = function (registry, name, _level, _writer, _messageFormatter, _nameFormatter) {
    return new KLogImpl(registry === void 0 ? this.registry_0 : registry, name === void 0 ? this.name : name, _level === void 0 ? this._level_0 : _level, _writer === void 0 ? this._writer_0 : _writer, _messageFormatter === void 0 ? this._messageFormatter_0 : _messageFormatter, _nameFormatter === void 0 ? this._nameFormatter_0 : _nameFormatter);
  };
  KLogImpl.prototype.toString = function () {
    return 'KLogImpl(registry=' + Kotlin.toString(this.registry_0) + (', name=' + Kotlin.toString(this.name)) + (', _level=' + Kotlin.toString(this._level_0)) + (', _writer=' + Kotlin.toString(this._writer_0)) + (', _messageFormatter=' + Kotlin.toString(this._messageFormatter_0)) + (', _nameFormatter=' + Kotlin.toString(this._nameFormatter_0)) + ')';
  };
  KLogImpl.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.registry_0) | 0;
    result = result * 31 + Kotlin.hashCode(this.name) | 0;
    result = result * 31 + Kotlin.hashCode(this._level_0) | 0;
    result = result * 31 + Kotlin.hashCode(this._writer_0) | 0;
    result = result * 31 + Kotlin.hashCode(this._messageFormatter_0) | 0;
    result = result * 31 + Kotlin.hashCode(this._nameFormatter_0) | 0;
    return result;
  };
  KLogImpl.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.registry_0, other.registry_0) && Kotlin.equals(this.name, other.name) && Kotlin.equals(this._level_0, other._level_0) && Kotlin.equals(this._writer_0, other._writer_0) && Kotlin.equals(this._messageFormatter_0, other._messageFormatter_0) && Kotlin.equals(this._nameFormatter_0, other._nameFormatter_0)))));
  };
  function KLogRegistry() {
    KLogRegistry$Companion_getInstance();
  }
  function KLogRegistry$Companion() {
    KLogRegistry$Companion_instance = this;
    this.ROOT_LOG_NAME = '';
  }
  KLogRegistry$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var KLogRegistry$Companion_instance = null;
  function KLogRegistry$Companion_getInstance() {
    if (KLogRegistry$Companion_instance === null) {
      new KLogRegistry$Companion();
    }
    return KLogRegistry$Companion_instance;
  }
  KLogRegistry.prototype.get_3jim8h$ = defineInlineFunction('klog.org.danbrough.klog.KLogRegistry.get_3jim8h$', function (name, level, writer, messageFormatter, nameFormatter) {
    if (level === void 0)
      level = null;
    if (writer === void 0)
      writer = null;
    if (messageFormatter === void 0)
      messageFormatter = null;
    if (nameFormatter === void 0)
      nameFormatter = null;
    var $receiver = this.get_61zpoe$(name);
    if (level != null)
      $receiver.level = level;
    if (messageFormatter != null)
      $receiver.messageFormatter = messageFormatter;
    if (writer != null)
      $receiver.writer = writer;
    if (nameFormatter != null)
      $receiver.nameFormatter = nameFormatter;
    return $receiver;
  });
  KLogRegistry.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'KLogRegistry',
    interfaces: []
  };
  function DefaultLogRegistry(level, formatter, writer) {
    if (level === void 0)
      level = Level$WARN_getInstance();
    if (formatter === void 0)
      formatter = KMessageFormatters_getInstance().simple;
    if (writer === void 0)
      writer = KLogWriters_getInstance().noop;
    KLogRegistry.call(this);
    this.logs_1mp3pe$_0 = LinkedHashMap_init();
    var $receiver = this.logs_1mp3pe$_0;
    var key = KLogRegistry$Companion_getInstance().ROOT_LOG_NAME;
    var value = new KLogImpl(this, KLogRegistry$Companion_getInstance().ROOT_LOG_NAME, level, writer, formatter);
    $receiver.put_xwzc9p$(key, value);
  }
  DefaultLogRegistry.prototype.get_61zpoe$ = function (name) {
    var tmp$;
    var tmp$_0;
    if ((tmp$ = this.logs_1mp3pe$_0.get_11rb$(name)) != null)
      tmp$_0 = tmp$;
    else {
      var $receiver = this.getParent_7hni3$_0(name).copy_mhvu1s$(name);
      var tmp$_1;
      var $receiver_0 = this.logs_1mp3pe$_0;
      var value = Kotlin.isType(tmp$_1 = $receiver, KLogImpl) ? tmp$_1 : throwCCE();
      $receiver_0.put_xwzc9p$(name, value);
      tmp$_0 = $receiver;
    }
    return tmp$_0;
  };
  DefaultLogRegistry.prototype.getParent_7hni3$_0 = function (name) {
    var parentName = substringBeforeLast(name, 46, KLogRegistry$Companion_getInstance().ROOT_LOG_NAME);
    var tmp$;
    return (tmp$ = this.logs_1mp3pe$_0.get_11rb$(parentName)) != null ? tmp$ : this.getParent_7hni3$_0(parentName);
  };
  DefaultLogRegistry.prototype.getLogs = function () {
    return toSet(this.logs_1mp3pe$_0.values);
  };
  DefaultLogRegistry.prototype.applyToBranch_4ro1gf$ = function (name, toApply) {
    var tmp$;
    tmp$ = this.logs_1mp3pe$_0.entries.iterator();
    while (tmp$.hasNext()) {
      var element = tmp$.next();
      if (equals(element.key, name) || startsWith(element.key, name + '.'))
        toApply(element.value);
    }
  };
  DefaultLogRegistry.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'DefaultLogRegistry',
    interfaces: [KLogRegistry]
  };
  function KMessageFormatters$colored$lambda(closure$formatter) {
    return function (name, level, msg, exception, context) {
      return '\x1B' + '[0;' + get_color(level) + 'm' + closure$formatter(name, level, msg, exception, context) + '\x1B' + '[0m';
    };
  }
  function get_color($receiver) {
    switch ($receiver.name) {
      case 'TRACE':
        return 35;
      case 'DEBUG':
        return 36;
      case 'INFO':
        return 32;
      case 'WARN':
        return 33;
      default:
        return 31;
    }
  }
  function KMessageFormatters() {
    KMessageFormatters_instance = this;
    this.simple = KMessageFormatters$simple$lambda;
    this.verbose = KMessageFormatters$verbose$lambda;
  }
  KMessageFormatters.prototype.colored_ldbrso$ = defineInlineFunction('klog.org.danbrough.klog.KMessageFormatters.colored_ldbrso$', wrapFunction(function () {
    var get_color = _.org.danbrough.klog.get_color_g35gi8$;
    function KMessageFormatters$colored$lambda(closure$formatter) {
      return function (name, level, msg, exception, context) {
        return '\x1B' + '[0;' + get_color(level) + 'm' + closure$formatter(name, level, msg, exception, context) + '\x1B' + '[0m';
      };
    }
    return function (formatter) {
      return KMessageFormatters$colored$lambda(formatter);
    };
  }));
  function KMessageFormatters$simple$lambda(name, level, msg, exception, f) {
    var tmp$, tmp$_0;
    var it = level.toString();
    var l = it.length < 5 ? ' ' + it + ':' : it + ':';
    return l + name + ': ' + msg + ' ' + ((tmp$_0 = (tmp$ = exception != null ? stackTraceToString(exception) : null) != null ? ' :' + tmp$ : null) != null ? tmp$_0 : '');
  }
  function KMessageFormatters$verbose$lambda(name, level, msg, exception, ctx) {
    var $receiver = StringBuilder_init();
    var tmp$, tmp$_0, tmp$_1, tmp$_2;
    var it = level.toString();
    $receiver.append_pdl1vj$(it.length < 5 ? ' ' + it + ':' : it + ':');
    $receiver.append_pdl1vj$(name);
    $receiver.append_s8itvh$(9);
    var threadID = ctx.threadID;
    if (threadID.length > 0)
      $receiver.append_pdl1vj$('<' + threadID + '>');
    var tmp$_3;
    if ((tmp$_0 = (tmp$ = ctx.line) != null ? tmp$.functionName : null) != null) {
      $receiver.append_pdl1vj$(toString(ctx.line.fileName) + ':' + ctx.line.lineNumber + ':' + tmp$_0 + '(): ');
      tmp$_3 = tmp$_0;
    } else
      tmp$_3 = null;
    (tmp$_1 = tmp$_3) != null ? tmp$_1 : $receiver.append_pdl1vj$(' ');
    $receiver.append_pdl1vj$(msg);
    if ((tmp$_2 = exception != null ? stackTraceToString(exception) : null) != null) {
      $receiver.append_pdl1vj$(' :' + tmp$_2);
    }
    return $receiver.toString();
  }
  KMessageFormatters.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'KMessageFormatters',
    interfaces: []
  };
  var KMessageFormatters_instance = null;
  function KMessageFormatters_getInstance() {
    if (KMessageFormatters_instance === null) {
      new KMessageFormatters();
    }
    return KMessageFormatters_instance;
  }
  function get_colored($receiver) {
    return KMessageFormatters$colored$lambda($receiver);
  }
  function Level(name, ordinal) {
    Enum.call(this);
    this.name$ = name;
    this.ordinal$ = ordinal;
  }
  function Level_initFields() {
    Level_initFields = function () {
    };
    Level$TRACE_instance = new Level('TRACE', 0);
    Level$DEBUG_instance = new Level('DEBUG', 1);
    Level$INFO_instance = new Level('INFO', 2);
    Level$WARN_instance = new Level('WARN', 3);
    Level$ERROR_instance = new Level('ERROR', 4);
  }
  var Level$TRACE_instance;
  function Level$TRACE_getInstance() {
    Level_initFields();
    return Level$TRACE_instance;
  }
  var Level$DEBUG_instance;
  function Level$DEBUG_getInstance() {
    Level_initFields();
    return Level$DEBUG_instance;
  }
  var Level$INFO_instance;
  function Level$INFO_getInstance() {
    Level_initFields();
    return Level$INFO_instance;
  }
  var Level$WARN_instance;
  function Level$WARN_getInstance() {
    Level_initFields();
    return Level$WARN_instance;
  }
  var Level$ERROR_instance;
  function Level$ERROR_getInstance() {
    Level_initFields();
    return Level$ERROR_instance;
  }
  Level.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Level',
    interfaces: [Enum]
  };
  function Level$values() {
    return [Level$TRACE_getInstance(), Level$DEBUG_getInstance(), Level$INFO_getInstance(), Level$WARN_getInstance(), Level$ERROR_getInstance()];
  }
  Level.values = Level$values;
  function Level$valueOf(name) {
    switch (name) {
      case 'TRACE':
        return Level$TRACE_getInstance();
      case 'DEBUG':
        return Level$DEBUG_getInstance();
      case 'INFO':
        return Level$INFO_getInstance();
      case 'WARN':
        return Level$WARN_getInstance();
      case 'ERROR':
        return Level$ERROR_getInstance();
      default:
        throwISE('No enum constant org.danbrough.klog.Level.' + name);
    }
  }
  Level.valueOf_61zpoe$ = Level$valueOf;
  var kLogRegistry;
  var klog = defineInlineFunction('klog.org.danbrough.klog.klog_irb06o$', wrapFunction(function () {
    var klog = _.org.danbrough.klog;
    var klogName = _.org.danbrough.klog.klogName_lr8r8q$;
    return function (T_0, isT, $receiver) {
      var $receiver_0 = klog.kLogRegistry.get_61zpoe$(klogName(Kotlin.getKClassFromExpression($receiver)));
      if (null != null)
        $receiver_0.level = null;
      if (null != null)
        $receiver_0.messageFormatter = null;
      if (null != null)
        $receiver_0.writer = null;
      if (null != null)
        $receiver_0.nameFormatter = null;
      return $receiver_0;
    };
  }));
  var klog_0 = defineInlineFunction('klog.org.danbrough.klog.klog_hhpxq3$', wrapFunction(function () {
    var klog = _.org.danbrough.klog;
    var klogName = _.org.danbrough.klog.klogName_lr8r8q$;
    return function (T_0, isT, $receiver, level, writer, messageFormatter, nameFormatter) {
      if (level === void 0)
        level = null;
      if (writer === void 0)
        writer = null;
      if (messageFormatter === void 0)
        messageFormatter = null;
      if (nameFormatter === void 0)
        nameFormatter = null;
      var $receiver_0 = klog.kLogRegistry.get_61zpoe$(klogName(Kotlin.getKClassFromExpression($receiver)));
      if (level != null)
        $receiver_0.level = level;
      if (messageFormatter != null)
        $receiver_0.messageFormatter = messageFormatter;
      if (writer != null)
        $receiver_0.writer = writer;
      if (nameFormatter != null)
        $receiver_0.nameFormatter = nameFormatter;
      return $receiver_0;
    };
  }));
  var klog_1 = defineInlineFunction('klog.org.danbrough.klog.klog_akr2j9$', wrapFunction(function () {
    var klog = _.org.danbrough.klog;
    var klogName = _.org.danbrough.klog.klogName_lr8r8q$;
    return function (T_0, isT, $receiver, config) {
      var $receiver_0 = klog.kLogRegistry.get_61zpoe$(klogName(Kotlin.getKClassFromExpression($receiver)));
      if (null != null)
        $receiver_0.level = null;
      if (null != null)
        $receiver_0.messageFormatter = null;
      if (null != null)
        $receiver_0.writer = null;
      if (null != null)
        $receiver_0.nameFormatter = null;
      config($receiver_0);
      return $receiver_0;
    };
  }));
  var klog_2 = defineInlineFunction('klog.org.danbrough.klog.klog_3jim8h$', wrapFunction(function () {
    var klog = _.org.danbrough.klog;
    return function (name, level, writer, messageFormatter, nameFormatter) {
      if (level === void 0)
        level = null;
      if (writer === void 0)
        writer = null;
      if (messageFormatter === void 0)
        messageFormatter = null;
      if (nameFormatter === void 0)
        nameFormatter = null;
      var $receiver = klog.kLogRegistry.get_61zpoe$(name);
      if (level != null)
        $receiver.level = level;
      if (messageFormatter != null)
        $receiver.messageFormatter = messageFormatter;
      if (writer != null)
        $receiver.writer = writer;
      if (nameFormatter != null)
        $receiver.nameFormatter = nameFormatter;
      return $receiver;
    };
  }));
  var klog_3 = defineInlineFunction('klog.org.danbrough.klog.klog_61zpoe$', wrapFunction(function () {
    var klog = _.org.danbrough.klog;
    return function (name) {
      var $receiver = klog.kLogRegistry.get_61zpoe$(name);
      if (null != null)
        $receiver.level = null;
      if (null != null)
        $receiver.messageFormatter = null;
      if (null != null)
        $receiver.writer = null;
      if (null != null)
        $receiver.nameFormatter = null;
      return $receiver;
    };
  }));
  var klog_4 = defineInlineFunction('klog.org.danbrough.klog.klog_999fca$', wrapFunction(function () {
    var klog = _.org.danbrough.klog;
    var klogName = _.org.danbrough.klog.klogName_lr8r8q$;
    return function (clazz, level, writer, messageFormatter, nameFormatter) {
      if (level === void 0)
        level = null;
      if (writer === void 0)
        writer = null;
      if (messageFormatter === void 0)
        messageFormatter = null;
      if (nameFormatter === void 0)
        nameFormatter = null;
      var $receiver = klog.kLogRegistry.get_61zpoe$(klogName(clazz));
      if (level != null)
        $receiver.level = level;
      if (messageFormatter != null)
        $receiver.messageFormatter = messageFormatter;
      if (writer != null)
        $receiver.writer = writer;
      if (nameFormatter != null)
        $receiver.nameFormatter = nameFormatter;
      return $receiver;
    };
  }));
  function KLogWriters() {
    KLogWriters_instance = this;
    this.noop = KLogWriters$noop$lambda;
    this.stdOut = KLogWriters$stdOut$lambda;
  }
  function KLogWriters$noop$lambda(f, f_0, f_1, f_2) {
    return Unit;
  }
  function KLogWriters$stdOut$lambda(f, f_0, msg, f_1) {
    println(msg);
    return Unit;
  }
  KLogWriters.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'KLogWriters',
    interfaces: []
  };
  var KLogWriters_instance = null;
  function KLogWriters_getInstance() {
    if (KLogWriters_instance === null) {
      new KLogWriters();
    }
    return KLogWriters_instance;
  }
  function platformStatementContext() {
    return new StatementContext('js', '');
  }
  function createKLogRegistry$ObjectLiteral(level, formatter, writer) {
    DefaultLogRegistry.call(this, level, formatter, writer);
  }
  createKLogRegistry$ObjectLiteral.$metadata$ = {
    kind: Kind_CLASS,
    interfaces: [DefaultLogRegistry]
  };
  function createKLogRegistry() {
    return new createKLogRegistry$ObjectLiteral();
  }
  function klogName($receiver) {
    return ensureNotNull($receiver.simpleName);
  }
  function getTimeMillis() {
    return L_1;
  }
  var package$org = _.org || (_.org = {});
  var package$danbrough = package$org.danbrough || (package$org.danbrough = {});
  var package$klog = package$danbrough.klog || (package$danbrough.klog = {});
  package$klog.Hex = Hex;
  StatementContext.LineContext = StatementContext$LineContext;
  package$klog.StatementContext = StatementContext;
  package$klog.KLog = KLog;
  $$importsForInline$$.klog = _;
  package$klog.KLogImpl = KLogImpl;
  Object.defineProperty(KLogRegistry, 'Companion', {
    get: KLogRegistry$Companion_getInstance
  });
  package$klog.KLogRegistry = KLogRegistry;
  package$klog.DefaultLogRegistry = DefaultLogRegistry;
  package$klog.get_color_g35gi8$ = get_color;
  Object.defineProperty(package$klog, 'KMessageFormatters', {
    get: KMessageFormatters_getInstance
  });
  package$klog.get_colored_n74fxz$ = get_colored;
  Object.defineProperty(Level, 'TRACE', {
    get: Level$TRACE_getInstance
  });
  Object.defineProperty(Level, 'DEBUG', {
    get: Level$DEBUG_getInstance
  });
  Object.defineProperty(Level, 'INFO', {
    get: Level$INFO_getInstance
  });
  Object.defineProperty(Level, 'WARN', {
    get: Level$WARN_getInstance
  });
  Object.defineProperty(Level, 'ERROR', {
    get: Level$ERROR_getInstance
  });
  package$klog.Level = Level;
  Object.defineProperty(package$klog, 'kLogRegistry', {
    get: function () {
      return kLogRegistry;
    }
  });
  package$klog.klogName_lr8r8q$ = klogName;
  package$klog.klog_3jim8h$ = klog_2;
  package$klog.klog_61zpoe$ = klog_3;
  package$klog.klog_999fca$ = klog_4;
  Object.defineProperty(package$klog, 'KLogWriters', {
    get: KLogWriters_getInstance
  });
  package$klog.platformStatementContext = platformStatementContext;
  package$klog.createKLogRegistry = createKLogRegistry;
  package$klog.getTimeMillis = getTimeMillis;
  KLogImpl.prototype.trace_wspj0f$$default = KLog.prototype.trace_wspj0f$$default;
  KLogImpl.prototype.debug_wspj0f$$default = KLog.prototype.debug_wspj0f$$default;
  KLogImpl.prototype.info_wspj0f$$default = KLog.prototype.info_wspj0f$$default;
  KLogImpl.prototype.warn_wspj0f$$default = KLog.prototype.warn_wspj0f$$default;
  KLogImpl.prototype.error_wspj0f$$default = KLog.prototype.error_wspj0f$$default;
  Object.defineProperty(KLogImpl.prototype, 'displayName', Object.getOwnPropertyDescriptor(KLog.prototype, 'displayName'));
  Object.defineProperty(KLogImpl.prototype, 'isTraceEnabled', Object.getOwnPropertyDescriptor(KLog.prototype, 'isTraceEnabled'));
  Object.defineProperty(KLogImpl.prototype, 'isDebugEnabled', Object.getOwnPropertyDescriptor(KLog.prototype, 'isDebugEnabled'));
  Object.defineProperty(KLogImpl.prototype, 'isInfoEnabled', Object.getOwnPropertyDescriptor(KLog.prototype, 'isInfoEnabled'));
  Object.defineProperty(KLogImpl.prototype, 'isWarnEnabled', Object.getOwnPropertyDescriptor(KLog.prototype, 'isWarnEnabled'));
  Object.defineProperty(KLogImpl.prototype, 'isErrorEnabled', Object.getOwnPropertyDescriptor(KLog.prototype, 'isErrorEnabled'));
  Object.defineProperty(KLogImpl.prototype, 'isEnabled', Object.getOwnPropertyDescriptor(KLog.prototype, 'isEnabled'));
  KLogImpl.prototype.copy_mhvu1s$ = KLog.prototype.copy_mhvu1s$;
  KLogImpl.prototype.trace_9xgx0a$ = KLog.prototype.trace_9xgx0a$;
  KLogImpl.prototype.trace_wspj0f$ = KLog.prototype.trace_wspj0f$;
  KLogImpl.prototype.debug_9xgx0a$ = KLog.prototype.debug_9xgx0a$;
  KLogImpl.prototype.debug_wspj0f$ = KLog.prototype.debug_wspj0f$;
  KLogImpl.prototype.info_9xgx0a$ = KLog.prototype.info_9xgx0a$;
  KLogImpl.prototype.info_wspj0f$ = KLog.prototype.info_wspj0f$;
  KLogImpl.prototype.warn_9xgx0a$ = KLog.prototype.warn_9xgx0a$;
  KLogImpl.prototype.warn_wspj0f$ = KLog.prototype.warn_wspj0f$;
  KLogImpl.prototype.error_9xgx0a$ = KLog.prototype.error_9xgx0a$;
  KLogImpl.prototype.error_wspj0f$ = KLog.prototype.error_wspj0f$;
  kLogRegistry = createKLogRegistry();
  Kotlin.defineModule('klog', _);
  return _;
}));

//# sourceMappingURL=klog.js.map
