/*
 * Decompiled with CFR 0.152.
 */
package org.daijie.social.login.weixin.service;

import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.daijie.core.util.http.HttpConversationUtil;
import org.daijie.social.login.AbstractLoginService;
import org.daijie.social.login.LoginResult;
import org.daijie.social.login.weixin.WeixinLoignProperties;
import org.daijie.social.login.weixin.model.WeixinAccessToken;
import org.daijie.social.login.weixin.model.WeixinError;
import org.daijie.social.login.weixin.model.WeixinUserInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class WeixinLoginService
extends AbstractLoginService<WeixinLoignProperties> {
    private static final Logger logger = LoggerFactory.getLogger(WeixinLoginService.class);

    public LoginResult getAccessToken(String code) {
        StringBuilder uri = new StringBuilder();
        uri.append("https://api.weixin.qq.com/sns/oauth2/access_token?appid=");
        uri.append(((WeixinLoignProperties)this.properties).getAppid());
        uri.append("&secret=").append(((WeixinLoignProperties)this.properties).getAppsecret());
        uri.append("&code=" + code).append("&grant_type=authorization_code");
        try {
            String result = (String)this.restTemplate.getForObject(uri.toString(), String.class, new Object[0]);
            JSONObject json = JSONUtil.parseObj((String)result);
            if (json.getStr((Object)"access_token") != null) {
                WeixinAccessToken accessToken = new WeixinAccessToken();
                accessToken.setAccess_token(json.getStr((Object)"access_token"));
                accessToken.setOpenid(json.getStr((Object)"open_id"));
                accessToken.setExpires_in(json.getLong((Object)"expires_in"));
                accessToken.setRefresh_token(json.getStr((Object)"refresh_token"));
                accessToken.setScope(json.getStr((Object)"scope"));
                return accessToken;
            }
            WeixinError error = new WeixinError();
            error.setErrcode(json.getStr((Object)"errcode"));
            error.setErrmsg(json.getStr((Object)"errmsg"));
            return error;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public LoginResult refreshToken(String refresh_token) {
        StringBuilder uri = new StringBuilder();
        uri.append("https://api.weixin.qq.com/sns/oauth2/refresh_token?appid=");
        uri.append(((WeixinLoignProperties)this.properties).getAppid());
        uri.append("&refresh_token=" + refresh_token).append("&grant_type=refresh_token");
        try {
            String result = (String)this.restTemplate.getForObject(uri.toString(), String.class, new Object[0]);
            JSONObject json = JSONUtil.parseObj((String)result);
            if (json.getStr((Object)"access_token") != null) {
                WeixinAccessToken accessToken = new WeixinAccessToken();
                accessToken.setAccess_token(json.getStr((Object)"access_token"));
                accessToken.setOpenid(json.getStr((Object)"open_id"));
                accessToken.setExpires_in(json.getLong((Object)"expires_in"));
                accessToken.setRefresh_token(json.getStr((Object)"refresh_token"));
                accessToken.setScope(json.getStr((Object)"scope"));
                return accessToken;
            }
            WeixinError error = new WeixinError();
            error.setErrcode(json.getStr((Object)"errcode"));
            error.setErrmsg(json.getStr((Object)"errmsg"));
            return error;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public LoginResult verifyToken(String access_token) {
        StringBuilder uri = new StringBuilder();
        uri.append("https://api.weixin.qq.com/sns/auth?appid=");
        uri.append(((WeixinLoignProperties)this.properties).getAppid());
        uri.append("&access_token=" + access_token);
        try {
            String result = (String)this.restTemplate.getForObject(uri.toString(), String.class, new Object[0]);
            JSONObject json = JSONUtil.parseObj((String)result);
            WeixinError error = new WeixinError();
            error.setErrcode(json.getStr((Object)"errcode"));
            error.setErrmsg(json.getStr((Object)"errmsg"));
            return error;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public LoginResult getUserInfo(String access_token) {
        StringBuilder uri = new StringBuilder();
        uri.append("https://api.weixin.qq.com/sns/userinfo?appid=");
        uri.append(((WeixinLoignProperties)this.properties).getAppid());
        uri.append("&access_token=" + access_token);
        try {
            String result = (String)this.restTemplate.getForObject(uri.toString(), String.class, new Object[0]);
            JSONObject json = JSONUtil.parseObj((String)result);
            ObjectMapper mapper = new ObjectMapper();
            if (json.getStr((Object)"openid") != null) {
                WeixinUserInfo userInfo = (WeixinUserInfo)mapper.readValue(result, WeixinUserInfo.class);
                return userInfo;
            }
            WeixinError error = (WeixinError)mapper.readValue(result, WeixinError.class);
            return error;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public String loadQrcode(String state) {
        String callback = "weixin/login/Callback";
        if (!StringUtils.isEmpty((Object)((WeixinLoignProperties)this.properties).getCallbackUri())) {
            callback = ((WeixinLoignProperties)this.properties).getCallbackUri();
        }
        if (!callback.contains("http")) {
            String serverName = HttpConversationUtil.getRequest().getServerName();
            callback = serverName + callback;
        }
        StringBuilder uri = new StringBuilder();
        uri.append("https://open.weixin.qq.com/connect/qrconnect?appid=");
        uri.append(((WeixinLoignProperties)this.properties).getAppid());
        uri.append("&redirect_uri=" + callback);
        uri.append("&response_type=code&scope=snsapi_login");
        uri.append("&state=" + state);
        return "redirect:" + uri.toString();
    }

    @Override
    public String loadAuthPage(String state) {
        return null;
    }
}

