/*
 * Decompiled with CFR 0.152.
 */
package org.daijie.social.login.qq.service;

import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.daijie.core.util.http.HttpConversationUtil;
import org.daijie.social.login.AbstractLoginService;
import org.daijie.social.login.LoginResult;
import org.daijie.social.login.qq.QQLoignProperties;
import org.daijie.social.login.qq.model.QQAccessToken;
import org.daijie.social.login.qq.model.QQError;
import org.daijie.social.login.qq.model.QQUser;
import org.daijie.social.login.qq.model.QQUserInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class QQLoginService
extends AbstractLoginService<QQLoignProperties> {
    private static final Logger logger = LoggerFactory.getLogger(QQLoginService.class);

    public LoginResult getAccessToken(String code) {
        StringBuilder uri = new StringBuilder();
        uri.append("https://graph.qq.com/oauth2.0/token?client_id=");
        uri.append(((QQLoignProperties)this.properties).getAppid());
        uri.append("&client_secret=").append(((QQLoignProperties)this.properties).getAppsecret());
        uri.append("&code=" + code).append("&grant_type=authorization_code");
        try {
            String result = (String)this.restTemplate.getForObject(uri.toString(), String.class, new Object[0]);
            JSONObject json = JSONUtil.parseObj((String)result);
            ObjectMapper mapper = new ObjectMapper();
            if (json.getStr((Object)"access_token") != null) {
                QQAccessToken accessToken = (QQAccessToken)mapper.readValue(result, QQAccessToken.class);
                return accessToken;
            }
            QQError error = new QQError();
            error.setErrcode(json.getStr((Object)"code"));
            error.setErrmsg(json.getStr((Object)"msg"));
            return error;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public LoginResult getOpenid(String access_token) {
        StringBuilder uri = new StringBuilder();
        uri.append("https://graph.qq.com/oauth2.0/me?");
        uri.append("access_token=" + access_token);
        try {
            String result = (String)this.restTemplate.getForObject(uri.toString(), String.class, new Object[0]);
            JSONObject json = JSONUtil.parseObj((String)result);
            if (json.getStr((Object)"openid") != null) {
                QQUser user = new QQUser();
                user.setAppid(json.getStr((Object)"client_id"));
                user.setOpenid(json.getStr((Object)"openid"));
                return user;
            }
            QQError error = new QQError();
            error.setErrcode(json.getStr((Object)"ret"));
            error.setErrmsg(json.getStr((Object)"msg"));
            return error;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public LoginResult getUserInfo(String access_token, String appid, String openid) {
        StringBuilder uri = new StringBuilder();
        uri.append("https://graph.qq.com/user/get_user_info?oauth_consumer_key=");
        uri.append(appid);
        uri.append("&openid=" + openid);
        uri.append("&access_token=" + access_token);
        try {
            String result = (String)this.restTemplate.getForObject(uri.toString(), String.class, new Object[0]);
            JSONObject json = JSONUtil.parseObj((String)result);
            ObjectMapper mapper = new ObjectMapper();
            if (json.getInt((Object)"ret") == 0) {
                QQUserInfo userInfo = (QQUserInfo)mapper.readValue(result, QQUserInfo.class);
                return userInfo;
            }
            QQError error = new QQError();
            error.setErrcode(json.getStr((Object)"ret"));
            error.setErrmsg(json.getStr((Object)"msg"));
            return error;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public String loadAuthPage(String state) {
        String callback = "qq/login/Callback";
        if (!StringUtils.isEmpty((Object)((QQLoignProperties)this.properties).getCallbackUri())) {
            callback = ((QQLoignProperties)this.properties).getCallbackUri();
        }
        if (!callback.contains("http")) {
            String serverName = HttpConversationUtil.getRequest().getServerName();
            callback = serverName + callback;
        }
        StringBuilder uri = new StringBuilder();
        uri.append("https://graph.qq.com/oauth2.0/authorize?client_id=");
        uri.append(((QQLoignProperties)this.properties).getAppid());
        uri.append("&redirect_uri=" + callback);
        uri.append("&response_type=code");
        uri.append("&state=" + state);
        return "redirect:" + uri.toString();
    }

    @Override
    public String loadQrcode(String state) {
        return null;
    }

    @Override
    public LoginResult getUserInfo(String voucher) {
        LoginResult openidResult = this.getOpenid(voucher);
        if (openidResult.getResult().booleanValue()) {
            QQUser user = (QQUser)openidResult;
            return this.getUserInfo(voucher, user.getAppid(), user.getOpenid());
        }
        return openidResult;
    }
}

