/*
 * Decompiled with CFR 0.152.
 */
package org.daijie.social.login.baidu;

import org.daijie.social.login.LoginResult;
import org.daijie.social.login.baidu.callback.BaiduLoginCallback;
import org.daijie.social.login.baidu.model.BaiduAccessToken;
import org.daijie.social.login.baidu.model.BaiduError;
import org.daijie.social.login.baidu.model.BaiduUserInfo;
import org.daijie.social.login.baidu.service.BaiduLoginService;
import org.springframework.beans.factory.annotation.Autowired;

public class BaiduLoginTool {
    private static BaiduLoginService baiduLoginService;

    @Autowired
    public void setBaiduLoginService(BaiduLoginService baiduLoginService) {
        BaiduLoginTool.baiduLoginService = baiduLoginService;
    }

    public static String login(String appAuthCode, BaiduLoginCallback callback) {
        BaiduAccessToken accessToken;
        LoginResult result = baiduLoginService.getAccessToken(appAuthCode);
        if (result.getResult().booleanValue() && (result = baiduLoginService.getUserInfo((accessToken = (BaiduAccessToken)result).getAccess_token())).getResult().booleanValue()) {
            BaiduUserInfo userInfo = (BaiduUserInfo)result;
            callback.handle(userInfo);
            return baiduLoginService.getRedirectUrl();
        }
        callback.errer((BaiduError)result);
        return baiduLoginService.getErrorUrl();
    }

    public static String loadQrcode(String state) {
        return baiduLoginService.loadQrcode(state);
    }

    public static String loadAuthPage(String state) {
        return baiduLoginService.loadAuthPage(state);
    }
}

