/*
 * Decompiled with CFR 0.152.
 */
package org.daijie.social.login;

import org.daijie.core.util.bean.ApplicationContextHolder;
import org.daijie.social.login.LoginCallback;
import org.daijie.social.login.LoginProperties;
import org.daijie.social.login.LoginService;
import org.daijie.social.login.SocialLoginType;
import org.daijie.social.login.ali.AliLoginTool;
import org.daijie.social.login.ali.callback.AliLoginCallback;
import org.daijie.social.login.ali.service.AliLoginService;
import org.daijie.social.login.baidu.BaiduLoginTool;
import org.daijie.social.login.baidu.callback.BaiduLoginCallback;
import org.daijie.social.login.baidu.service.BaiduLoginService;
import org.daijie.social.login.qq.QQLoginTool;
import org.daijie.social.login.qq.callback.QQLoginCallback;
import org.daijie.social.login.qq.service.QQLoginService;
import org.daijie.social.login.sina.SinaLoginTool;
import org.daijie.social.login.sina.callback.SinaLoginCallback;
import org.daijie.social.login.sina.service.SinaLoginService;
import org.daijie.social.login.weixin.WeixinLoginTool;
import org.daijie.social.login.weixin.callback.WeixinLoginCallback;
import org.daijie.social.login.weixin.service.WeixinLoginService;

public class LoginTool {
    public static <T extends LoginProperties> T getProperties(SocialLoginType socialLogin) {
        if (LoginTool.getService(socialLogin) == null) {
            return null;
        }
        return LoginTool.getService(socialLogin).getProperties();
    }

    private static <T extends LoginService> T getService(SocialLoginType socialLogin) {
        switch (socialLogin) {
            case ALI: {
                return (T)((LoginService)ApplicationContextHolder.getBean((String)"aliLoginService", AliLoginService.class));
            }
            case BAIDU: {
                return (T)((LoginService)ApplicationContextHolder.getBean((String)"baiduLoginService", BaiduLoginService.class));
            }
            case QQ: {
                return (T)((LoginService)ApplicationContextHolder.getBean((String)"qqLoginService", QQLoginService.class));
            }
            case SINA: {
                return (T)((LoginService)ApplicationContextHolder.getBean((String)"sinaLoginService", SinaLoginService.class));
            }
            case WEIXIN: {
                return (T)((LoginService)ApplicationContextHolder.getBean((String)"weixinLoginService", WeixinLoginService.class));
            }
        }
        return null;
    }

    public static String login(String appAuthCode, SocialLoginType socialLogin, LoginCallback callback) {
        switch (socialLogin) {
            case ALI: {
                return AliLoginTool.login(appAuthCode, (AliLoginCallback)callback);
            }
            case BAIDU: {
                return BaiduLoginTool.login(appAuthCode, (BaiduLoginCallback)callback);
            }
            case QQ: {
                return QQLoginTool.login(appAuthCode, (QQLoginCallback)callback);
            }
            case SINA: {
                return SinaLoginTool.login(appAuthCode, (SinaLoginCallback)callback);
            }
            case WEIXIN: {
                return WeixinLoginTool.login(appAuthCode, (WeixinLoginCallback)callback);
            }
        }
        return null;
    }

    public static String loadQrcode(String state, SocialLoginType socialLogin) {
        return LoginTool.getService(socialLogin).loadQrcode(state);
    }

    public static String loadAuthPage(String state, SocialLoginType socialLogin) {
        return LoginTool.getService(socialLogin).loadAuthPage(state);
    }
}

