/*
 * Decompiled with CFR 0.152.
 */
package org.daijie.social.captcha.tx;

import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.daijie.core.util.http.HttpConversationUtil;
import org.daijie.social.captcha.SocialCaptchaService;
import org.daijie.social.captcha.tx.ApiResponse;
import org.daijie.social.captcha.tx.CaptchaAPI;
import org.daijie.social.captcha.tx.TXCaptchaProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class TXCaptchaService
implements SocialCaptchaService {
    private static final Logger logger = LoggerFactory.getLogger(TXCaptchaService.class);
    @Autowired
    private TXCaptchaProperties txCaptchaProperties;

    @Override
    public String getCaptcha() {
        String jsUrl = "";
        CaptchaAPI api = CaptchaAPI.getInstance(this.txCaptchaProperties.getUrl(), this.txCaptchaProperties.getSecretId(), this.txCaptchaProperties.getSecretKey());
        try {
            TreeMap<String, String> args = new TreeMap<String, String>();
            args.put("captchaType", this.txCaptchaProperties.getCaptchaType());
            args.put("disturbLevel", this.txCaptchaProperties.getDisturbLevel());
            args.put("isHttps", this.txCaptchaProperties.getIsHttps());
            args.put("clientType", this.txCaptchaProperties.getClientType());
            args.put("businessId", this.txCaptchaProperties.getBusinessId());
            ApiResponse resp = api.getJsUrl(args);
            String content = (String)resp.getBody();
            JSONObject json = JSONUtil.parseObj((String)content);
            if (json.getInt((Object)"code") == 0) {
                jsUrl = json.getStr((Object)"url");
            } else {
                logger.debug(json.toString());
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return jsUrl;
    }

    @Override
    public Boolean verifyCaptcha(String verifyCode) {
        if (StringUtils.isNotEmpty((String)verifyCode)) {
            TreeMap<String, String> args = new TreeMap<String, String>();
            args.put("captchaType", this.txCaptchaProperties.getCaptchaType());
            args.put("ticket", verifyCode);
            args.put("businessId", this.txCaptchaProperties.getBusinessId());
            args.put("userIp", HttpConversationUtil.getRequest().getRemoteAddr());
            CaptchaAPI api = CaptchaAPI.getInstance(this.txCaptchaProperties.getUrl(), this.txCaptchaProperties.getSecretId(), this.txCaptchaProperties.getSecretKey());
            try {
                ApiResponse resp = api.check(args);
                String content = (String)resp.getBody();
                JSONObject json = JSONUtil.parseObj((String)content);
                if (json.getInt((Object)"code") == 0) {
                    return true;
                }
                logger.debug(json.toString());
                return false;
            }
            catch (Exception e) {
                return false;
            }
        }
        return null;
    }
}

