/*
 * Decompiled with CFR 0.152.
 */
package org.daijie.social.login.sina.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.xiaoleilu.hutool.json.JSONObject;
import com.xiaoleilu.hutool.json.JSONUtil;
import org.daijie.core.util.http.HttpConversationUtil;
import org.daijie.social.login.AbstractLoginService;
import org.daijie.social.login.LoginResult;
import org.daijie.social.login.qq.QQLoignProperties;
import org.daijie.social.login.sina.model.SinaAccessToken;
import org.daijie.social.login.sina.model.SinaError;
import org.daijie.social.login.sina.model.SinaUser;
import org.daijie.social.login.sina.model.SinaUserInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class SinaLoginService
extends AbstractLoginService<QQLoignProperties> {
    private static final Logger logger = LoggerFactory.getLogger(SinaLoginService.class);

    public LoginResult getAccessToken(String code) {
        String callback = "sina/login/Callback";
        if (!StringUtils.isEmpty((Object)((QQLoignProperties)this.properties).getCallbackUri())) {
            callback = ((QQLoignProperties)this.properties).getCallbackUri();
        }
        if (!callback.contains("http")) {
            String serverName = HttpConversationUtil.getRequest().getServerName();
            callback = serverName + callback;
        }
        StringBuilder uri = new StringBuilder();
        uri.append("https://graph.qq.com/oauth2.0/token?client_id=");
        uri.append(((QQLoignProperties)this.properties).getAppid());
        uri.append("&client_secret=").append(((QQLoignProperties)this.properties).getAppsecret());
        uri.append("&redirect_uri=" + callback);
        uri.append("&code=" + code).append("&grant_type=authorization_code");
        try {
            String result = (String)this.restTemplate.getForObject(uri.toString(), String.class, new Object[0]);
            JSONObject json = JSONUtil.parseObj((String)result);
            ObjectMapper mapper = new ObjectMapper();
            if (json.getStr((Object)"access_token") != null) {
                SinaAccessToken accessToken = (SinaAccessToken)mapper.readValue(result, SinaAccessToken.class);
                return accessToken;
            }
            SinaError error = new SinaError();
            error.setErrcode(json.getStr((Object)"error_code"));
            error.setErrmsg(json.getStr((Object)"error") + ":" + json.getStr((Object)"error_description"));
            return error;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public LoginResult getOpenid(String access_token) {
        StringBuilder uri = new StringBuilder();
        uri.append("https://graph.qq.com/oauth2.0/me?");
        uri.append("access_token=" + access_token);
        try {
            String result = (String)this.restTemplate.getForObject(uri.toString(), String.class, new Object[0]);
            JSONObject json = JSONUtil.parseObj((String)result);
            ObjectMapper mapper = new ObjectMapper();
            if (json.getStr((Object)"uid") != null) {
                SinaUser user = (SinaUser)mapper.readValue(result, SinaUser.class);
                return user;
            }
            SinaError error = new SinaError();
            error.setErrcode(json.getStr((Object)"error_code"));
            error.setErrmsg(json.getStr((Object)"error") + ":" + json.getStr((Object)"error_description"));
            return error;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public LoginResult getUserInfo(String access_token, String openid) {
        StringBuilder uri = new StringBuilder();
        uri.append("https://api.weibo.com/2/users/show.json?uid=");
        uri.append(openid);
        uri.append("&access_token=" + access_token);
        try {
            String result = (String)this.restTemplate.getForObject(uri.toString(), String.class, new Object[0]);
            JSONObject json = JSONUtil.parseObj((String)result);
            ObjectMapper mapper = new ObjectMapper();
            if (json.getStr((Object)"id") != null) {
                SinaUserInfo userInfo = (SinaUserInfo)mapper.readValue(result, SinaUserInfo.class);
                return userInfo;
            }
            SinaError error = new SinaError();
            error.setErrcode(json.getStr((Object)"error_code"));
            error.setErrmsg(json.getStr((Object)"error") + ":" + json.getStr((Object)"error_description"));
            return error;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public String loadAuthPage(String state) {
        String callback = "sina/login/Callback";
        if (!StringUtils.isEmpty((Object)((QQLoignProperties)this.properties).getCallbackUri())) {
            callback = ((QQLoignProperties)this.properties).getCallbackUri();
        }
        if (!callback.contains("http")) {
            String serverName = HttpConversationUtil.getRequest().getServerName();
            callback = serverName + callback;
        }
        StringBuilder uri = new StringBuilder();
        uri.append("https://api.weibo.com/oauth2/authorize?client_id=");
        uri.append(((QQLoignProperties)this.properties).getAppid());
        uri.append("&redirect_uri=" + callback);
        uri.append("&state=" + state);
        return "redirect:" + uri.toString();
    }

    @Override
    public String loadQrcode(String state) {
        return null;
    }

    @Override
    public LoginResult getUserInfo(String voucher) {
        LoginResult openidResult = this.getOpenid(voucher);
        if (openidResult.getResult().booleanValue()) {
            SinaUser user = (SinaUser)openidResult;
            return this.getUserInfo(voucher, user.getUid());
        }
        return openidResult;
    }
}

