/*
 * Decompiled with CFR 0.152.
 */
package org.daijie.social.login.baidu.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.xiaoleilu.hutool.json.JSONObject;
import com.xiaoleilu.hutool.json.JSONUtil;
import org.daijie.core.util.http.HttpConversationUtil;
import org.daijie.social.login.AbstractLoginService;
import org.daijie.social.login.LoginResult;
import org.daijie.social.login.baidu.BaiduLoignProperties;
import org.daijie.social.login.baidu.model.BaiduAccessToken;
import org.daijie.social.login.baidu.model.BaiduError;
import org.daijie.social.login.baidu.model.BaiduUserInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class BaiduLoginService
extends AbstractLoginService<BaiduLoignProperties> {
    private static final Logger logger = LoggerFactory.getLogger(BaiduLoginService.class);

    public LoginResult getAccessToken(String code) {
        StringBuilder uri = new StringBuilder();
        uri.append("https://openapi.baidu.com/oauth/2.0/token?client_id=");
        uri.append(((BaiduLoignProperties)this.properties).getAppid());
        uri.append("&client_secret=").append(((BaiduLoignProperties)this.properties).getAppsecret());
        uri.append("&code=" + code).append("&grant_type=authorization_code");
        try {
            String result = (String)this.restTemplate.getForObject(uri.toString(), String.class, new Object[0]);
            JSONObject json = JSONUtil.parseObj((String)result);
            ObjectMapper mapper = new ObjectMapper();
            if (json.getStr((Object)"access_token") != null) {
                BaiduAccessToken accessToken = (BaiduAccessToken)mapper.readValue(result, BaiduAccessToken.class);
                return accessToken;
            }
            BaiduError error = new BaiduError();
            error.setErrcode(json.getStr((Object)"error"));
            error.setErrmsg(json.getStr((Object)"error_description"));
            return error;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public LoginResult getUserInfo(String access_token) {
        StringBuilder uri = new StringBuilder();
        uri.append("https://openapi.baidu.com/rest/2.0/passport/users/getInfo?");
        uri.append("access_token=" + access_token);
        try {
            String result = (String)this.restTemplate.getForObject(uri.toString(), String.class, new Object[0]);
            JSONObject json = JSONUtil.parseObj((String)result);
            ObjectMapper mapper = new ObjectMapper();
            if (json.getStr((Object)"userid") != null) {
                BaiduUserInfo userInfo = (BaiduUserInfo)mapper.readValue(result, BaiduUserInfo.class);
                return userInfo;
            }
            BaiduError error = new BaiduError();
            error.setErrcode(json.getStr((Object)"error"));
            error.setErrmsg(json.getStr((Object)"error_description"));
            return error;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public String loadAuthPage(String state) {
        String callback = "baidu/login/Callback";
        if (!StringUtils.isEmpty((Object)((BaiduLoignProperties)this.properties).getCallbackUri())) {
            callback = ((BaiduLoignProperties)this.properties).getCallbackUri();
        }
        if (!callback.contains("http")) {
            String serverName = HttpConversationUtil.getRequest().getServerName();
            callback = serverName + callback;
        }
        StringBuilder uri = new StringBuilder();
        uri.append("https://openapi.baidu.com/oauth/2.0/authorize?client_id=");
        uri.append(((BaiduLoignProperties)this.properties).getAppid());
        uri.append("&redirect_uri=" + callback);
        uri.append("&response_type=code");
        uri.append("&state=" + state);
        return "redirect:" + uri.toString();
    }

    @Override
    public String loadQrcode(String state) {
        return null;
    }
}

