/*
 * Decompiled with CFR 0.152.
 */
package org.daijie.social.login.ali.service;

import com.alipay.api.AlipayRequest;
import com.alipay.api.DefaultAlipayClient;
import com.alipay.api.request.AlipayOpenAuthTokenAppRequest;
import com.alipay.api.response.AlipayOpenAuthTokenAppResponse;
import com.xiaoleilu.hutool.bean.BeanUtil;
import org.daijie.core.util.http.HttpConversationUtil;
import org.daijie.social.login.AbstractLoginService;
import org.daijie.social.login.LoginResult;
import org.daijie.social.login.ali.AliLoignProperties;
import org.daijie.social.login.ali.model.AliError;
import org.daijie.social.login.ali.model.AliUserInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class AliLoginService
extends AbstractLoginService<AliLoignProperties> {
    private static final Logger logger = LoggerFactory.getLogger(AliLoginService.class);

    @Override
    public LoginResult getUserInfo(String appAuthCode) {
        try {
            DefaultAlipayClient alipayClient = new DefaultAlipayClient("https://openauth.alipay.com/gateway.do", ((AliLoignProperties)this.properties).getAppid(), ((AliLoignProperties)this.properties).getAppsecret(), "json", "UTF-8", ((AliLoignProperties)this.properties).getPublicKey(), "RSA2");
            AlipayOpenAuthTokenAppRequest request = new AlipayOpenAuthTokenAppRequest();
            request.setBizContent("{\"grant_type\":\"authorization_code\",\"code\":\"" + appAuthCode + "\"" + "}");
            AlipayOpenAuthTokenAppResponse response = (AlipayOpenAuthTokenAppResponse)alipayClient.execute((AlipayRequest)request);
            if (response.isSuccess()) {
                AliUserInfo userInfo = new AliUserInfo();
                BeanUtil.copyProperties((Object)response, (Object)userInfo);
                return userInfo;
            }
            AliError error = new AliError();
            BeanUtil.copyProperties((Object)response, (Object)error);
            return error;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public String loadQrcode(String state) {
        String callback = "ali/login/Callback";
        if (!StringUtils.isEmpty((Object)((AliLoignProperties)this.properties).getCallbackUri())) {
            callback = ((AliLoignProperties)this.properties).getCallbackUri();
        }
        if (!callback.contains("http")) {
            String serverName = HttpConversationUtil.getRequest().getServerName();
            callback = serverName + callback;
        }
        StringBuilder uri = new StringBuilder();
        uri.append("https://openauth.alipay.com/oauth2/appToAppAuth.htm?appid=");
        uri.append(((AliLoignProperties)this.properties).getAppid());
        uri.append("&redirect_uri=" + callback);
        return "redirect:" + uri.toString();
    }

    @Override
    public String loadAuthPage(String state) {
        return null;
    }
}

