/*
 * Decompiled with CFR 0.152.
 */
package org.daijie.shiro.session;

import java.io.Serializable;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.UnknownSessionException;
import org.apache.shiro.session.mgt.eis.AbstractSessionDAO;
import org.daijie.core.util.SerializeUtil;
import org.daijie.core.util.http.HttpConversationUtil;
import org.daijie.shiro.session.ClusterRedisSession;
import org.daijie.shiro.session.RedisSession;
import org.daijie.shiro.session.RedisSessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ShiroRedisSession {
    private static Logger logger = LoggerFactory.getLogger(ShiroRedisSession.class);
    private static Session session;
    private static RedisSessionFactory redisSession;

    @Autowired
    public void setRedisSession(RedisSessionFactory redisSession) {
        ShiroRedisSession.redisSession = redisSession;
    }

    public static class Redis
    extends ShiroSession {
        public static void set(String key, Object value) {
            if (redisSession instanceof RedisSession) {
                RedisSession redis = (RedisSession)redisSession;
                redis.getRedisManager().set((key + Redis.getToken()).getBytes(), SerializeUtil.serialize((Object)value));
            } else if (redisSession instanceof ClusterRedisSession) {
                ClusterRedisSession redis = (ClusterRedisSession)redisSession;
                redis.getRedisManager().set((key + Redis.getToken()).getBytes(), SerializeUtil.serialize((Object)value));
            }
        }

        public static void set(String key, Object value, int expire) {
            if (redisSession instanceof RedisSession) {
                RedisSession redis = (RedisSession)redisSession;
                redis.getRedisManager().set((key + Redis.getToken()).getBytes(), SerializeUtil.serialize((Object)value), expire);
            } else if (redisSession instanceof ClusterRedisSession) {
                ClusterRedisSession redis = (ClusterRedisSession)redisSession;
                redis.getRedisManager().set((key + Redis.getToken()).getBytes(), SerializeUtil.serialize((Object)value), expire);
            }
        }

        public static Object get(String key) {
            byte[] value = new byte[]{};
            if (redisSession instanceof RedisSession) {
                RedisSession redis = (RedisSession)redisSession;
                value = redis.getRedisManager().get((key + Redis.getToken()).getBytes());
            } else if (redisSession instanceof ClusterRedisSession) {
                ClusterRedisSession redis = (ClusterRedisSession)redisSession;
                value = redis.getRedisManager().get((key + Redis.getToken()).getBytes());
            }
            if (value != null) {
                return SerializeUtil.deserialize((byte[])value);
            }
            return value;
        }
    }

    private static class ShiroSession {
        private ShiroSession() {
        }

        public static void initSession() {
            if (redisSession == null) {
                logger.error("redisSession is null!");
            } else {
                try {
                    session = ((AbstractSessionDAO)redisSession).readSession((Serializable)((Object)ShiroSession.getToken()));
                }
                catch (UnknownSessionException e) {
                    logger.error(e.getMessage());
                    session = null;
                }
            }
        }

        public static void setAttribute(Object key, Object value) {
            ShiroSession.initSession();
            session.setAttribute(key, value);
            ShiroSession.agentRedisSession().updateSession(session);
        }

        public static void setAttribute(Object key, Object value, long maxIdleTimeInMillis) {
            ShiroSession.initSession();
            session.setAttribute(key, value);
            session.setTimeout(maxIdleTimeInMillis);
            ShiroSession.agentRedisSession().updateSession(session);
        }

        public static Object getAttribute(Object key) {
            ShiroSession.initSession();
            return session.getAttribute(key);
        }

        public static void removeAttribute(Object key) {
            ShiroSession.initSession();
            session.removeAttribute(key);
            ShiroSession.agentRedisSession().updateSession(session);
        }

        public static Session getSession() {
            ShiroSession.initSession();
            return session;
        }

        public static void deleteSession() {
            ShiroSession.initSession();
            SecurityUtils.getSubject().logout();
        }

        public static void saveSession() {
            ShiroSession.initSession();
            ShiroSession.agentRedisSession().saveSession(session);
        }

        private static <T extends RedisSessionFactory> RedisSessionFactory agentRedisSession() {
            if (redisSession instanceof RedisSession) {
                return (RedisSession)redisSession;
            }
            if (redisSession instanceof ClusterRedisSession) {
                return (ClusterRedisSession)redisSession;
            }
            return null;
        }

        public static String getToken() {
            String token = HttpConversationUtil.getToken();
            if (token == null) {
                token = SecurityUtils.getSubject().getSession().getId().toString();
            }
            return token;
        }
    }
}

