/*
 * Decompiled with CFR 0.152.
 */
package org.daijie.shiro.redis;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.daijie.shiro.redis.IRedisOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisPool;

public class RedisOperator
implements IRedisOperator {
    public static final Logger logger = LoggerFactory.getLogger(RedisOperator.class);
    private JedisCluster jedisCluster;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TreeSet<String> keys(String pattern) throws Exception {
        logger.debug("Start getting keys...");
        TreeSet<String> keys = new TreeSet<String>();
        Map clusterNodes = this.jedisCluster.getClusterNodes();
        for (String k : clusterNodes.keySet()) {
            logger.debug("Getting keys from: {}", (Object)k);
            JedisPool jp = (JedisPool)clusterNodes.get(k);
            Jedis connection = jp.getResource();
            try {
                Set set = connection.keys(pattern);
                Iterator it = set.iterator();
                while (it.hasNext()) {
                    keys.add((String)it.next());
                }
            }
            catch (Exception e) {
                logger.error("Getting keys error: {}", (Throwable)e);
            }
            finally {
                logger.debug("Connection closed.");
                connection.close();
            }
        }
        logger.debug("Keys gotten!");
        return keys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flushDB() throws Exception {
        logger.debug("Start flushDb keys...");
        Map clusterNodes = this.jedisCluster.getClusterNodes();
        for (String k : clusterNodes.keySet()) {
            logger.debug("delete keys from: {}", (Object)k);
            JedisPool jp = (JedisPool)clusterNodes.get(k);
            Jedis connection = jp.getResource();
            try {
                connection.flushDB();
            }
            catch (Exception e) {
                logger.error("Getting keys error: {}", (Throwable)e);
            }
            finally {
                logger.debug("Connection closed.");
                connection.close();
            }
        }
        logger.debug("flushDB");
    }

    public JedisCluster getJedisCluster() {
        return this.jedisCluster;
    }

    public void setJedisCluster(JedisCluster jedisCluster) {
        this.jedisCluster = jedisCluster;
    }
}

