/*
 * Decompiled with CFR 0.152.
 */
package org.daijie.shiro.redis;

import java.util.TreeSet;
import org.daijie.shiro.redis.RedisOperator;
import redis.clients.jedis.JedisCluster;

public class RedisManager {
    private JedisCluster jedisCluster;
    private RedisOperator redisOperator;
    private int expire = 0;

    public RedisOperator getRedisOperator() {
        return this.redisOperator;
    }

    public void setRedisOperator(RedisOperator redisOperator) {
        this.redisOperator = redisOperator;
    }

    public int getExpire() {
        return this.expire;
    }

    public void setExpire(int expire) {
        this.expire = expire;
    }

    public JedisCluster getJedisCluster() {
        return this.jedisCluster;
    }

    public void setJedisCluster(JedisCluster jedisCluster) {
        this.jedisCluster = jedisCluster;
    }

    public void init() {
    }

    public byte[] get(byte[] key) {
        byte[] value = null;
        value = this.jedisCluster.get(key);
        return value;
    }

    public byte[] set(byte[] key, byte[] value) {
        this.jedisCluster.set(key, value);
        if (this.expire != 0) {
            this.jedisCluster.expire(key, this.expire);
        }
        return value;
    }

    public byte[] set(byte[] key, byte[] value, int expire) {
        this.jedisCluster.set(key, value);
        if (expire != 0) {
            this.jedisCluster.expire(key, expire);
        }
        return value;
    }

    public void del(byte[] key) {
        this.jedisCluster.del(key);
    }

    public void flushDB() throws Exception {
        this.redisOperator.flushDB();
    }

    public Long dbSize(String pattern) {
        Long dbSize = 0L;
        TreeSet<String> keys = null;
        try {
            keys = this.keys(pattern);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        dbSize = keys.size();
        return dbSize;
    }

    public TreeSet<String> keys(String pattern) throws Exception {
        TreeSet<String> treeSet = new TreeSet();
        treeSet = this.redisOperator.keys(pattern);
        return treeSet;
    }
}

