/*
 * Decompiled with CFR 0.152.
 */
package org.daijie.shiro.feign;

import feign.RequestInterceptor;
import feign.RequestTemplate;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Configuration
public class ShiroInterceptorConfigure {
    @Bean
    public RequestInterceptor shiroInterceptor() {
        return new RequestInterceptor(){

            public void apply(RequestTemplate template) {
                ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
                HttpServletRequest request = attributes.getRequest();
                Enumeration headerNames = request.getHeaderNames();
                if (headerNames != null) {
                    while (headerNames.hasMoreElements()) {
                        String name = (String)headerNames.nextElement();
                        String values = request.getHeader(name);
                        template.header(name, new String[]{values});
                    }
                }
                template.method(request.getHeader("redirect_method"));
                template.insert(0, (CharSequence)request.getHeader("redirect_uri"));
            }
        };
    }
}

