/*
 * Decompiled with CFR 0.152.
 */
package org.daijie.shiro.configure;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.apache.shiro.authc.credential.CredentialsMatcher;
import org.apache.shiro.cache.CacheManager;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.session.mgt.SessionManager;
import org.apache.shiro.session.mgt.SessionValidationScheduler;
import org.apache.shiro.session.mgt.ValidatingSessionManager;
import org.apache.shiro.session.mgt.eis.JavaUuidSessionIdGenerator;
import org.apache.shiro.session.mgt.eis.SessionDAO;
import org.apache.shiro.session.mgt.eis.SessionIdGenerator;
import org.apache.shiro.spring.LifecycleBeanPostProcessor;
import org.apache.shiro.spring.security.interceptor.AuthorizationAttributeSourceAdvisor;
import org.apache.shiro.spring.web.ShiroFilterFactoryBean;
import org.apache.shiro.web.mgt.DefaultWebSecurityManager;
import org.apache.shiro.web.servlet.Cookie;
import org.apache.shiro.web.servlet.SimpleCookie;
import org.apache.shiro.web.session.mgt.DefaultWebSessionManager;
import org.crazycake.shiro.RedisCacheManager;
import org.daijie.shiro.TokenCredentialsMatcher;
import org.daijie.shiro.UserAuthorizingRealm;
import org.daijie.shiro.configure.ShiroProperties;
import org.daijie.shiro.configure.ShiroRedisProperties;
import org.daijie.shiro.filter.CredentialFilter;
import org.daijie.shiro.redis.BaseRedisManagerFactory;
import org.daijie.shiro.redis.RedisManager;
import org.daijie.shiro.redis.RedisOperator;
import org.daijie.shiro.session.ClusterRedisSession;
import org.daijie.shiro.session.RedisSession;
import org.daijie.shiro.session.RedisSessionFactory;
import org.daijie.shiro.session.bean.ShiroRedisSessionBean;
import org.daijie.shiro.session.quartz.QuartzSessionValidationScheduler2;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;
import org.springframework.util.StringUtils;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.JedisCluster;

@Configuration
@EnableConfigurationProperties(value={ShiroProperties.class, ShiroRedisProperties.class})
@Import(value={ShiroRedisSessionBean.class})
public class ShiroConfigure {
    @Bean(name={"shiroFilter"})
    @Primary
    public ShiroFilterFactoryBean initShiroFilterFactoryBean(@Qualifier(value="securityManager") SecurityManager securityManager, ShiroProperties shiroProperties) {
        HashMap<String, Object> filterMap = new HashMap<String, Object>();
        ShiroFilterFactoryBean shiroFilterFactoryBean = new ShiroFilterFactoryBean();
        try {
            shiroFilterFactoryBean.setSecurityManager(securityManager);
            if (!StringUtils.isEmpty((Object)shiroProperties.getFilterClassNames())) {
                for (String filterClassName : shiroProperties.getFilterClassNames().split(",")) {
                    if (filterClassName.trim().length() <= 0) continue;
                    Class<?> cls = Class.forName(filterClassName);
                    String name = filterClassName.substring(filterClassName.lastIndexOf(".") + 1).replace("Filter", "");
                    filterMap.put(name.substring(0, 1).toLowerCase() + name.substring(1), cls.newInstance());
                }
            }
            if (shiroProperties.getIsValidation().booleanValue()) {
                filterMap.put("credential", (Object)new CredentialFilter());
            }
            shiroFilterFactoryBean.setFilters(filterMap);
            shiroFilterFactoryBean.setLoginUrl(shiroProperties.getLoginUrl());
            shiroFilterFactoryBean.setSuccessUrl(shiroProperties.getSuccessUrl());
            shiroFilterFactoryBean.setUnauthorizedUrl(shiroProperties.getUnauthorizedUrl());
            Map<String, String> filterChainDefinitionMap = new HashMap<String, String>();
            if (!StringUtils.isEmpty((Object)shiroProperties.getFilterChainDefinitions())) {
                for (String definition : shiroProperties.getFilterChainDefinitions().split(",")) {
                    if (!definition.contains("=")) continue;
                    filterChainDefinitionMap.put(definition.split("=")[0], definition.split("=")[1]);
                }
            } else if (!StringUtils.isEmpty((Object)shiroProperties.getFilterChainDefinitionMap())) {
                ObjectMapper mapper = new ObjectMapper();
                Map map = (Map)mapper.readValue(shiroProperties.getFilterChainDefinitionMap(), Map.class);
                filterChainDefinitionMap = map;
            } else {
                filterChainDefinitionMap.put("*/**", "anon");
                filterChainDefinitionMap.put("/login/**", "credential");
            }
            shiroFilterFactoryBean.setFilterChainDefinitionMap(filterChainDefinitionMap);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (JsonParseException e) {
            e.printStackTrace();
        }
        catch (JsonMappingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return shiroFilterFactoryBean;
    }

    @Bean(name={"securityManager"})
    @Primary
    public SecurityManager initSecurityManager(@Qualifier(value="authorizingRealm") AuthorizingRealm authorizingRealm, @Qualifier(value="sessionManager") SessionManager sessionManager, @Qualifier(value="cacheManager") CacheManager cacheManager) {
        DefaultWebSecurityManager securityManager = new DefaultWebSecurityManager((Realm)authorizingRealm);
        securityManager.setSessionManager(sessionManager);
        securityManager.setCacheManager(cacheManager);
        return securityManager;
    }

    @Bean(name={"authorizingRealm"})
    @Primary
    public AuthorizingRealm initAuthorizingRealm(@Qualifier(value="credentialsMatcher") CredentialsMatcher credentialsMatcher, ShiroProperties shiroProperties) {
        UserAuthorizingRealm authorizingRealm = new UserAuthorizingRealm();
        authorizingRealm.setCredentialsMatcher(credentialsMatcher);
        authorizingRealm.setKissoEnable(shiroProperties.getKissoEnable());
        return authorizingRealm;
    }

    @Bean(name={"credentialsMatcher"})
    @Primary
    public CredentialsMatcher initCredentialsMatcher(@Qualifier(value="redisSession") RedisSessionFactory redisSession, ShiroProperties shiroProperties) {
        TokenCredentialsMatcher tokenCredentialsMatcher = new TokenCredentialsMatcher();
        tokenCredentialsMatcher.setRedisSession(redisSession);
        tokenCredentialsMatcher.setValidation(shiroProperties.getIsValidation());
        return tokenCredentialsMatcher;
    }

    @Bean(name={"lifecycleBeanPostProcessor"})
    @Primary
    public LifecycleBeanPostProcessor initLifecycleBeanPostProcessor() {
        return new LifecycleBeanPostProcessor();
    }

    @Bean(name={"redisSession"})
    @Primary
    public RedisSessionFactory initRedisSession(@Qualifier(value="redisManagerFactory") BaseRedisManagerFactory redisManagerFactory, @Qualifier(value="sessionIdGenerator") SessionIdGenerator sessionIdGenerator, ShiroRedisProperties shiroRedisProperties) {
        if (shiroRedisProperties.getCluster().booleanValue()) {
            return new ClusterRedisSession(redisManagerFactory.getClusterRedisManager(), sessionIdGenerator);
        }
        RedisSession redisSession = new RedisSession();
        redisSession.setRedisManager(redisManagerFactory.getSingleRedisManager());
        redisSession.setSessionIdGenerator(sessionIdGenerator);
        return redisSession;
    }

    @Bean(name={"sessionIdGenerator"})
    @Primary
    public SessionIdGenerator initSessionIdGenerator() {
        return new JavaUuidSessionIdGenerator();
    }

    @Bean(name={"sessionManager"})
    @Primary
    public SessionManager initSessionManager(@Qualifier(value="redisSession") SessionDAO redisSession, @Qualifier(value="simpleCookie") SimpleCookie simpleCookie, @Qualifier(value="sessionValidationScheduler") SessionValidationScheduler sessionValidationScheduler, ShiroProperties shiroProperties) {
        DefaultWebSessionManager sessionManager = new DefaultWebSessionManager();
        sessionManager.setSessionDAO(redisSession);
        sessionManager.setSessionIdCookie((Cookie)simpleCookie);
        sessionManager.setSessionValidationScheduler(sessionValidationScheduler);
        sessionManager.setSessionValidationSchedulerEnabled(true);
        sessionManager.setSessionIdCookieEnabled(shiroProperties.getKissoEnable() == false);
        sessionManager.setGlobalSessionTimeout(360000L);
        return sessionManager;
    }

    @Bean(name={"sessionManagerScheduler"})
    @Primary
    public SessionManager initSessionManager(@Qualifier(value="redisSession") SessionDAO redisSession, @Qualifier(value="simpleCookie") SimpleCookie simpleCookie) {
        DefaultWebSessionManager sessionManager = new DefaultWebSessionManager();
        sessionManager.setSessionDAO(redisSession);
        sessionManager.setSessionIdCookie((Cookie)simpleCookie);
        sessionManager.setSessionValidationSchedulerEnabled(true);
        sessionManager.setSessionIdCookieEnabled(true);
        sessionManager.setGlobalSessionTimeout(360000L);
        return sessionManager;
    }

    @Bean(name={"simpleCookie"})
    @Primary
    public SimpleCookie initSimpleCookie(ShiroProperties shiroProperties) {
        return new SimpleCookie(shiroProperties.getSessionid());
    }

    @Bean(name={"sessionValidationScheduler"})
    @Primary
    public SessionValidationScheduler initSessionValidationScheduler(@Qualifier(value="sessionManagerScheduler") SessionManager sessionManager) {
        QuartzSessionValidationScheduler2 sessionValidationScheduler = new QuartzSessionValidationScheduler2();
        sessionValidationScheduler.setSessionManager((ValidatingSessionManager)sessionManager);
        return sessionValidationScheduler;
    }

    @Bean
    public AuthorizationAttributeSourceAdvisor getAuthorizationAttributeSourceAdvisor(DefaultWebSecurityManager securityManager) {
        AuthorizationAttributeSourceAdvisor aasa = new AuthorizationAttributeSourceAdvisor();
        aasa.setSecurityManager((SecurityManager)securityManager);
        return aasa;
    }

    @Bean(value={"redisManager"})
    public Object redisManager(ShiroRedisProperties shiroRedisProperties) {
        if (shiroRedisProperties.getCluster().booleanValue()) {
            GenericObjectPoolConfig genericObjectPoolConfig = new GenericObjectPoolConfig();
            genericObjectPoolConfig.setMaxWaitMillis(-1L);
            genericObjectPoolConfig.setMaxTotal(1000);
            genericObjectPoolConfig.setMinIdle(8);
            genericObjectPoolConfig.setMaxIdle(100);
            String[] serverArray = shiroRedisProperties.getAddress().split(",");
            HashSet<HostAndPort> nodes = new HashSet<HostAndPort>();
            for (String ipPort : serverArray) {
                String[] ipPortPair = ipPort.split(":");
                nodes.add(new HostAndPort(ipPortPair[0].trim(), Integer.valueOf(ipPortPair[1].trim()).intValue()));
            }
            JedisCluster jedisCluster = new JedisCluster(nodes, shiroRedisProperties.getConnectionTimeout().intValue(), shiroRedisProperties.getTimeout().intValue(), shiroRedisProperties.getMaxAttempts().intValue(), shiroRedisProperties.getPassword(), genericObjectPoolConfig);
            RedisOperator redisOperator = new RedisOperator();
            redisOperator.setJedisCluster(jedisCluster);
            RedisManager redisManager = new RedisManager();
            redisManager.setJedisCluster(jedisCluster);
            redisManager.setRedisOperator(redisOperator);
            return redisManager;
        }
        String[] hosts = shiroRedisProperties.getAddress().split(",")[0].split(":");
        org.crazycake.shiro.RedisManager redisManager = new org.crazycake.shiro.RedisManager();
        redisManager.setExpire(shiroRedisProperties.getExpire().intValue());
        redisManager.setTimeout(shiroRedisProperties.getConnectionTimeout().intValue());
        redisManager.setHost(hosts[0]);
        redisManager.setPort(Integer.parseInt(hosts[1]));
        redisManager.setPassword(shiroRedisProperties.getPassword());
        return redisManager;
    }

    @Bean(value={"redisManagerFactory"})
    public BaseRedisManagerFactory redisManagerFactory(@Qualifier(value="redisManager") Object redisManager) {
        BaseRedisManagerFactory redisManagerFactory = new BaseRedisManagerFactory();
        if (redisManager instanceof RedisManager) {
            redisManagerFactory.setClusterRedisManager((RedisManager)redisManager);
        } else {
            redisManagerFactory.setSingleRedisManager((org.crazycake.shiro.RedisManager)redisManager);
        }
        return redisManagerFactory;
    }

    @Bean(value={"cacheManager"})
    public CacheManager cacheManager(@Qualifier(value="redisManager") Object redisManager) {
        if (redisManager instanceof RedisManager) {
            org.daijie.shiro.redis.RedisCacheManager cacheManager = new org.daijie.shiro.redis.RedisCacheManager();
            cacheManager.setRedisManager((RedisManager)redisManager);
            return cacheManager;
        }
        RedisCacheManager cacheManager = new RedisCacheManager();
        cacheManager.setRedisManager((org.crazycake.shiro.RedisManager)redisManager);
        return cacheManager;
    }
}

