/*
 * Decompiled with CFR 0.152.
 */
package org.daijie.shiro.configure;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.spring.web.ShiroFilterFactoryBean;
import org.apache.shiro.web.filter.mgt.FilterChainManager;
import org.apache.shiro.web.filter.mgt.FilterChainResolver;
import org.apache.shiro.web.filter.mgt.PathMatchingFilterChainResolver;
import org.apache.shiro.web.mgt.WebSecurityManager;
import org.apache.shiro.web.servlet.AbstractShiroFilter;
import org.springframework.beans.factory.BeanInitializationException;

public class ResourcesShiroFilterFactoryBean
extends ShiroFilterFactoryBean {
    private Set<String> ignoreExt = new HashSet<String>();

    public ResourcesShiroFilterFactoryBean() {
        this.ignoreExt.add(".jpg");
        this.ignoreExt.add(".png");
        this.ignoreExt.add(".gif");
        this.ignoreExt.add(".bmp");
        this.ignoreExt.add(".js");
        this.ignoreExt.add(".css");
        this.ignoreExt.add(".html");
    }

    protected AbstractShiroFilter createInstance() throws Exception {
        SecurityManager securityManager = this.getSecurityManager();
        if (securityManager == null) {
            String msg = "SecurityManager property must be set.";
            throw new BeanInitializationException(msg);
        }
        if (!(securityManager instanceof WebSecurityManager)) {
            String msg = "The security manager does not implement the WebSecurityManager interface.";
            throw new BeanInitializationException(msg);
        }
        FilterChainManager manager = this.createFilterChainManager();
        PathMatchingFilterChainResolver chainResolver = new PathMatchingFilterChainResolver();
        chainResolver.setFilterChainManager(manager);
        return new MySpringShiroFilter((WebSecurityManager)securityManager, (FilterChainResolver)chainResolver);
    }

    private final class MySpringShiroFilter
    extends AbstractShiroFilter {
        protected MySpringShiroFilter(WebSecurityManager webSecurityManager, FilterChainResolver resolver) {
            if (webSecurityManager == null) {
                throw new IllegalArgumentException("WebSecurityManager property cannot be null.");
            }
            this.setSecurityManager(webSecurityManager);
            if (resolver != null) {
                this.setFilterChainResolver(resolver);
            }
        }

        protected void doFilterInternal(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws ServletException, IOException {
            HttpServletRequest request = (HttpServletRequest)servletRequest;
            String str = request.getRequestURI().toLowerCase();
            boolean flag = true;
            int idx = 0;
            idx = str.indexOf(".");
            if (idx > 0) {
                str = str.substring(idx);
                if (ResourcesShiroFilterFactoryBean.this.ignoreExt.contains(str.toLowerCase())) {
                    flag = false;
                }
            }
            if (flag) {
                super.doFilterInternal(servletRequest, servletResponse, chain);
            } else {
                chain.doFilter(servletRequest, servletResponse);
            }
        }
    }
}

