/*
 * Decompiled with CFR 0.152.
 */
package org.daijie.shiro.authc;

import com.baomidou.kisso.SSOHelper;
import com.xiaoleilu.hutool.bean.BeanUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.Subject;
import org.daijie.core.util.encrypt.RSAUtil;
import org.daijie.core.util.http.CookieUtil;
import org.daijie.core.util.http.HttpConversationUtil;
import org.daijie.shiro.authc.AuthorizationToken;
import org.daijie.shiro.authc.UserToken;
import org.daijie.shiro.session.ShiroRedisSession;

public final class Auth {
    public static final String AUTH_KEY = "_AUTH_KEY_USER";
    public static final String AUTHC_KEY = "user";
    private static UserToken userToken;

    public static void setPermissions(List<String> permissions) {
        userToken.setPermissions(permissions);
    }

    public static void setRoles(List<String> roles) {
        userToken.setRoles(roles);
    }

    public static void login(String username, String pubPwd, String salt, String saltPwd, Object authc) {
        Auth.login(username, pubPwd, salt, saltPwd, AUTHC_KEY, authc);
    }

    public static void login(String username, String pubPwd, String salt, String saltPwd, String authcKey, Object authc) {
        userToken = new UserToken();
        userToken.setAuthc(authc);
        AuthorizationToken token = new AuthorizationToken(username, saltPwd, pubPwd, salt, authcKey, userToken);
        token.setRememberMe(true);
        Subject subject = SecurityUtils.getSubject();
        subject.login((AuthenticationToken)token);
        subject.isAuthenticated();
    }

    public static void logOut() {
        Session session = ShiroRedisSession.Redis.getSession();
        if (session.getAttribute((Object)"kissoEnable") != null && ((Boolean)session.getAttribute((Object)"kissoEnable")).booleanValue()) {
            SSOHelper.clearLogin((HttpServletRequest)HttpConversationUtil.getRequest(), (HttpServletResponse)HttpConversationUtil.getResponse());
        } else {
            CookieUtil.set((String)"token", (String)session.getId().toString(), (Integer)0);
        }
        ShiroRedisSession.Redis.deleteSession();
    }

    public static String getAuthcKey() {
        return (String)ShiroRedisSession.Redis.getAttribute(AUTH_KEY);
    }

    public static <T> T getAuthc(Class<T> className) {
        return Auth.getAuthc(Auth.getAuthcKey(), className);
    }

    public static <T> T getAuthc(String key, Class<T> className) {
        Object value = ShiroRedisSession.Redis.getAttribute(key);
        if (value instanceof UserToken) {
            Object authc = ((UserToken)value).getAuthc();
            if (authc instanceof Map) {
                return (T)BeanUtil.mapToBean((Map)((Map)authc), className, (boolean)true);
            }
            return (T)authc;
        }
        return null;
    }

    public static List<String> getPermissions() {
        return Auth.getPermissions(Auth.getAuthcKey());
    }

    public static List<String> getPermissions(String key) {
        Object value = ShiroRedisSession.Redis.getAttribute(key);
        if (value instanceof UserToken) {
            return ((UserToken)value).getPermissions();
        }
        return new ArrayList<String>();
    }

    public static List<String> getRoles() {
        return Auth.getRoles(Auth.getAuthcKey());
    }

    public static List<String> getRoles(String key) {
        Object value = ShiroRedisSession.Redis.getAttribute(key);
        if (value instanceof UserToken) {
            return ((UserToken)value).getRoles();
        }
        return new ArrayList<String>();
    }

    public static void refreshAuthc(Object authc) {
        Auth.refreshAuthc(Auth.getAuthcKey(), authc);
    }

    public static void refreshAuthc(String key, Object authc) {
        Object value = ShiroRedisSession.Redis.getAttribute(key);
        if (value instanceof UserToken) {
            userToken = (UserToken)value;
            userToken.setAuthc(authc);
            ShiroRedisSession.Redis.setAttribute(key, userToken);
        }
    }

    public static void refreshPermissions(List<String> permissions) {
        Auth.refreshPermissions(Auth.getAuthcKey(), permissions);
    }

    public static void refreshPermissions(String key, List<String> permissions) {
        Object value = ShiroRedisSession.Redis.getAttribute(key);
        if (value instanceof UserToken) {
            userToken = (UserToken)value;
            userToken.setPermissions(permissions);
            ShiroRedisSession.Redis.setAttribute(key, userToken);
        }
    }

    public static void refreshRoles(List<String> roles) {
        Auth.refreshRoles(Auth.getAuthcKey(), roles);
    }

    public static void refreshRoles(String key, List<String> roles) {
        Object value = ShiroRedisSession.Redis.getAttribute(key);
        if (value instanceof UserToken) {
            userToken = (UserToken)value;
            userToken.setRoles(roles);
            ShiroRedisSession.Redis.setAttribute(key, userToken);
        }
    }

    public static void initSecretKey() {
        RSAUtil.init();
        ShiroRedisSession.Redis.setAttribute("RSA_PUBLIC_KEY:" + ShiroRedisSession.Redis.getSession().getId(), RSAUtil.getPubKey());
        ShiroRedisSession.Redis.setAttribute("RSA_PRIVATE_KEY:" + ShiroRedisSession.Redis.getSession().getId(), RSAUtil.getPriKey());
    }

    public static String getPublicKey() {
        Object key = ShiroRedisSession.Redis.getAttribute("RSA_PUBLIC_KEY:" + ShiroRedisSession.Redis.getSession().getId());
        if (key != null) {
            return (String)key;
        }
        Auth.initSecretKey();
        return RSAUtil.getPubKey();
    }

    public static String getPrivateKey() {
        Object key = ShiroRedisSession.Redis.getAttribute("RSA_PRIVATE_KEY:" + ShiroRedisSession.Redis.getSession().getId());
        if (key != null) {
            return (String)key;
        }
        return null;
    }
}

