/*
 * Decompiled with CFR 0.152.
 */
package org.daijie.shiro.aspect;

import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.daijie.core.annotation.Access;
import org.daijie.core.controller.enums.AccessType;
import org.daijie.core.result.ApiResult;
import org.daijie.core.result.factory.AspectFactory;
import org.daijie.shiro.session.ShiroRedisSession;

public abstract class AccessServiceAspect
implements AspectFactory {
    @Pointcut(value="@annotation(org.springframework.web.bind.annotation.RestController)")
    public void targets() {
    }

    @Before(value="targets()")
    public void before(JoinPoint jp) throws Exception {
        this.validAccess(jp);
    }

    @AfterReturning(returning="result", pointcut="targets()")
    public ApiResult after(Object result) throws Exception {
        return null;
    }

    public Access validAccess(JoinPoint jp) throws Exception {
        AccessType[] accessTypes;
        Access access = this.getAccess(jp);
        ShiroRedisSession.Redis.initSession();
        for (AccessType accessType : accessTypes = access.value()) {
            if (accessType.equals((Object)AccessType.NONE)) {
                access = null;
                continue;
            }
            if (!accessType.equals((Object)AccessType.TOKEN)) continue;
            this.validSession();
        }
        return access;
    }

    public Access getAccess(JoinPoint jp) throws Exception {
        Access access = ((MethodSignature)jp.getSignature()).getMethod().getAnnotation(Access.class);
        if (access == null) {
            access = jp.getTarget().getClass().getAnnotation(Access.class);
        }
        return access;
    }

    public void validSession() throws Exception {
        if (ShiroRedisSession.Redis.getSession() == null) {
            throw new Exception("Invalid token, cannot access resources.");
        }
    }
}

