/*
 * Decompiled with CFR 0.152.
 */
package org.daijie.shiro;

import com.baomidou.kisso.SSOHelper;
import com.baomidou.kisso.security.token.SSOToken;
import com.xiaoleilu.hutool.bean.BeanUtil;
import java.io.Serializable;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.util.ByteSource;
import org.daijie.core.kisso.KissoSecurityFactory;
import org.daijie.core.util.http.CookieUtil;
import org.daijie.core.util.http.HttpConversationUtil;
import org.daijie.shiro.authc.AuthorizationToken;
import org.daijie.shiro.authc.UserToken;
import org.daijie.shiro.session.ShiroRedisSession;

public class UserAuthorizingRealm
extends AuthorizingRealm
implements KissoSecurityFactory {
    public Boolean kissoEnable = true;

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        SimpleAuthorizationInfo simpleAuthorInfo = new SimpleAuthorizationInfo();
        Object user = principals.fromRealm(this.getName()).iterator().next();
        if (user instanceof String) {
            simpleAuthorInfo.addRole(null);
        } else {
            List<String> permissions;
            List<String> roles = ((UserToken)user).getRoles();
            if (roles != null) {
                simpleAuthorInfo.addRoles(roles);
            }
            if ((permissions = ((UserToken)user).getPermissions()) != null) {
                simpleAuthorInfo.addStringPermissions(permissions);
            }
        }
        return simpleAuthorInfo;
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) throws AuthenticationException {
        AuthorizationToken authorizationToken = (AuthorizationToken)token;
        String username = (String)token.getPrincipal();
        SimpleAuthenticationInfo authcInfo = null;
        Session session = ShiroRedisSession.Redis.getSession();
        if (authorizationToken.getUser() != null) {
            authcInfo = new SimpleAuthenticationInfo(authorizationToken.getUser(), (Object)authorizationToken.getPassword(), ByteSource.Util.bytes((String)username), this.getName());
            if (authorizationToken.getUser() instanceof Serializable && authorizationToken.getUser() instanceof UserToken) {
                UserToken userToken = (UserToken)authorizationToken.getUser();
                if (userToken.getAuthc() instanceof Serializable) {
                    userToken.setAuthc(BeanUtil.beanToMap((Object)userToken.getAuthc()));
                }
                ShiroRedisSession.Redis.setAttribute(authorizationToken.getAuthcKey(), userToken);
            } else {
                ShiroRedisSession.Redis.setAttribute(authorizationToken.getAuthcKey(), authorizationToken.getUser());
            }
        } else {
            authcInfo = new SimpleAuthenticationInfo((Object)authorizationToken.getUsername(), (Object)authorizationToken.getPassword(), ByteSource.Util.bytes((String)username), this.getName());
            ShiroRedisSession.Redis.setAttribute(authorizationToken.getAuthcKey(), username);
        }
        ShiroRedisSession.Redis.setAttribute("_AUTH_KEY_USER", authorizationToken.getAuthcKey());
        if (authorizationToken.getSalt() != null) {
            authcInfo.setCredentialsSalt(ByteSource.Util.bytes((String)authorizationToken.getSalt()));
        }
        if (this.kissoEnable.booleanValue()) {
            SSOToken ssoToken = SSOToken.create().setIp(HttpConversationUtil.getRequest()).setId((Object)1000).setIssuer(session.getId().toString());
            SSOHelper.setCookie((HttpServletRequest)HttpConversationUtil.getRequest(), (HttpServletResponse)HttpConversationUtil.getResponse(), (SSOToken)ssoToken, (boolean)false);
        } else {
            CookieUtil.set((String)"token", (String)session.getId().toString(), null);
        }
        return authcInfo;
    }

    public void setKissoEnable(Boolean kissoEnable) {
        this.kissoEnable = kissoEnable;
    }
}

