/*
 * Decompiled with CFR 0.152.
 */
package org.daijie.shiro;

import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authc.credential.CredentialsMatcher;
import org.apache.shiro.session.Session;
import org.daijie.core.util.encrypt.PasswordUtil;
import org.daijie.core.util.encrypt.RSAUtil;
import org.daijie.shiro.authc.AuthorizationToken;
import org.daijie.shiro.session.ClusterRedisSession;
import org.daijie.shiro.session.RedisSession;
import org.daijie.shiro.session.RedisSessionFactory;
import org.daijie.shiro.session.ShiroRedisSession;

public class TokenCredentialsMatcher
implements CredentialsMatcher {
    private boolean isValidation = false;
    private RedisSessionFactory redisSession;
    private Session session;

    public boolean doCredentialsMatch(AuthenticationToken token, AuthenticationInfo info) {
        if (!this.isValidation) {
            return true;
        }
        AuthorizationToken authcToken = (AuthorizationToken)token;
        SimpleAuthenticationInfo authcInfo = (SimpleAuthenticationInfo)info;
        if (this.redisSession instanceof RedisSession) {
            this.session = ((RedisSession)this.redisSession).readSession((Serializable)((Object)ShiroRedisSession.Redis.getToken()));
        } else if (this.redisSession instanceof ClusterRedisSession) {
            this.session = ((ClusterRedisSession)this.redisSession).readSession((Serializable)((Object)ShiroRedisSession.Redis.getToken()));
        }
        String privateKey = (String)this.session.getAttribute((Object)("RSA_PRIVATE_KEY:" + this.session.getId()));
        if (StringUtils.isBlank((String)privateKey)) {
            throw new AuthenticationException("\u6570\u636e\u5df2\u7ecf\u8fc7\u671f\u3002\u8bf7\u5237\u65b0\u91cd\u8bd5!");
        }
        try {
            RSAUtil.set(null, (String)privateKey);
            String password = RSAUtil.decryptByPriKey((String)new String(authcToken.getPubEncryptPassword()));
            password = PasswordUtil.generatePassword((String)password, (byte[])authcInfo.getCredentialsSalt().getBytes());
            if (!password.equals(new String((char[])authcInfo.getCredentials()))) {
                throw new AuthenticationException("\u5bc6\u7801\u9519\u8bef!");
            }
        }
        catch (Exception e) {
            throw new AuthenticationException("\u5bc6\u7801\u9519\u8bef!");
        }
        finally {
            this.session.removeAttribute((Object)("RSA_PRIVATE_KEY:" + this.session.getId()));
        }
        return true;
    }

    public boolean isValidation() {
        return this.isValidation;
    }

    public void setValidation(boolean isValidation) {
        this.isValidation = isValidation;
    }

    public RedisSessionFactory getRedisSession() {
        return this.redisSession;
    }

    public void setRedisSession(RedisSessionFactory redisSession) {
        this.redisSession = redisSession;
    }

    public Session getSession() {
        return this.session;
    }

    public void setSession(Session session) {
        this.session = session;
    }
}

