/*
 * Decompiled with CFR 0.152.
 */
package org.daijie.jdbc.transaction;

import javax.persistence.EntityManager;
import org.hibernate.resource.transaction.spi.TransactionStatus;
import org.springframework.core.Ordered;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.lang.Nullable;
import org.springframework.orm.jpa.EntityManagerFactoryUtils;
import org.springframework.orm.jpa.EntityManagerHolder;
import org.springframework.transaction.support.ResourceHolder;
import org.springframework.transaction.support.ResourceHolderSynchronization;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class MultipleTransactionSynchronizationEntityManager
extends ResourceHolderSynchronization<EntityManagerHolder, EntityManager>
implements Ordered {
    @Nullable
    private final PersistenceExceptionTranslator exceptionTranslator;
    private TransactionStatus status = TransactionStatus.NOT_ACTIVE;
    public volatile boolean closeOnCompletion = false;
    private final EntityManager entityManager;

    public MultipleTransactionSynchronizationEntityManager(EntityManager entityManager, @Nullable PersistenceExceptionTranslator exceptionTranslator) {
        super((ResourceHolder)new EntityManagerHolder(entityManager), (Object)entityManager);
        this.entityManager = entityManager;
        this.exceptionTranslator = exceptionTranslator;
    }

    public TransactionStatus getStatus() {
        return this.status;
    }

    public void setStatus(TransactionStatus status) {
        this.status = status;
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    public void begin() {
        if (this.status != TransactionStatus.ACTIVE) {
            this.status = TransactionStatus.ACTIVE;
            this.entityManager.getTransaction().begin();
            TransactionSynchronizationManager.bindResource((Object)this.entityManager, (Object)((Object)this));
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)this);
        }
    }

    public int getOrder() {
        return 899;
    }

    protected void flushResource(EntityManagerHolder resourceHolder) {
        try {
            this.entityManager.flush();
        }
        catch (RuntimeException ex) {
            throw this.convertException(ex);
        }
    }

    protected boolean shouldReleaseBeforeCompletion() {
        return false;
    }

    public void afterCommit() {
        super.afterCommit();
        try {
            this.entityManager.getTransaction().commit();
        }
        catch (RuntimeException ex) {
            throw this.convertException(ex);
        }
    }

    public void afterCompletion(int status) {
        block6: {
            try {
                super.afterCompletion(status);
                if (status == 0) break block6;
                try {
                    this.entityManager.getTransaction().rollback();
                }
                catch (RuntimeException ex) {
                    throw this.convertException(ex);
                }
            }
            finally {
                if (this.closeOnCompletion) {
                    EntityManagerFactoryUtils.closeEntityManager((EntityManager)this.entityManager);
                }
            }
        }
    }

    private RuntimeException convertException(RuntimeException ex) {
        DataAccessException daex = this.exceptionTranslator != null ? this.exceptionTranslator.translateExceptionIfPossible(ex) : EntityManagerFactoryUtils.convertJpaAccessExceptionIfPossible((RuntimeException)ex);
        return daex != null ? daex : ex;
    }
}

