/*
 * Decompiled with CFR 0.152.
 */
package org.daijie.jdbc.mybatis.transaction;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.transaction.Transaction;
import org.daijie.jdbc.DbContextHolder;
import org.daijie.jdbc.interceptor.DefaultRoutingDataSource;
import org.springframework.jdbc.datasource.ConnectionHolder;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;

public class MybatisMultipleTransaction
implements Transaction {
    private static final Log LOGGER = LogFactory.getLog(MybatisMultipleTransaction.class);
    private final DefaultRoutingDataSource dataSource;
    private Connection connection;
    private boolean isConnectionTransactional;
    private boolean autoCommit;

    public MybatisMultipleTransaction(DataSource dataSource) {
        Assert.notNull((Object)dataSource, (String)"\u6ca1\u6709\u521d\u59cb\u5316\u6570\u636e\u6e90");
        this.dataSource = (DefaultRoutingDataSource)((Object)dataSource);
    }

    public Connection getConnection() throws SQLException {
        this.openConnection();
        return this.connection;
    }

    public void commit() throws SQLException {
        if (this.connection != null && !this.isConnectionTransactional && !this.autoCommit) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("\u63d0\u4ea4\u4e8b\u52a1 [" + this.connection + "]");
            }
            this.connection.commit();
        }
    }

    public void rollback() throws SQLException {
        if (this.connection != null && !this.isConnectionTransactional && !this.autoCommit) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("\u56de\u6eda\u4e8b\u52a1 [" + this.connection + "]");
            }
            this.connection.rollback();
        }
    }

    public void close() throws SQLException {
        DataSourceUtils.releaseConnection((Connection)this.connection, (DataSource)((Object)this.dataSource));
    }

    public Integer getTimeout() throws SQLException {
        ConnectionHolder holder = (ConnectionHolder)TransactionSynchronizationManager.getResource((Object)((Object)this.dataSource));
        if (holder != null && holder.hasTimeout()) {
            return holder.getTimeToLiveInSeconds();
        }
        return null;
    }

    private void openConnection() throws SQLException {
        Object dataSource = this.dataSource.getTargetDataSources().get(DbContextHolder.getDataSourceName());
        if (dataSource == null) {
            dataSource = this.dataSource;
        }
        this.connection = DataSourceUtils.getConnection((DataSource)dataSource);
        this.isConnectionTransactional = DataSourceUtils.isConnectionTransactional((Connection)this.connection, (DataSource)dataSource);
        this.connection.setAutoCommit(!this.isConnectionTransactional);
        this.autoCommit = this.connection.getAutoCommit();
    }
}

