/*
 * Decompiled with CFR 0.152.
 */
package org.daijie.jdbc.mybatis.transaction;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.daijie.jdbc.DbContextHolder;
import org.daijie.jdbc.interceptor.DefaultRoutingDataSource;
import org.daijie.jdbc.mybatis.transaction.MultipleConnectionHolder;
import org.springframework.jdbc.datasource.ConnectionHolder;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.jdbc.datasource.JdbcTransactionObjectSupport;
import org.springframework.lang.Nullable;
import org.springframework.transaction.CannotCreateTransactionException;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.transaction.support.DefaultTransactionStatus;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.transaction.support.TransactionSynchronizationUtils;

@Deprecated
public class MultipleTransactionManager
extends DataSourceTransactionManager {
    public MultipleTransactionManager(DataSource dataSource) {
        super(dataSource);
    }

    protected Object doGetTransaction() {
        MultipleTransactionObject txObject = new MultipleTransactionObject();
        txObject.setSavepointAllowed(this.isNestedTransactionAllowed());
        ConnectionHolder conHolder = (ConnectionHolder)TransactionSynchronizationManager.getResource((Object)this.obtainDataSource());
        txObject.setConnectionHolder(conHolder, false);
        return txObject;
    }

    protected boolean isExistingTransaction(Object transaction) {
        MultipleTransactionObject txObject = (MultipleTransactionObject)((Object)transaction);
        return txObject.hasConnectionHolder();
    }

    protected void doBegin(Object transaction, TransactionDefinition definition) {
        MultipleTransactionObject txObject = (MultipleTransactionObject)((Object)transaction);
        try {
            if (!txObject.hasConnectionHolder() || txObject.getConnectionHolder().isSynchronizedWithTransaction()) {
                Connection newCon = this.obtainDataSource().getConnection();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Acquired Connection [" + newCon + "] for JDBC transaction"));
                }
                txObject.setConnectionHolder(new MultipleConnectionHolder(newCon), true);
            }
            DbContextHolder.getDataSourceName();
            Map<Object, DataSource> targetDataSources = ((DefaultRoutingDataSource)((Object)this.obtainDataSource())).getTargetDataSources();
            Iterator<Map.Entry<Object, DataSource>> iterator = targetDataSources.entrySet().iterator();
            while (iterator.hasNext()) {
                DataSource dataSource = iterator.next().getValue();
                ConnectionHolder connectionHolder = new ConnectionHolder(dataSource.getConnection());
                connectionHolder.setSynchronizedWithTransaction(true);
                Integer previousIsolationLevel = DataSourceUtils.prepareConnectionForTransaction((Connection)connectionHolder.getConnection(), (TransactionDefinition)definition);
                txObject.setPreviousIsolationLevel(previousIsolationLevel);
                if (connectionHolder.getConnection().getAutoCommit()) {
                    txObject.setMustRestoreAutoCommit(true);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Switching JDBC Connection [" + connectionHolder.getConnection() + "] to manual commit"));
                    }
                    connectionHolder.getConnection().setAutoCommit(false);
                }
                this.prepareTransactionalConnection(connectionHolder.getConnection(), definition);
                int timeout = this.determineTimeout(definition);
                if (timeout != -1) {
                    connectionHolder.setTimeoutInSeconds(timeout);
                }
                TransactionSynchronizationManager.bindResource((Object)dataSource, (Object)connectionHolder);
                ((MultipleConnectionHolder)txObject.getConnectionHolder()).getConnectionHolders().add(connectionHolder);
            }
        }
        catch (Throwable ex) {
            if (txObject.isNewConnectionHolder()) {
                txObject.setConnectionHolder(null, false);
            }
            throw new CannotCreateTransactionException("Could not open JDBC Connection for transaction", ex);
        }
    }

    protected Object doSuspend(Object transaction) {
        MultipleTransactionObject txObject = (MultipleTransactionObject)((Object)transaction);
        txObject.setConnectionHolder(null);
        return TransactionSynchronizationManager.unbindResource((Object)this.obtainDataSource());
    }

    protected void doResume(@Nullable Object transaction, Object suspendedResources) {
        TransactionSynchronizationManager.bindResource((Object)this.obtainDataSource(), (Object)suspendedResources);
    }

    protected void doCommit(DefaultTransactionStatus status) {
        status.getTransaction();
        MultipleTransactionObject txObject = (MultipleTransactionObject)((Object)status.getTransaction());
        Set<ConnectionHolder> holders = ((MultipleConnectionHolder)txObject.getConnectionHolder()).getConnectionHolders();
        holders.forEach(holder -> {
            try {
                holder.getConnection().commit();
            }
            catch (SQLException ex) {
                throw new TransactionSystemException("Could not commit JDBC transaction", (Throwable)ex);
            }
        });
    }

    protected void doRollback(DefaultTransactionStatus status) {
        MultipleTransactionObject txObject = (MultipleTransactionObject)((Object)status.getTransaction());
        Set<ConnectionHolder> holders = ((MultipleConnectionHolder)txObject.getConnectionHolder()).getConnectionHolders();
        holders.forEach(holder -> {
            try {
                holder.getConnection().rollback();
            }
            catch (SQLException ex) {
                throw new TransactionSystemException("Could not roll back JDBC transaction", (Throwable)ex);
            }
        });
    }

    protected void doSetRollbackOnly(DefaultTransactionStatus status) {
        MultipleTransactionObject txObject = (MultipleTransactionObject)((Object)status.getTransaction());
        if (status.isDebug()) {
            this.logger.debug((Object)("Setting JDBC transaction [" + txObject.getConnectionHolder().getConnection() + "] rollback-only"));
        }
        txObject.setRollbackOnly();
    }

    protected void doCleanupAfterCompletion(Object transaction) {
        MultipleTransactionObject txObject = (MultipleTransactionObject)((Object)transaction);
        Set<ConnectionHolder> holders = ((MultipleConnectionHolder)txObject.getConnectionHolder()).getConnectionHolders();
        holders.forEach(holder -> {
            try {
                holder.getConnection().setAutoCommit(true);
            }
            catch (SQLException ex) {
                throw new TransactionSystemException("Could not reset JDBC Connection after transaction", (Throwable)ex);
            }
        });
        txObject.getConnectionHolder().clear();
    }

    private static class MultipleTransactionObject
    extends JdbcTransactionObjectSupport {
        private boolean newConnectionHolder;
        private boolean mustRestoreAutoCommit;

        private MultipleTransactionObject() {
        }

        public void setConnectionHolder(@Nullable ConnectionHolder conHolder, boolean newConnectionHolder) {
            super.setConnectionHolder(conHolder);
            this.newConnectionHolder = newConnectionHolder;
        }

        public boolean isNewConnectionHolder() {
            return this.newConnectionHolder;
        }

        public void setMustRestoreAutoCommit(boolean mustRestoreAutoCommit) {
            this.mustRestoreAutoCommit = mustRestoreAutoCommit;
        }

        public boolean isMustRestoreAutoCommit() {
            return this.mustRestoreAutoCommit;
        }

        public void setRollbackOnly() {
            this.getConnectionHolder().setRollbackOnly();
        }

        public boolean isRollbackOnly() {
            return this.getConnectionHolder().isRollbackOnly();
        }

        public void flush() {
            if (TransactionSynchronizationManager.isSynchronizationActive()) {
                TransactionSynchronizationUtils.triggerFlush();
            }
        }
    }
}

