/*
 * Decompiled with CFR 0.152.
 */
package org.daijie.jdbc.mybatis;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.exceptions.PersistenceException;
import org.apache.ibatis.executor.BatchResult;
import org.apache.ibatis.reflection.ExceptionUtil;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.daijie.jdbc.DbContextHolder;
import org.daijie.jdbc.annotation.SelectDataSource;
import org.mybatis.spring.MyBatisExceptionTranslator;
import org.mybatis.spring.SqlSessionTemplate;
import org.mybatis.spring.SqlSessionUtils;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.PersistenceExceptionTranslator;

public class MybatisMultipleSqlSessionTemplate
extends SqlSessionTemplate {
    private final SqlSessionFactory sqlSessionFactory;
    private final ExecutorType executorType;
    private final SqlSession sqlSessionProxy;
    private final PersistenceExceptionTranslator exceptionTranslator;
    private Map<Object, SqlSessionFactory> targetSqlSessionFactorys;
    private SqlSessionFactory defaultTargetSqlSessionFactory;

    public void setTargetSqlSessionFactorys(Map<Object, SqlSessionFactory> targetSqlSessionFactorys) {
        this.targetSqlSessionFactorys = targetSqlSessionFactorys;
    }

    public void setDefaultTargetSqlSessionFactory(SqlSessionFactory defaultTargetSqlSessionFactory) {
        this.defaultTargetSqlSessionFactory = defaultTargetSqlSessionFactory;
    }

    public SqlSessionFactory getDefaultTargetSqlSessionFactory() {
        return this.defaultTargetSqlSessionFactory;
    }

    public MybatisMultipleSqlSessionTemplate(SqlSessionFactory sqlSessionFactory) {
        this(sqlSessionFactory, sqlSessionFactory.getConfiguration().getDefaultExecutorType());
    }

    public MybatisMultipleSqlSessionTemplate(SqlSessionFactory sqlSessionFactory, ExecutorType executorType) {
        this(sqlSessionFactory, executorType, (PersistenceExceptionTranslator)new MyBatisExceptionTranslator(sqlSessionFactory.getConfiguration().getEnvironment().getDataSource(), true));
    }

    public MybatisMultipleSqlSessionTemplate(SqlSessionFactory sqlSessionFactory, ExecutorType executorType, PersistenceExceptionTranslator exceptionTranslator) {
        super(sqlSessionFactory, executorType, exceptionTranslator);
        this.sqlSessionFactory = sqlSessionFactory;
        this.executorType = executorType;
        this.exceptionTranslator = exceptionTranslator;
        this.sqlSessionProxy = (SqlSession)Proxy.newProxyInstance(SqlSessionFactory.class.getClassLoader(), new Class[]{SqlSession.class}, (InvocationHandler)new SqlSessionInterceptor());
        this.defaultTargetSqlSessionFactory = sqlSessionFactory;
    }

    public SqlSessionFactory getSqlSessionFactory() {
        return this.sqlSessionFactory;
    }

    public List<Configuration> getAllConfigurations() {
        ArrayList<Configuration> list = new ArrayList<Configuration>();
        for (Map.Entry<Object, SqlSessionFactory> entry : this.targetSqlSessionFactorys.entrySet()) {
            SqlSessionFactory sqlSessionFactory = entry.getValue();
            list.add(sqlSessionFactory.getConfiguration());
        }
        return list;
    }

    public Configuration getConfiguration() {
        return this.getSqlSessionFactory().getConfiguration();
    }

    public ExecutorType getExecutorType() {
        return this.executorType;
    }

    public PersistenceExceptionTranslator getPersistenceExceptionTranslator() {
        return this.exceptionTranslator;
    }

    public <T> T selectOne(String statement) {
        return (T)this.sqlSessionProxy.selectOne(statement);
    }

    public <T> T selectOne(String statement, Object parameter) {
        return (T)this.sqlSessionProxy.selectOne(statement, parameter);
    }

    public <K, V> Map<K, V> selectMap(String statement, String mapKey) {
        return this.sqlSessionProxy.selectMap(statement, mapKey);
    }

    public <K, V> Map<K, V> selectMap(String statement, Object parameter, String mapKey) {
        return this.sqlSessionProxy.selectMap(statement, parameter, mapKey);
    }

    public <K, V> Map<K, V> selectMap(String statement, Object parameter, String mapKey, RowBounds rowBounds) {
        return this.sqlSessionProxy.selectMap(statement, parameter, mapKey, rowBounds);
    }

    public <E> List<E> selectList(String statement) {
        return this.sqlSessionProxy.selectList(statement);
    }

    public <E> List<E> selectList(String statement, Object parameter) {
        return this.sqlSessionProxy.selectList(statement, parameter);
    }

    public <E> List<E> selectList(String statement, Object parameter, RowBounds rowBounds) {
        return this.sqlSessionProxy.selectList(statement, parameter, rowBounds);
    }

    public void select(String statement, ResultHandler handler) {
        this.sqlSessionProxy.select(statement, handler);
    }

    public void select(String statement, Object parameter, ResultHandler handler) {
        this.sqlSessionProxy.select(statement, parameter, handler);
    }

    public void select(String statement, Object parameter, RowBounds rowBounds, ResultHandler handler) {
        this.sqlSessionProxy.select(statement, parameter, rowBounds, handler);
    }

    public int insert(String statement) {
        return this.sqlSessionProxy.insert(statement);
    }

    public int insert(String statement, Object parameter) {
        return this.sqlSessionProxy.insert(statement, parameter);
    }

    public int update(String statement) {
        return this.sqlSessionProxy.update(statement);
    }

    public int update(String statement, Object parameter) {
        return this.sqlSessionProxy.update(statement, parameter);
    }

    public int delete(String statement) {
        return this.sqlSessionProxy.delete(statement);
    }

    public int delete(String statement, Object parameter) {
        return this.sqlSessionProxy.delete(statement, parameter);
    }

    public <T> T getMapper(Class<T> type) {
        return (T)this.getConfiguration().getMapper(type, (SqlSession)this);
    }

    public void commit() {
        super.commit();
    }

    public void commit(boolean force) {
        super.commit(force);
    }

    public void rollback() {
        super.rollback();
    }

    public void rollback(boolean force) {
        super.rollback(force);
    }

    public void close() {
        super.close();
    }

    public void clearCache() {
        super.clearCache();
    }

    public Connection getConnection() {
        return super.getConnection();
    }

    public List<BatchResult> flushStatements() {
        return super.flushStatements();
    }

    private void selectDataSource(Object[] args) throws ClassNotFoundException {
        Class<?> targetClass = Class.forName(args[0].toString().substring(0, args[0].toString().lastIndexOf(".")));
        AccessibleObject targetMethod = null;
        try {
            targetMethod = targetClass.getMethod(args[0].toString().substring(args[0].toString().lastIndexOf(".") + 1), args[1].getClass());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (targetMethod != null && targetMethod.isAnnotationPresent(SelectDataSource.class)) {
            SelectDataSource selectDataSource = ((Method)targetMethod).getAnnotation(SelectDataSource.class);
            DbContextHolder.setDataSourceName(selectDataSource.name());
        } else if (targetClass.isAnnotationPresent(SelectDataSource.class)) {
            SelectDataSource selectDataSource = targetClass.getAnnotation(SelectDataSource.class);
            DbContextHolder.setDataSourceName(selectDataSource.name());
        }
    }

    private class SqlSessionInterceptor
    implements InvocationHandler {
        private SqlSessionInterceptor() {
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            SqlSession sqlSession = SqlSessionUtils.getSqlSession((SqlSessionFactory)MybatisMultipleSqlSessionTemplate.this.getSqlSessionFactory(), (ExecutorType)MybatisMultipleSqlSessionTemplate.this.executorType, (PersistenceExceptionTranslator)MybatisMultipleSqlSessionTemplate.this.exceptionTranslator);
            try {
                MybatisMultipleSqlSessionTemplate.this.selectDataSource(args);
                Object result = method.invoke((Object)sqlSession, args);
                sqlSession.rollback();
                if (!SqlSessionUtils.isSqlSessionTransactional((SqlSession)sqlSession, (SqlSessionFactory)MybatisMultipleSqlSessionTemplate.this.getSqlSessionFactory())) {
                    sqlSession.commit(true);
                }
                Object object = result;
                return object;
            }
            catch (Throwable t) {
                DataAccessException translated;
                Throwable unwrapped = ExceptionUtil.unwrapThrowable((Throwable)t);
                if (MybatisMultipleSqlSessionTemplate.this.exceptionTranslator != null && unwrapped instanceof PersistenceException && (translated = MybatisMultipleSqlSessionTemplate.this.exceptionTranslator.translateExceptionIfPossible((RuntimeException)((PersistenceException)unwrapped))) != null) {
                    unwrapped = translated;
                }
                throw unwrapped;
            }
            finally {
                SqlSessionUtils.closeSqlSession((SqlSession)sqlSession, (SqlSessionFactory)MybatisMultipleSqlSessionTemplate.this.getSqlSessionFactory());
            }
        }
    }
}

