/*
 * Decompiled with CFR 0.152.
 */
package org.daijie.jdbc.jpa.repository;

import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import javax.persistence.EntityManager;
import org.daijie.jdbc.DbContextHolder;
import org.daijie.jdbc.annotation.SelectDataSource;
import org.daijie.jdbc.jpa.repository.BaseSearchJpaRepository;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.repository.support.SimpleJpaRepository;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Transactional(readOnly=true)
public class JpaMultipleRepository<E, ID extends Serializable>
extends SimpleJpaRepository<E, ID>
implements BaseSearchJpaRepository<E, ID> {
    private final Class<? extends E> repositoryInterface;

    public JpaMultipleRepository(Class<E> domainClass, EntityManager entityManager, Class<? extends E> repositoryInterface) {
        super(domainClass, entityManager);
        this.repositoryInterface = repositoryInterface;
    }

    public void selectDataSource() {
        if (this.repositoryInterface.isAnnotationPresent(SelectDataSource.class)) {
            SelectDataSource selectDataSource = this.repositoryInterface.getAnnotation(SelectDataSource.class);
            DbContextHolder.setDataSourceName(selectDataSource.name());
        }
    }

    public void deleteById(ID id) {
        this.selectDataSource();
        super.deleteById(id);
    }

    public void delete(E entity) {
        this.selectDataSource();
        super.delete(entity);
    }

    public void deleteInBatch(Iterable<E> entities) {
        this.selectDataSource();
        super.deleteInBatch(entities);
    }

    public void deleteAllInBatch() {
        this.selectDataSource();
        super.deleteAllInBatch();
    }

    public Optional<E> findById(ID id) {
        this.selectDataSource();
        return super.findById(id);
    }

    public E getOne(ID id) {
        this.selectDataSource();
        return (E)super.getOne(id);
    }

    public boolean existsById(ID id) {
        this.selectDataSource();
        return super.existsById(id);
    }

    public List<E> findAll() {
        this.selectDataSource();
        return super.findAll();
    }

    public List<E> findAllById(Iterable<ID> ids) {
        this.selectDataSource();
        return super.findAllById(ids);
    }

    public List<E> findAll(Sort sort) {
        this.selectDataSource();
        return super.findAll(sort);
    }

    public Page<E> findAll(Pageable pageable) {
        this.selectDataSource();
        return super.findAll(pageable);
    }

    public Optional<E> findOne(@Nullable Specification<E> spec) {
        this.selectDataSource();
        return super.findOne(spec);
    }

    public List<E> findAll(@Nullable Specification<E> spec) {
        this.selectDataSource();
        return super.findAll(spec);
    }

    public Page<E> findAll(@Nullable Specification<E> spec, Pageable pageable) {
        this.selectDataSource();
        return super.findAll(spec, pageable);
    }

    public List<E> findAll(@Nullable Specification<E> spec, Sort sort) {
        this.selectDataSource();
        return super.findAll(spec, sort);
    }

    public <S extends E> Optional<S> findOne(Example<S> example) {
        this.selectDataSource();
        return super.findOne(example);
    }

    public <S extends E> long count(Example<S> example) {
        this.selectDataSource();
        return super.count(example);
    }

    public <S extends E> boolean exists(Example<S> example) {
        this.selectDataSource();
        return super.exists(example);
    }

    public <S extends E> List<S> findAll(Example<S> example) {
        this.selectDataSource();
        return super.findAll(example);
    }

    public <S extends E> List<S> findAll(Example<S> example, Sort sort) {
        this.selectDataSource();
        return super.findAll(example, sort);
    }

    public <S extends E> Page<S> findAll(Example<S> example, Pageable pageable) {
        this.selectDataSource();
        return super.findAll(example, pageable);
    }

    public long count() {
        this.selectDataSource();
        return super.count();
    }

    public long count(@Nullable Specification<E> spec) {
        this.selectDataSource();
        return super.count(spec);
    }

    public <S extends E> S save(S entity) {
        this.selectDataSource();
        return (S)super.save(entity);
    }

    public <S extends E> S saveAndFlush(S entity) {
        this.selectDataSource();
        return (S)super.saveAndFlush(entity);
    }

    public <S extends E> List<S> saveAll(Iterable<S> entities) {
        this.selectDataSource();
        return super.saveAll(entities);
    }

    public void flush() {
        this.selectDataSource();
        super.flush();
    }
}

