/*
 * Decompiled with CFR 0.152.
 */
package org.daijie.jdbc.jpa;

import java.lang.instrument.ClassFileTransformer;
import javax.persistence.spi.ClassTransformer;
import org.daijie.jdbc.jpa.ClassFileTransformerAdapter;
import org.springframework.core.DecoratingClassLoader;
import org.springframework.instrument.classloading.LoadTimeWeaver;
import org.springframework.instrument.classloading.SimpleThrowawayClassLoader;
import org.springframework.lang.Nullable;
import org.springframework.orm.jpa.persistenceunit.MutablePersistenceUnitInfo;
import org.springframework.util.Assert;

public class SpringPersistenceUnitInfo
extends MutablePersistenceUnitInfo {
    @Nullable
    private LoadTimeWeaver loadTimeWeaver;
    @Nullable
    private ClassLoader classLoader;

    public void init(LoadTimeWeaver loadTimeWeaver) {
        Assert.notNull((Object)loadTimeWeaver, (String)"LoadTimeWeaver must not be null");
        this.loadTimeWeaver = loadTimeWeaver;
        this.classLoader = loadTimeWeaver.getInstrumentableClassLoader();
    }

    public void init(@Nullable ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Nullable
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void addTransformer(ClassTransformer classTransformer) {
        if (this.loadTimeWeaver == null) {
            throw new IllegalStateException("Cannot apply class transformer without LoadTimeWeaver specified");
        }
        this.loadTimeWeaver.addTransformer((ClassFileTransformer)new ClassFileTransformerAdapter(classTransformer));
    }

    public ClassLoader getNewTempClassLoader() {
        Object tcl = this.loadTimeWeaver != null ? this.loadTimeWeaver.getThrowawayClassLoader() : new SimpleThrowawayClassLoader(this.classLoader);
        String packageToExclude = this.getPersistenceProviderPackageName();
        if (packageToExclude != null && tcl instanceof DecoratingClassLoader) {
            ((DecoratingClassLoader)tcl).excludePackage(packageToExclude);
        }
        return tcl;
    }
}

