/*
 * Decompiled with CFR 0.152.
 */
package org.daijie.jdbc.jpa;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Query;
import javax.persistence.TransactionRequiredException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.lang.Nullable;
import org.springframework.orm.jpa.EntityManagerFactoryInfo;
import org.springframework.orm.jpa.EntityManagerFactoryUtils;
import org.springframework.orm.jpa.EntityManagerHolder;
import org.springframework.orm.jpa.EntityManagerProxy;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;

public class MultipleSharedEntityManagerCreator {
    private static final Class<?>[] NO_ENTITY_MANAGER_INTERFACES = new Class[0];
    private static final Set<String> transactionRequiringMethods = new HashSet<String>(8);
    private static final Set<String> queryTerminatingMethods = new HashSet<String>(8);

    public static EntityManager createSharedEntityManager(EntityManagerFactory emf) {
        return MultipleSharedEntityManagerCreator.createSharedEntityManager(emf, null, true);
    }

    public static EntityManager createSharedEntityManager(EntityManagerFactory emf, @Nullable Map<?, ?> properties) {
        return MultipleSharedEntityManagerCreator.createSharedEntityManager(emf, properties, true);
    }

    public static EntityManager createSharedEntityManager(EntityManagerFactory emf, @Nullable Map<?, ?> properties, boolean synchronizedWithTransaction) {
        Class<?>[] classArray;
        Class emIfc;
        Class clazz = emIfc = emf instanceof EntityManagerFactoryInfo ? ((EntityManagerFactoryInfo)emf).getEntityManagerInterface() : EntityManager.class;
        if (emIfc == null) {
            classArray = NO_ENTITY_MANAGER_INTERFACES;
        } else {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = emIfc;
        }
        return MultipleSharedEntityManagerCreator.createSharedEntityManager(emf, properties, synchronizedWithTransaction, classArray);
    }

    public static EntityManager createSharedEntityManager(EntityManagerFactory emf, @Nullable Map<?, ?> properties, Class<?> ... entityManagerInterfaces) {
        return MultipleSharedEntityManagerCreator.createSharedEntityManager(emf, properties, true, entityManagerInterfaces);
    }

    public static EntityManager createSharedEntityManager(EntityManagerFactory emf, @Nullable Map<?, ?> properties, boolean synchronizedWithTransaction, Class<?> ... entityManagerInterfaces) {
        ClassLoader cl = null;
        if (emf instanceof EntityManagerFactoryInfo) {
            cl = ((EntityManagerFactoryInfo)emf).getBeanClassLoader();
        }
        Class[] ifcs = new Class[entityManagerInterfaces.length + 1];
        System.arraycopy(entityManagerInterfaces, 0, ifcs, 0, entityManagerInterfaces.length);
        ifcs[entityManagerInterfaces.length] = EntityManagerProxy.class;
        return (EntityManager)Proxy.newProxyInstance(cl != null ? cl : MultipleSharedEntityManagerCreator.class.getClassLoader(), ifcs, (InvocationHandler)new MultipleEntityManagerInvocationHandler(emf, properties, synchronizedWithTransaction));
    }

    static {
        transactionRequiringMethods.add("joinTransaction");
        transactionRequiringMethods.add("flush");
        transactionRequiringMethods.add("persist");
        transactionRequiringMethods.add("merge");
        transactionRequiringMethods.add("remove");
        transactionRequiringMethods.add("refresh");
        queryTerminatingMethods.add("executeUpdate");
        queryTerminatingMethods.add("getSingleResult");
        queryTerminatingMethods.add("getResultList");
        queryTerminatingMethods.add("getResultStream");
    }

    private static class DeferredQueryInvocationHandler
    implements InvocationHandler {
        private final Query target;
        @Nullable
        private EntityManager em;

        public DeferredQueryInvocationHandler(Query target, EntityManager em) {
            this.target = target;
            this.em = em;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("equals")) {
                return proxy == args[0];
            }
            if (method.getName().equals("hashCode")) {
                return this.hashCode();
            }
            if (method.getName().equals("unwrap")) {
                Class targetClass = (Class)args[0];
                if (targetClass == null) {
                    return this.target;
                }
                if (targetClass.isInstance(proxy)) {
                    return proxy;
                }
            }
            try {
                Object retVal = method.invoke((Object)this.target, args);
                Object object = retVal == this.target ? proxy : retVal;
                return object;
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
            finally {
                if (queryTerminatingMethods.contains(method.getName())) {
                    EntityManagerFactoryUtils.closeEntityManager((EntityManager)this.em);
                    this.em = null;
                }
            }
        }
    }

    private static class MultipleEntityManagerInvocationHandler
    implements InvocationHandler,
    Serializable {
        private final Log logger = LogFactory.getLog(this.getClass());
        private final EntityManagerFactory targetFactory;
        @Nullable
        private final Map<?, ?> properties;
        private final boolean synchronizedWithTransaction;
        @Nullable
        private volatile transient ClassLoader proxyClassLoader;

        public MultipleEntityManagerInvocationHandler(EntityManagerFactory target, @Nullable Map<?, ?> properties, boolean synchronizedWithTransaction) {
            this.targetFactory = target;
            this.properties = properties;
            this.synchronizedWithTransaction = synchronizedWithTransaction;
            this.initProxyClassLoader();
        }

        private void initProxyClassLoader() {
            this.proxyClassLoader = this.targetFactory instanceof EntityManagerFactoryInfo ? ((EntityManagerFactoryInfo)this.targetFactory).getBeanClassLoader() : this.targetFactory.getClass().getClassLoader();
        }

        @Override
        @Nullable
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            EntityManagerHolder emHolder;
            if (method.getName().equals("equals")) {
                return proxy == args[0];
            }
            if (method.getName().equals("hashCode")) {
                return this.hashCode();
            }
            if (method.getName().equals("toString")) {
                return "Shared EntityManager proxy for target factory [" + this.targetFactory + "]";
            }
            if (method.getName().equals("getEntityManagerFactory")) {
                return this.targetFactory;
            }
            if (method.getName().equals("getCriteriaBuilder") || method.getName().equals("getMetamodel")) {
                try {
                    return EntityManagerFactory.class.getMethod(method.getName(), new Class[0]).invoke((Object)this.targetFactory, new Object[0]);
                }
                catch (InvocationTargetException ex) {
                    throw ex.getTargetException();
                }
            }
            if (method.getName().equals("unwrap")) {
                Class targetClass = (Class)args[0];
                if (targetClass != null && targetClass.isInstance(proxy)) {
                    return proxy;
                }
            } else {
                if (method.getName().equals("isOpen")) {
                    return true;
                }
                if (method.getName().equals("close")) {
                    return null;
                }
                if (method.getName().equals("getTransaction")) {
                    throw new IllegalStateException("Not allowed to create transaction on shared EntityManager - use Spring transactions or EJB CMT instead");
                }
            }
            if ((emHolder = (EntityManagerHolder)TransactionSynchronizationManager.getResource((Object)this.targetFactory)) != null && emHolder.getEntityManager() != null) {
                emHolder.getEntityManager().isJoinedToTransaction();
            }
            EntityManager target = EntityManagerFactoryUtils.doGetTransactionalEntityManager((EntityManagerFactory)this.targetFactory, this.properties, (boolean)this.synchronizedWithTransaction);
            if (method.getName().equals("getTargetEntityManager")) {
                if (target == null) {
                    throw new IllegalStateException("No transactional EntityManager available");
                }
                return target;
            }
            if (method.getName().equals("unwrap")) {
                Class targetClass = (Class)args[0];
                if (targetClass == null) {
                    return target != null ? target : proxy;
                }
                if (target == null) {
                    throw new IllegalStateException("No transactional EntityManager available");
                }
            } else if (transactionRequiringMethods.contains(method.getName()) && (target == null || !TransactionSynchronizationManager.isActualTransactionActive() && !target.getTransaction().isActive())) {
                throw new TransactionRequiredException("No EntityManager with actual transaction available for current thread - cannot reliably process '" + method.getName() + "' call");
            }
            boolean isNewEm = false;
            if (target == null) {
                this.logger.debug((Object)"Creating new EntityManager for shared EntityManager invocation");
                target = !CollectionUtils.isEmpty(this.properties) ? this.targetFactory.createEntityManager(this.properties) : this.targetFactory.createEntityManager();
                isNewEm = true;
            }
            try {
                Object result = method.invoke((Object)target, args);
                if (result instanceof Query) {
                    Query query = (Query)result;
                    if (isNewEm) {
                        Class[] ifcs = ClassUtils.getAllInterfacesForClass(query.getClass(), (ClassLoader)this.proxyClassLoader);
                        result = Proxy.newProxyInstance(this.proxyClassLoader, ifcs, (InvocationHandler)new DeferredQueryInvocationHandler(query, target));
                        isNewEm = false;
                    } else {
                        EntityManagerFactoryUtils.applyTransactionTimeout((Query)query, (EntityManagerFactory)this.targetFactory);
                    }
                }
                Object object = result;
                return object;
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
            finally {
                if (isNewEm) {
                    EntityManagerFactoryUtils.closeEntityManager((EntityManager)target);
                }
            }
        }

        private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
            ois.defaultReadObject();
            this.initProxyClassLoader();
        }
    }
}

