/*
 * Decompiled with CFR 0.152.
 */
package org.daijie.jdbc.jpa;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.persistence.spi.PersistenceUnitTransactionType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.daijie.jdbc.DbContextHolder;
import org.daijie.jdbc.jpa.MultipleSessionImpl;
import org.daijie.jdbc.transaction.MultipleTransactionSynchronizationEntityManager;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.lang.Nullable;
import org.springframework.orm.jpa.EntityManagerFactoryInfo;
import org.springframework.orm.jpa.EntityManagerProxy;
import org.springframework.orm.jpa.ExtendedEntityManagerCreator;
import org.springframework.orm.jpa.JpaDialect;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;

public class MultipleExtendedEntityManagerCreator {
    public static EntityManager createApplicationManagedEntityManager(EntityManager rawEntityManager, EntityManagerFactoryInfo emfInfo) {
        return MultipleExtendedEntityManagerCreator.createProxy(rawEntityManager, emfInfo, false, false);
    }

    public static EntityManager createApplicationManagedEntityManager(EntityManager rawEntityManager, EntityManagerFactoryInfo emfInfo, boolean synchronizedWithTransaction) {
        return MultipleExtendedEntityManagerCreator.createProxy(rawEntityManager, emfInfo, false, synchronizedWithTransaction);
    }

    public static EntityManager createContainerManagedEntityManager(EntityManager rawEntityManager, EntityManagerFactoryInfo emfInfo) {
        return MultipleExtendedEntityManagerCreator.createProxy(rawEntityManager, emfInfo, true, true);
    }

    public static EntityManager createContainerManagedEntityManager(EntityManagerFactory emf) {
        return MultipleExtendedEntityManagerCreator.createContainerManagedEntityManager(emf, null, true);
    }

    public static EntityManager createContainerManagedEntityManager(EntityManagerFactory emf, @Nullable Map<?, ?> properties) {
        return MultipleExtendedEntityManagerCreator.createContainerManagedEntityManager(emf, properties, true);
    }

    public static EntityManager createContainerManagedEntityManager(EntityManagerFactory emf, @Nullable Map<?, ?> properties, boolean synchronizedWithTransaction) {
        Assert.notNull((Object)emf, (String)"EntityManagerFactory must not be null");
        if (emf instanceof EntityManagerFactoryInfo) {
            EntityManagerFactoryInfo emfInfo = (EntityManagerFactoryInfo)emf;
            EntityManagerFactory nativeEmf = emfInfo.getNativeEntityManagerFactory();
            EntityManager rawEntityManager = !CollectionUtils.isEmpty(properties) ? nativeEmf.createEntityManager(properties) : nativeEmf.createEntityManager();
            return MultipleExtendedEntityManagerCreator.createProxy(rawEntityManager, emfInfo, true, synchronizedWithTransaction);
        }
        EntityManager rawEntityManager = !CollectionUtils.isEmpty(properties) ? emf.createEntityManager(properties) : emf.createEntityManager();
        return MultipleExtendedEntityManagerCreator.createProxy(rawEntityManager, null, null, null, null, true, synchronizedWithTransaction);
    }

    private static EntityManager createProxy(EntityManager rawEntityManager, EntityManagerFactoryInfo emfInfo, boolean containerManaged, boolean synchronizedWithTransaction) {
        Assert.notNull((Object)emfInfo, (String)"EntityManagerFactoryInfo must not be null");
        JpaDialect jpaDialect = emfInfo.getJpaDialect();
        PersistenceUnitInfo pui = emfInfo.getPersistenceUnitInfo();
        Boolean jta = pui != null ? Boolean.valueOf(pui.getTransactionType() == PersistenceUnitTransactionType.JTA) : null;
        return MultipleExtendedEntityManagerCreator.createProxy(rawEntityManager, emfInfo.getEntityManagerInterface(), emfInfo.getBeanClassLoader(), (PersistenceExceptionTranslator)jpaDialect, jta, containerManaged, synchronizedWithTransaction);
    }

    private static EntityManager createProxy(EntityManager rawEm, @Nullable Class<? extends EntityManager> emIfc, @Nullable ClassLoader cl, @Nullable PersistenceExceptionTranslator exceptionTranslator, @Nullable Boolean jta, boolean containerManaged, boolean synchronizedWithTransaction) {
        Assert.notNull((Object)rawEm, (String)"EntityManager must not be null");
        LinkedHashSet<Class<Object>> ifcs = new LinkedHashSet<Class<Object>>();
        if (emIfc != null) {
            ifcs.add(emIfc);
        } else {
            ifcs.addAll(ClassUtils.getAllInterfacesForClassAsSet(rawEm.getClass(), (ClassLoader)cl));
        }
        ifcs.add(EntityManagerProxy.class);
        return (EntityManager)Proxy.newProxyInstance(cl != null ? cl : ExtendedEntityManagerCreator.class.getClassLoader(), ifcs.toArray(new Class[ifcs.size()]), (InvocationHandler)new MultipleExtendedEntityManagerInvocationHandler(rawEm, exceptionTranslator, jta, containerManaged, synchronizedWithTransaction));
    }

    private static class MultipleExtendedEntityManagerInvocationHandler
    implements InvocationHandler,
    Serializable {
        private static final Log logger = LogFactory.getLog(MultipleExtendedEntityManagerInvocationHandler.class);
        private final EntityManager target;
        @Nullable
        private final PersistenceExceptionTranslator exceptionTranslator;
        private final boolean jta;
        private final boolean containerManaged;
        private final boolean synchronizedWithTransaction;
        private EntityManager defaultEntityManager;

        private MultipleExtendedEntityManagerInvocationHandler(EntityManager target, @Nullable PersistenceExceptionTranslator exceptionTranslator, @Nullable Boolean jta, boolean containerManaged, boolean synchronizedWithTransaction) {
            this.target = target;
            this.defaultEntityManager = target;
            this.exceptionTranslator = exceptionTranslator;
            this.jta = jta != null ? jta.booleanValue() : this.isJtaEntityManager();
            this.containerManaged = containerManaged;
            this.synchronizedWithTransaction = synchronizedWithTransaction;
        }

        private boolean isJtaEntityManager() {
            try {
                this.defaultEntityManager.getTransaction();
                return false;
            }
            catch (IllegalStateException ex) {
                logger.debug((Object)"Cannot access EntityTransaction handle - assuming we're in a JTA environment");
                return true;
            }
        }

        @Override
        @Nullable
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            MultipleTransactionSynchronizationEntityManager synchronizationEntityManager = ((MultipleSessionImpl)this.target).getEntityManagers().get(DbContextHolder.getDataSourceName());
            if (this.target instanceof MultipleSessionImpl && synchronizationEntityManager != null) {
                this.defaultEntityManager = synchronizationEntityManager.getEntityManager();
                synchronizationEntityManager.begin();
            }
            if (this.defaultEntityManager == null) {
                this.defaultEntityManager = this.target;
            }
            if (method.getName().equals("equals")) {
                return proxy == args[0];
            }
            if (method.getName().equals("hashCode")) {
                return this.hashCode();
            }
            if (method.getName().equals("getTargetEntityManager")) {
                return this.defaultEntityManager;
            }
            if (method.getName().equals("unwrap")) {
                Class targetClass = (Class)args[0];
                if (targetClass == null) {
                    return this.defaultEntityManager;
                }
                if (targetClass.isInstance(proxy)) {
                    return proxy;
                }
            } else if (method.getName().equals("isOpen")) {
                if (this.containerManaged) {
                    return true;
                }
            } else if (method.getName().equals("close")) {
                if (this.containerManaged) {
                    throw new IllegalStateException("Invalid usage: Cannot close a container-managed EntityManager");
                }
                MultipleTransactionSynchronizationEntityManager synch = (MultipleTransactionSynchronizationEntityManager)((Object)TransactionSynchronizationManager.getResource((Object)this.defaultEntityManager));
                if (synch != null) {
                    synch.closeOnCompletion = true;
                    return null;
                }
            } else if (method.getName().equals("getTransaction")) {
                if (this.synchronizedWithTransaction) {
                    throw new IllegalStateException("Cannot obtain local EntityTransaction from a transaction-synchronized EntityManager");
                }
            } else {
                if (method.getName().equals("joinTransaction")) {
                    if (synchronizationEntityManager != null) {
                        synchronizationEntityManager.begin();
                    }
                    return null;
                }
                if (method.getName().equals("isJoinedToTransaction") && !this.jta) {
                    return TransactionSynchronizationManager.hasResource((Object)this.defaultEntityManager);
                }
            }
            if (this.synchronizedWithTransaction && method.getDeclaringClass().isInterface() && synchronizationEntityManager != null) {
                synchronizationEntityManager.begin();
            }
            try {
                return method.invoke((Object)this.defaultEntityManager, args);
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }
    }
}

