/*
 * Decompiled with CFR 0.152.
 */
package org.daijie.jdbc.jpa;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Optional;
import javax.persistence.Entity;
import javax.persistence.MappedSuperclass;
import org.daijie.jdbc.jpa.JpaMultipleMetamodelMappingContextFactoryBean;
import org.daijie.jdbc.jpa.MultipleEntityManagerBeanDefinitionRegistrarPostProcessor;
import org.daijie.jdbc.jpa.repository.BaseSearchJpaRepository;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.data.jpa.repository.support.DefaultJpaContext;
import org.springframework.data.jpa.repository.support.JpaRepositoryFactoryBean;
import org.springframework.data.repository.config.AnnotationRepositoryConfigurationSource;
import org.springframework.data.repository.config.RepositoryConfigurationExtensionSupport;
import org.springframework.data.repository.config.RepositoryConfigurationSource;
import org.springframework.data.repository.config.XmlRepositoryConfigurationSource;
import org.springframework.lang.Nullable;
import org.springframework.orm.jpa.support.PersistenceAnnotationBeanPostProcessor;
import org.springframework.util.StringUtils;

public class JpaMultipleRepositoryConfigExtension
extends RepositoryConfigurationExtensionSupport {
    private static final Class<?> PAB_POST_PROCESSOR = PersistenceAnnotationBeanPostProcessor.class;
    public static final String JPA_MAPPING_CONTEXT_BEAN_NAME = "jpaMappingContext";
    public static final String JPA_CONTEXT_BEAN_NAME = "jpaContext";
    public static final String EM_BEAN_DEFINITION_REGISTRAR_POST_PROCESSOR_BEAN_NAME = "emBeanDefinitionRegistrarPostProcessor";
    private static final String DEFAULT_TRANSACTION_MANAGER_BEAN_NAME = "transactionManager";
    private static final String ENABLE_DEFAULT_TRANSACTIONS_ATTRIBUTE = "enableDefaultTransactions";

    public String getModuleName() {
        return "JPA";
    }

    public String getRepositoryFactoryBeanClassName() {
        return JpaRepositoryFactoryBean.class.getName();
    }

    protected String getModulePrefix() {
        return this.getModuleName().toLowerCase(Locale.US);
    }

    protected Collection<Class<? extends Annotation>> getIdentifyingAnnotations() {
        return Arrays.asList(Entity.class, MappedSuperclass.class);
    }

    protected Collection<Class<?>> getIdentifyingTypes() {
        return Collections.singleton(BaseSearchJpaRepository.class);
    }

    public void postProcess(BeanDefinitionBuilder builder, RepositoryConfigurationSource source) {
        Optional transactionManagerRef = source.getAttribute("transactionManagerRef");
        builder.addPropertyValue(DEFAULT_TRANSACTION_MANAGER_BEAN_NAME, (Object)transactionManagerRef.orElse(DEFAULT_TRANSACTION_MANAGER_BEAN_NAME));
        builder.addPropertyValue("entityManager", (Object)JpaMultipleRepositoryConfigExtension.getEntityManagerBeanDefinitionFor(source, source.getSource()));
        builder.addPropertyReference("mappingContext", JPA_MAPPING_CONTEXT_BEAN_NAME);
    }

    public void postProcess(BeanDefinitionBuilder builder, AnnotationRepositoryConfigurationSource config) {
        AnnotationAttributes attributes = config.getAttributes();
        builder.addPropertyValue(ENABLE_DEFAULT_TRANSACTIONS_ATTRIBUTE, (Object)attributes.getBoolean(ENABLE_DEFAULT_TRANSACTIONS_ATTRIBUTE));
    }

    public void postProcess(BeanDefinitionBuilder builder, XmlRepositoryConfigurationSource config) {
        Optional enableDefaultTransactions = config.getAttribute(ENABLE_DEFAULT_TRANSACTIONS_ATTRIBUTE);
        if (enableDefaultTransactions.isPresent() && StringUtils.hasText((String)((String)enableDefaultTransactions.get()))) {
            builder.addPropertyValue(ENABLE_DEFAULT_TRANSACTIONS_ATTRIBUTE, enableDefaultTransactions.get());
        }
    }

    public void registerBeansForRoot(BeanDefinitionRegistry registry, RepositoryConfigurationSource config) {
        super.registerBeansForRoot(registry, config);
        Object source = config.getSource();
        JpaMultipleRepositoryConfigExtension.registerIfNotAlreadyRegistered((AbstractBeanDefinition)new RootBeanDefinition(MultipleEntityManagerBeanDefinitionRegistrarPostProcessor.class), (BeanDefinitionRegistry)registry, (String)EM_BEAN_DEFINITION_REGISTRAR_POST_PROCESSOR_BEAN_NAME, (Object)source);
        JpaMultipleRepositoryConfigExtension.registerIfNotAlreadyRegistered((AbstractBeanDefinition)new RootBeanDefinition(JpaMultipleMetamodelMappingContextFactoryBean.class), (BeanDefinitionRegistry)registry, (String)JPA_MAPPING_CONTEXT_BEAN_NAME, (Object)source);
        JpaMultipleRepositoryConfigExtension.registerIfNotAlreadyRegistered((AbstractBeanDefinition)new RootBeanDefinition(PAB_POST_PROCESSOR), (BeanDefinitionRegistry)registry, (String)"org.springframework.context.annotation.internalPersistenceAnnotationProcessor", (Object)source);
        RootBeanDefinition contextDefinition = new RootBeanDefinition(DefaultJpaContext.class);
        contextDefinition.setAutowireMode(3);
        JpaMultipleRepositoryConfigExtension.registerIfNotAlreadyRegistered((AbstractBeanDefinition)contextDefinition, (BeanDefinitionRegistry)registry, (String)JPA_CONTEXT_BEAN_NAME, (Object)source);
    }

    private static AbstractBeanDefinition getEntityManagerBeanDefinitionFor(RepositoryConfigurationSource config, @Nullable Object source) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition((String)"org.daijie.jdbc.jpa.MultipleSharedEntityManagerCreator");
        builder.setFactoryMethod("createSharedEntityManager");
        builder.addConstructorArgReference(JpaMultipleRepositoryConfigExtension.getEntityManagerBeanRef(config));
        AbstractBeanDefinition bean = builder.getRawBeanDefinition();
        bean.setSource(source);
        return bean;
    }

    private static String getEntityManagerBeanRef(RepositoryConfigurationSource config) {
        Optional entityManagerFactoryRef = config.getAttribute("entityManagerFactoryRef");
        return entityManagerFactoryRef.orElse("entityManagerFactory");
    }
}

