/*
 * Decompiled with CFR 0.152.
 */
package org.daijie.jdbc.jpa;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.EntityManagerFactory;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.Metamodel;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.data.jpa.mapping.JpaMetamodelMappingContext;
import org.springframework.lang.Nullable;

public class JpaMultipleMetamodelMappingContextFactoryBean
extends AbstractFactoryBean<JpaMetamodelMappingContext>
implements ApplicationContextAware {
    @Nullable
    private ListableBeanFactory beanFactory;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.beanFactory = applicationContext;
    }

    public Class<?> getObjectType() {
        return JpaMetamodelMappingContext.class;
    }

    protected JpaMetamodelMappingContext createInstance() throws Exception {
        Set<Metamodel> models = this.getMetamodels();
        HashSet<Class> entitySources = new HashSet<Class>();
        for (Metamodel metamodel : models) {
            for (ManagedType type : metamodel.getManagedTypes()) {
                Class javaType = type.getJavaType();
                if (javaType == null) continue;
                entitySources.add(javaType);
            }
        }
        JpaMetamodelMappingContext context = new JpaMetamodelMappingContext(models);
        context.setInitialEntitySet(entitySources);
        context.initialize();
        return context;
    }

    private Set<Metamodel> getMetamodels() {
        if (this.beanFactory == null) {
            throw new IllegalStateException("BeanFactory must not be null!");
        }
        Collection factories = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.beanFactory, EntityManagerFactory.class).values();
        HashSet<Metamodel> metamodels = new HashSet<Metamodel>(factories.size());
        for (EntityManagerFactory emf : factories) {
            metamodels.add(emf.getMetamodel());
        }
        return metamodels;
    }
}

