/*
 * Decompiled with CFR 0.152.
 */
package org.daijie.jdbc.jpa;

import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.daijie.jdbc.jpa.JpaMultipleEntityManagerFactoryBean;
import org.springframework.boot.orm.jpa.EntityManagerFactoryBuilder;
import org.springframework.orm.jpa.JpaVendorAdapter;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.orm.jpa.persistenceunit.PersistenceUnitManager;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class JpaMultipleEntityManagerFactoryBuilder {
    private final JpaVendorAdapter jpaVendorAdapter;
    private final PersistenceUnitManager persistenceUnitManager;
    private final Map<String, Object> jpaProperties;
    private final URL persistenceUnitRootLocation;
    private EntityManagerFactoryBuilder.EntityManagerFactoryBeanCallback callback;

    public JpaMultipleEntityManagerFactoryBuilder(JpaVendorAdapter jpaVendorAdapter, Map<String, ?> jpaProperties, PersistenceUnitManager persistenceUnitManager) {
        this(jpaVendorAdapter, jpaProperties, persistenceUnitManager, null);
    }

    public JpaMultipleEntityManagerFactoryBuilder(JpaVendorAdapter jpaVendorAdapter, Map<String, ?> jpaProperties, PersistenceUnitManager persistenceUnitManager, URL persistenceUnitRootLocation) {
        this.jpaVendorAdapter = jpaVendorAdapter;
        this.persistenceUnitManager = persistenceUnitManager;
        this.jpaProperties = new LinkedHashMap(jpaProperties);
        this.persistenceUnitRootLocation = persistenceUnitRootLocation;
    }

    public Builder dataSource(DataSource dataSource) {
        return new Builder(dataSource);
    }

    public void setCallback(EntityManagerFactoryBuilder.EntityManagerFactoryBeanCallback callback) {
        this.callback = callback;
    }

    public final class Builder {
        private DataSource dataSource;
        private String[] packagesToScan;
        private String persistenceUnit;
        private Map<String, Object> properties = new HashMap<String, Object>();
        private String[] mappingResources;
        private boolean jta;

        private Builder(DataSource dataSource) {
            this.dataSource = dataSource;
        }

        public Builder packages(String ... packagesToScan) {
            this.packagesToScan = packagesToScan;
            return this;
        }

        public Builder packages(Class<?> ... basePackageClasses) {
            HashSet<String> packages = new HashSet<String>();
            for (Class<?> type : basePackageClasses) {
                packages.add(ClassUtils.getPackageName(type));
            }
            this.packagesToScan = StringUtils.toStringArray(packages);
            return this;
        }

        public Builder persistenceUnit(String persistenceUnit) {
            this.persistenceUnit = persistenceUnit;
            return this;
        }

        public Builder properties(Map<String, ?> properties) {
            this.properties.putAll(properties);
            return this;
        }

        public Builder mappingResources(String ... mappingResources) {
            this.mappingResources = mappingResources;
            return this;
        }

        public Builder jta(boolean jta) {
            this.jta = jta;
            return this;
        }

        public LocalContainerEntityManagerFactoryBean build() {
            URL rootLocation;
            JpaMultipleEntityManagerFactoryBean entityManagerFactoryBean = new JpaMultipleEntityManagerFactoryBean();
            if (JpaMultipleEntityManagerFactoryBuilder.this.persistenceUnitManager != null) {
                entityManagerFactoryBean.setPersistenceUnitManager(JpaMultipleEntityManagerFactoryBuilder.this.persistenceUnitManager);
            }
            if (this.persistenceUnit != null) {
                entityManagerFactoryBean.setPersistenceUnitName(this.persistenceUnit);
            }
            entityManagerFactoryBean.setJpaVendorAdapter(JpaMultipleEntityManagerFactoryBuilder.this.jpaVendorAdapter);
            if (this.jta) {
                entityManagerFactoryBean.setJtaDataSource(this.dataSource);
            } else {
                entityManagerFactoryBean.setDataSource(this.dataSource);
            }
            entityManagerFactoryBean.setPackagesToScan(this.packagesToScan);
            entityManagerFactoryBean.getJpaPropertyMap().putAll(JpaMultipleEntityManagerFactoryBuilder.this.jpaProperties);
            entityManagerFactoryBean.getJpaPropertyMap().putAll(this.properties);
            if (!ObjectUtils.isEmpty((Object[])this.mappingResources)) {
                entityManagerFactoryBean.setMappingResources(this.mappingResources);
            }
            if ((rootLocation = JpaMultipleEntityManagerFactoryBuilder.this.persistenceUnitRootLocation) != null) {
                entityManagerFactoryBean.setPersistenceUnitRootLocation(rootLocation.toString());
            }
            if (JpaMultipleEntityManagerFactoryBuilder.this.callback != null) {
                JpaMultipleEntityManagerFactoryBuilder.this.callback.execute((LocalContainerEntityManagerFactoryBean)entityManagerFactoryBean);
            }
            return entityManagerFactoryBean;
        }
    }
}

