/*
 * Decompiled with CFR 0.152.
 */
package org.daijie.jdbc.jpa;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceException;
import javax.persistence.Query;
import javax.persistence.SynchronizationType;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.sql.DataSource;
import org.daijie.jdbc.interceptor.DefaultRoutingDataSource;
import org.daijie.jdbc.jpa.MultipleExtendedEntityManagerCreator;
import org.daijie.jdbc.jpa.MultiplePersistenceUnitManager;
import org.daijie.jdbc.jpa.MultipleProxySessionFactory;
import org.daijie.jdbc.jpa.MultipleSessionImpl;
import org.daijie.jdbc.transaction.MultipleTransactionSynchronizationEntityManager;
import org.springframework.beans.BeanUtils;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.jdbc.datasource.lookup.DataSourceLookup;
import org.springframework.jdbc.datasource.lookup.SingleDataSourceLookup;
import org.springframework.lang.Nullable;
import org.springframework.orm.jpa.AbstractEntityManagerFactoryBean;
import org.springframework.orm.jpa.EntityManagerFactoryInfo;
import org.springframework.orm.jpa.JpaVendorAdapter;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.orm.jpa.persistenceunit.MutablePersistenceUnitInfo;
import org.springframework.orm.jpa.persistenceunit.PersistenceUnitManager;
import org.springframework.orm.jpa.persistenceunit.SmartPersistenceUnitInfo;
import org.springframework.util.ClassUtils;

public class JpaMultipleEntityManagerFactoryBean
extends LocalContainerEntityManagerFactoryBean {
    @Nullable
    private PersistenceUnitManager persistenceUnitManager;
    @Nullable
    private PersistenceUnitInfo persistenceUnitInfo;
    @Nullable
    private Class<? extends EntityManagerFactory> entityManagerFactoryInterface;
    private final MultiplePersistenceUnitManager internalPersistenceUnitManager = new MultiplePersistenceUnitManager();
    private String[] dateSourceNames;
    private Map<Object, DataSource> targetDataSources;

    public void setEntityManagerFactoryInterface(Class<? extends EntityManagerFactory> emfInterface) {
        super.setEntityManagerFactoryInterface(emfInterface);
        this.entityManagerFactoryInterface = emfInterface;
    }

    public void setPersistenceUnitManager(PersistenceUnitManager persistenceUnitManager) {
        super.setPersistenceUnitManager(persistenceUnitManager);
        this.persistenceUnitManager = persistenceUnitManager;
    }

    public void setPersistenceUnitName(@Nullable String persistenceUnitName) {
        super.setPersistenceUnitName(persistenceUnitName);
        if (persistenceUnitName != null) {
            this.internalPersistenceUnitManager.setDefaultPersistenceUnitName(persistenceUnitName);
        }
    }

    public void setDataSource(DataSource dataSource) {
        super.setDataSource(dataSource);
        this.internalPersistenceUnitManager.setDataSourceLookup((DataSourceLookup)new SingleDataSourceLookup(dataSource));
        this.internalPersistenceUnitManager.setDefaultDataSource(dataSource);
        if (dataSource instanceof DefaultRoutingDataSource) {
            this.targetDataSources = ((DefaultRoutingDataSource)((Object)dataSource)).getTargetDataSources();
            Set<Object> keySet = this.targetDataSources.keySet();
            this.dateSourceNames = new String[keySet.size()];
            keySet.toArray(this.dateSourceNames);
        }
    }

    public void setPackagesToScan(String ... packagesToScan) {
        super.setPackagesToScan(packagesToScan);
        this.internalPersistenceUnitManager.setPackagesToScan(packagesToScan);
    }

    public void setMappingResources(String ... mappingResources) {
        super.setMappingResources(mappingResources);
        this.internalPersistenceUnitManager.setMappingResources(mappingResources);
    }

    public void setPersistenceUnitRootLocation(String defaultPersistenceUnitRootLocation) {
        super.setPersistenceUnitRootLocation(defaultPersistenceUnitRootLocation);
        this.internalPersistenceUnitManager.setDefaultPersistenceUnitRootLocation(defaultPersistenceUnitRootLocation);
    }

    public void afterPropertiesSet() throws PersistenceException {
        PersistenceUnitManager managerToUse = this.persistenceUnitManager;
        if (this.persistenceUnitManager == null) {
            this.internalPersistenceUnitManager.afterPropertiesSet();
            managerToUse = this.internalPersistenceUnitManager;
        }
        if (managerToUse instanceof MultiplePersistenceUnitManager) {
            String rootPackage;
            this.persistenceUnitInfo = ((MultiplePersistenceUnitManager)managerToUse).getPersistenceUnitInfo();
            JpaVendorAdapter jpaVendorAdapter = this.getJpaVendorAdapter();
            if (jpaVendorAdapter != null && this.persistenceUnitInfo instanceof SmartPersistenceUnitInfo && (rootPackage = jpaVendorAdapter.getPersistenceProviderRootPackage()) != null) {
                ((SmartPersistenceUnitInfo)this.persistenceUnitInfo).setPersistenceProviderPackageName(rootPackage);
            }
        }
        super.afterPropertiesSet();
    }

    protected EntityManagerFactory createNativeEntityManagerFactory() throws PersistenceException {
        MultipleProxySessionFactory entityManagerFactory = new MultipleProxySessionFactory();
        for (String datesSourceName : this.dateSourceNames) {
            MutablePersistenceUnitInfo persistenceUnitInfo = this.internalPersistenceUnitManager.getPersistenceUnitInfo(datesSourceName);
            entityManagerFactory.getEntityManagerFactories().put(datesSourceName, this.createMultipleEntityManagerFactory((PersistenceUnitInfo)persistenceUnitInfo));
        }
        return entityManagerFactory;
    }

    protected EntityManagerFactory createMultipleEntityManagerFactory(PersistenceUnitInfo persistenceUnitInfo) throws PersistenceException {
        PersistenceProvider provider = this.getPersistenceProvider();
        if (provider == null) {
            String providerClassName = persistenceUnitInfo.getPersistenceProviderClassName();
            if (providerClassName == null) {
                throw new IllegalArgumentException("No PersistenceProvider specified in EntityManagerFactory configuration, and chosen PersistenceUnitInfo does not specify a provider class name either");
            }
            Class providerClass = ClassUtils.resolveClassName((String)providerClassName, (ClassLoader)this.getBeanClassLoader());
            provider = (PersistenceProvider)BeanUtils.instantiateClass((Class)providerClass);
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Building JPA container EntityManagerFactory for persistence unit '" + this.persistenceUnitInfo.getPersistenceUnitName() + "'"));
        }
        EntityManagerFactory emf = provider.createContainerEntityManagerFactory(persistenceUnitInfo, this.getJpaPropertyMap());
        this.postProcessEntityManagerFactory(emf, persistenceUnitInfo);
        return emf;
    }

    protected EntityManagerFactory createEntityManagerFactoryProxy(@Nullable EntityManagerFactory emf) {
        LinkedHashSet<Class<Object>> ifcs = new LinkedHashSet<Class<Object>>();
        Class<? extends EntityManagerFactory> entityManagerFactoryInterface = this.entityManagerFactoryInterface;
        if (entityManagerFactoryInterface != null) {
            ifcs.add(entityManagerFactoryInterface);
        } else if (emf != null) {
            ifcs.addAll(ClassUtils.getAllInterfacesForClassAsSet(emf.getClass(), (ClassLoader)this.getBeanClassLoader()));
        } else {
            ifcs.add(EntityManagerFactory.class);
        }
        ifcs.add(EntityManagerFactoryInfo.class);
        try {
            return (EntityManagerFactory)Proxy.newProxyInstance(this.getBeanClassLoader(), ifcs.toArray(new Class[ifcs.size()]), (InvocationHandler)new MultipleEntityManagerFactoryInvocationHandler((AbstractEntityManagerFactoryBean)this));
        }
        catch (IllegalArgumentException ex) {
            if (entityManagerFactoryInterface != null) {
                throw new IllegalStateException("EntityManagerFactory interface [" + entityManagerFactoryInterface + "] seems to conflict with Spring's EntityManagerFactoryInfo mixin - consider resetting the " + "'entityManagerFactoryInterface' property to plain [javax.persistence.EntityManagerFactory]", ex);
            }
            throw new IllegalStateException("Conflicting EntityManagerFactory interfaces - consider specifying the 'jpaVendorAdapter' or 'entityManagerFactoryInterface' property to select a specific EntityManagerFactory interface to proceed with", ex);
        }
    }

    public Object invokeProxyMethod2(Method method, @Nullable Object[] args) throws Throwable {
        if (method.getDeclaringClass().isAssignableFrom(EntityManagerFactoryInfo.class)) {
            return method.invoke((Object)this, args);
        }
        if (method.getName().equals("createEntityManager") && args != null && args.length > 0 && args[0] == SynchronizationType.SYNCHRONIZED) {
            EntityManager rawEntityManager = args.length > 1 ? this.getNativeEntityManagerFactory().createEntityManager((Map)args[1]) : this.getNativeEntityManagerFactory().createEntityManager();
            return MultipleExtendedEntityManagerCreator.createApplicationManagedEntityManager(rawEntityManager, (EntityManagerFactoryInfo)this, true);
        }
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                Object arg = args[i];
                if (!(arg instanceof Query) || !Proxy.isProxyClass(arg.getClass())) continue;
                try {
                    args[i] = ((Query)arg).unwrap(null);
                    continue;
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
        }
        Object retVal = null;
        EntityManagerFactory entityManagerFactory = this.getNativeEntityManagerFactory();
        if (method.getName().contains("createEntityManager")) {
            MultipleSessionImpl sessionImpl = new MultipleSessionImpl();
            if (entityManagerFactory instanceof MultipleProxySessionFactory) {
                for (String datesSourceName : this.dateSourceNames) {
                    sessionImpl.getEntityManagers().put(datesSourceName, new MultipleTransactionSynchronizationEntityManager((EntityManager)method.invoke((Object)((MultipleProxySessionFactory)entityManagerFactory).getEntityManagerFactories().get(datesSourceName), args), (PersistenceExceptionTranslator)this.getJpaDialect()));
                    sessionImpl.getEntityManagers().get(datesSourceName);
                }
                retVal = sessionImpl;
            } else {
                retVal = method.invoke((Object)entityManagerFactory, args);
            }
        } else {
            retVal = method.invoke((Object)entityManagerFactory, args);
        }
        if (retVal instanceof EntityManager) {
            EntityManager rawEntityManager = (EntityManager)retVal;
            retVal = MultipleExtendedEntityManagerCreator.createApplicationManagedEntityManager(rawEntityManager, (EntityManagerFactoryInfo)this, false);
        }
        return retVal;
    }

    private static class MultipleEntityManagerFactoryInvocationHandler
    implements InvocationHandler,
    Serializable {
        private JpaMultipleEntityManagerFactoryBean defaultEntityManagerFactoryBean;

        public MultipleEntityManagerFactoryInvocationHandler(AbstractEntityManagerFactoryBean emfb) {
            this.defaultEntityManagerFactoryBean = (JpaMultipleEntityManagerFactoryBean)emfb;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                if (method.getName().equals("equals")) {
                    return proxy == args[0];
                }
                if (method.getName().equals("hashCode")) {
                    return System.identityHashCode(proxy);
                }
                if (method.getName().equals("unwrap")) {
                    Class targetClass = (Class)args[0];
                    if (targetClass == null) {
                        return this.defaultEntityManagerFactoryBean.getNativeEntityManagerFactory();
                    }
                    if (targetClass.isInstance(proxy)) {
                        return proxy;
                    }
                }
                return this.defaultEntityManagerFactoryBean.invokeProxyMethod2(method, args);
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }
    }
}

