/*
 * Decompiled with CFR 0.152.
 */
package org.daijie.jdbc.jpa;

import javax.sql.DataSource;
import org.daijie.core.util.bean.ApplicationContextHolder;
import org.daijie.jdbc.BaseMultipleDataSourceConfiguration;
import org.daijie.jdbc.MultipleDataSourceProperties;
import org.daijie.jdbc.jpa.EnableJpaMultipleRepositories;
import org.daijie.jdbc.jpa.JpaMultipleEntityManagerFactoryBuilder;
import org.daijie.jdbc.jpa.JpaMultipleRepositoriesAutoConfigureRegistrar;
import org.daijie.jdbc.jpa.JpaMultipleRepositoryConfigExtension;
import org.daijie.jdbc.jpa.JpaMultipleRepositoryFactoryBean;
import org.daijie.jdbc.jpa.repository.BaseSearchJpaRepository;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.data.jpa.JpaRepositoriesAutoConfiguration;
import org.springframework.boot.autoconfigure.orm.jpa.HibernateJpaAutoConfiguration;
import org.springframework.boot.autoconfigure.orm.jpa.HibernateSettings;
import org.springframework.boot.autoconfigure.orm.jpa.JpaProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.orm.jpa.JpaVendorAdapter;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.orm.jpa.persistenceunit.PersistenceUnitManager;

@Configuration
@ConditionalOnClass(value={BaseSearchJpaRepository.class})
@ConditionalOnProperty(prefix="spring.data.jpa.repositories", name={"enabled"}, havingValue="true", matchIfMissing=true)
@ConditionalOnMissingBean(value={JpaMultipleRepositoryFactoryBean.class, JpaMultipleRepositoryConfigExtension.class})
@EnableJpaMultipleRepositories(basePackages={"org.daijie"}, repositoryFactoryBeanClass=JpaMultipleRepositoryFactoryBean.class)
@Import(value={BaseMultipleDataSourceConfiguration.class, JpaMultipleRepositoriesAutoConfigureRegistrar.class, ApplicationContextHolder.class})
@AutoConfigureAfter(value={HibernateJpaAutoConfiguration.class})
@EnableAutoConfiguration(exclude={JpaRepositoriesAutoConfiguration.class})
public class JpaMultipleDataSourceConfiguration {
    private MultipleDataSourceProperties multipleDataSourceProperties;

    public JpaMultipleDataSourceConfiguration(MultipleDataSourceProperties multipleDataSourceProperties) {
        this.multipleDataSourceProperties = multipleDataSourceProperties;
    }

    @Bean(value={"EntityManagerFactoryBuilder"})
    @ConditionalOnMissingBean
    public JpaMultipleEntityManagerFactoryBuilder entityManagerFactoryBuilder(JpaVendorAdapter jpaVendorAdapter, ObjectProvider<PersistenceUnitManager> persistenceUnitManager, JpaProperties jpaProperties) {
        JpaMultipleEntityManagerFactoryBuilder builder = new JpaMultipleEntityManagerFactoryBuilder(jpaVendorAdapter, jpaProperties.getProperties(), (PersistenceUnitManager)persistenceUnitManager.getIfAvailable());
        builder.setCallback(null);
        return builder;
    }

    @Bean(value={"entityManagerFactory"})
    @ConditionalOnMissingBean
    public LocalContainerEntityManagerFactoryBean entityManagerFactory(DataSource dataSource, JpaMultipleEntityManagerFactoryBuilder entityManagerFactoryBuilder, JpaProperties jpaProperties) {
        LocalContainerEntityManagerFactoryBean entityManagerFactoryBean = entityManagerFactoryBuilder.dataSource(dataSource).properties(jpaProperties.getHibernateProperties(new HibernateSettings())).packages(this.multipleDataSourceProperties.getJpaEntityPackages()).build();
        return entityManagerFactoryBean;
    }
}

