/*
 * Decompiled with CFR 0.152.
 */
package org.daijie.jdbc.interceptor;

import java.lang.reflect.Method;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.daijie.core.factory.proxy.AroundAspectFactory;
import org.daijie.jdbc.DbContextHolder;
import org.daijie.jdbc.annotation.SelectDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.Ordered;
import org.springframework.stereotype.Component;

@Aspect
@Component
@Deprecated
public class SelectDataSourceInterceptor
implements Ordered,
AroundAspectFactory {
    public static final Logger logger = LoggerFactory.getLogger(SelectDataSourceInterceptor.class);

    @Pointcut(value="@within(org.daijie.jdbc.annotation.SelectDataSource)")
    public void targets() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object around(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        try {
            Object result;
            SelectDataSource selectDataSource;
            logger.info("set database connection to read only");
            Signature signature = proceedingJoinPoint.getSignature();
            MethodSignature methodSignature = (MethodSignature)signature;
            Method targetMethod = methodSignature.getMethod();
            Class targetClass = methodSignature.getDeclaringType();
            if (targetMethod.isAnnotationPresent(SelectDataSource.class)) {
                selectDataSource = targetMethod.getAnnotation(SelectDataSource.class);
                DbContextHolder.setDataSourceName(selectDataSource.name());
            } else if (targetClass.isAnnotationPresent(SelectDataSource.class)) {
                selectDataSource = targetClass.getAnnotation(SelectDataSource.class);
                DbContextHolder.setDataSourceName(selectDataSource.name());
            }
            Object object = result = proceedingJoinPoint.proceed();
            return object;
        }
        finally {
            DbContextHolder.clearDataSourceName();
            logger.info("restore database connection");
        }
    }

    public int getOrder() {
        return 0;
    }

    public Object throwing(JoinPoint joinPoint, Exception exception) {
        return null;
    }
}

