/*
 * Decompiled with CFR 0.152.
 */
package org.daijie.jdbc;

import com.alibaba.druid.pool.DruidDataSource;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import javax.sql.DataSource;
import org.daijie.jdbc.DataSourceUtil;
import org.daijie.jdbc.JdbcException;
import org.daijie.jdbc.MultipleDataSourceProperties;
import org.daijie.jdbc.ValidateJdbcProperty;
import org.daijie.jdbc.interceptor.DefaultRoutingDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.jta.atomikos.AtomikosDataSourceBean;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.jdbc.datasource.lookup.AbstractRoutingDataSource;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.util.StringUtils;

@EnableConfigurationProperties(value={MultipleDataSourceProperties.class})
@EnableTransactionManagement
@Configuration
public class BaseMultipleDataSourceConfiguration
implements EnvironmentAware {
    protected Logger logger = LoggerFactory.getLogger(BaseMultipleDataSourceConfiguration.class);
    private Environment environment;

    @Bean(value={"dataSource"})
    @ConditionalOnMissingBean
    public AbstractRoutingDataSource routingDataSource(MultipleDataSourceProperties multipleDataSourceProperties) {
        DefaultRoutingDataSource proxy = new DefaultRoutingDataSource();
        HashMap<Object, Object> targetDataResources = new HashMap<Object, Object>();
        Class dataSourceType = null;
        try {
            dataSourceType = multipleDataSourceProperties.getDataSourceType() != null ? multipleDataSourceProperties.getDataSourceType() : DruidDataSource.class;
            if (multipleDataSourceProperties.getNames() == null) {
                DataSource dataSource = DataSourceUtil.getDataSource(dataSourceType.getName(), (Map)Binder.get((Environment)this.environment).bind("spring.datasource", Map.class).get());
                targetDataResources.put("dataSource", dataSource);
                proxy.setDefaultTargetDataSource(dataSource);
            } else {
                String[] names;
                if (StringUtils.isEmpty((Object)multipleDataSourceProperties.getDefaultName())) {
                    throw new JdbcException("\u6ca1\u6709\u627e\u5230\u9ed8\u8ba4\u7684\u6570\u636e\u6e90\u540d\uff01", new Object[0]);
                }
                for (String name : names = StringUtils.tokenizeToStringArray((String)multipleDataSourceProperties.getNames(), (String)",; \t\n")) {
                    try {
                        Map dataSourceProps = (Map)Binder.get((Environment)this.environment).bind("spring.datasource." + name, Map.class).get();
                        AtomikosDataSourceBean dataSource = new AtomikosDataSourceBean();
                        Properties properties = new Properties();
                        properties.setProperty("user", ValidateJdbcProperty.validProperty(dataSourceProps, "username", name));
                        properties.setProperty("password", ValidateJdbcProperty.validProperty(dataSourceProps, "password", name));
                        properties.setProperty("url", ValidateJdbcProperty.validProperty(dataSourceProps, "url", name));
                        dataSource.setXaProperties(properties);
                        dataSource.setXaDataSourceClassName("com.mysql.jdbc.jdbc2.optional.MysqlXADataSource");
                        dataSource.setPoolSize(10);
                        dataSource.setReapTimeout(20000);
                        dataSource.setUniqueResourceName(name);
                        targetDataResources.put(name, dataSource);
                        if (!name.equals(multipleDataSourceProperties.getDefaultName())) continue;
                        proxy.setDefaultTargetDataSource(dataSource);
                    }
                    catch (NoSuchElementException e) {
                        this.logger.error("\u6ca1\u6709\u8bfb\u53d6\u5230\u6570\u636e\u540d<{}>\u914d\u7f6espring.datasource.{}\u5c5e\u6027\uff01", new Object[]{name, name, e});
                        throw e;
                    }
                }
            }
        }
        catch (ReflectiveOperationException e) {
            throw new JdbcException("\u6ca1\u6709\u627e\u5230\u6570\u636e\u6e90\u7c7b\u578b\uff01", e);
        }
        catch (NoSuchElementException e) {
            this.logger.error("\u6ca1\u6709\u8bfb\u53d6\u5230\u914d\u7f6espring.datasource\u5c5e\u6027\uff0c\u8bf7\u52a0\u4e0a\u76f8\u5173\u914d\u7f6e\uff01", (Throwable)e);
            throw e;
        }
        proxy.setTargetDataSources(targetDataResources);
        return proxy;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }
}

