/*
 * Decompiled with CFR 0.152.
 */
package org.daijie.jdbc;

import com.alibaba.druid.pool.DruidDataSource;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.daijie.jdbc.DataSourceUtil;
import org.daijie.jdbc.JdbcException;
import org.daijie.jdbc.MultipleDataSourceProperties;
import org.daijie.jdbc.interceptor.DefaultRoutingDataSource;
import org.daijie.jdbc.interceptor.SelectDataSourceInterceptor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.bind.RelaxedPropertyResolver;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertyResolver;
import org.springframework.jdbc.datasource.lookup.AbstractRoutingDataSource;
import org.springframework.util.StringUtils;

@Import(value={SelectDataSourceInterceptor.class})
@Configuration
public class BaseMultipleDataSourceConfiguration
implements EnvironmentAware {
    private MultipleDataSourceProperties multipleDataSourceProperties;
    private Environment environment;

    public BaseMultipleDataSourceConfiguration(MultipleDataSourceProperties multipleDataSourceProperties) {
        this.multipleDataSourceProperties = multipleDataSourceProperties;
    }

    @Bean(value={"dataSource"})
    @ConditionalOnMissingBean
    public AbstractRoutingDataSource routingDataSource() {
        RelaxedPropertyResolver propertyResolver = new RelaxedPropertyResolver((PropertyResolver)this.environment, "spring.datasource.");
        DefaultRoutingDataSource proxy = new DefaultRoutingDataSource();
        HashMap<String, DataSource> targetDataResources = new HashMap<String, DataSource>();
        Class dataSourceType = null;
        try {
            dataSourceType = this.multipleDataSourceProperties.getDataSourceType() != null ? this.multipleDataSourceProperties.getDataSourceType() : DruidDataSource.class;
            if (this.multipleDataSourceProperties.getNames() == null) {
                DataSource dataSource = DataSourceUtil.getDataSource(dataSourceType.getName(), propertyResolver.getSubProperties(""));
                targetDataResources.put("dataSource", dataSource);
                proxy.setDefaultTargetDataSource(dataSource);
            } else {
                String[] names;
                if (StringUtils.isEmpty((Object)this.multipleDataSourceProperties.getDefaultName())) {
                    throw new JdbcException("Can't find datasource default name!", new Object[0]);
                }
                for (String name : names = StringUtils.tokenizeToStringArray((String)this.multipleDataSourceProperties.getNames(), (String)",; \t\n")) {
                    Map dataSourceProps = propertyResolver.getSubProperties(name + ".");
                    DataSource dataSource = DataSourceUtil.getDataSource(dataSourceType.getName(), dataSourceProps);
                    targetDataResources.put(name, dataSource);
                    if (!name.equals(this.multipleDataSourceProperties.getDefaultName())) continue;
                    proxy.setDefaultTargetDataSource(dataSource);
                }
            }
        }
        catch (ReflectiveOperationException e) {
            throw new JdbcException("Can't find datasource type!", e);
        }
        proxy.setTargetDataSources(targetDataResources);
        return proxy;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }
}

