/*
 * Decompiled with CFR 0.152.
 */
package org.daijie.core.util.http;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.Random;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.daijie.core.util.http.HttpUtil;
import org.daijie.core.util.http.Qrcode;

public class QrcodeUtil {
    public static final int SIZE_360 = 360;
    public static final int SIZE_315 = 315;
    public static final int SIZE_275 = 275;
    public static final int SIZE_220 = 220;
    public static final int SIZE_185 = 185;
    public static final int SIZE_140 = 140;
    public static final int SIZE_95 = 95;

    public static BufferedImage createQRCode(HttpServletRequest request, String content, String logoPath, int recodeSize, Color color) {
        try {
            int j;
            int i;
            int whiteCircleWidth;
            int backgroundWidth;
            int backgroundHeight = backgroundWidth = (int)((double)recodeSize * 1.6);
            int whiteCircleHeight = whiteCircleWidth = (int)((double)recodeSize * 1.5);
            BufferedImage background = new BufferedImage(backgroundWidth, backgroundHeight, 1);
            Graphics2D gs = background.createGraphics();
            gs.setColor(Color.WHITE);
            gs.fillOval((backgroundWidth - whiteCircleWidth) / 2, (backgroundHeight - whiteCircleHeight) / 2, whiteCircleWidth, whiteCircleHeight);
            gs.setColor(color);
            int qhX = recodeSize / 45;
            int count = backgroundWidth / qhX;
            int begin = (backgroundWidth - recodeSize) / 2 / qhX;
            int end = ((backgroundWidth - recodeSize) / 2 + recodeSize) / qhX;
            for (i = 0; i < count; ++i) {
                for (j = 0; j < count; ++j) {
                    int y;
                    int x;
                    int rgb;
                    if (i >= begin && i <= end && j >= begin && j <= end || ((rgb = background.getRGB(x = i * qhX == 0 ? 0 : i * qhX + 4, y = j * qhX == 0 ? 0 : j * qhX + 4)) >> 16 & 0xFF) <= 240 || (rgb >> 8 & 0xFF) <= 240 || (rgb & 0xFF) <= 240) continue;
                    int nextInt = new Random().nextInt(20);
                    if ((j > i || nextInt >= 14) && (j <= i || nextInt >= 8)) continue;
                    gs.fillOval(j * qhX, i * qhX, qhX, qhX);
                }
            }
            for (i = 0; i < backgroundWidth; ++i) {
                for (j = 0; j < backgroundHeight; ++j) {
                    int rgb = background.getRGB(i, j);
                    if ((rgb >> 16 & 0xFF) != 0 || (rgb >> 8 & 0xFF) != 0 || (rgb & 0xFF) != 0) continue;
                    background.setRGB(i, j, -1);
                }
            }
            gs.setBackground(Color.red);
            BufferedImage bufImg = QrcodeUtil.create1(request, content, logoPath, recodeSize, color);
            gs.drawImage(bufImg, (backgroundWidth - recodeSize) / 2, (backgroundHeight - recodeSize) / 2, recodeSize, recodeSize, null);
            bufImg.flush();
            gs.dispose();
            return background;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static BufferedImage create(HttpServletRequest request, String content, String logoPath, int recodeSize, Color color) {
        try {
            int loginWidth;
            int imgWidth;
            int imgHeight = imgWidth = recodeSize;
            int loginHeight = loginWidth = imgWidth / 3;
            Qrcode qrcodeHandler = new Qrcode();
            qrcodeHandler.setQrcodeErrorCorrect('M');
            qrcodeHandler.setQrcodeEncodeMode('B');
            qrcodeHandler.setQrcodeVersion(7);
            byte[] contentBytes = content.getBytes("gbk");
            BufferedImage bufImg = new BufferedImage(imgWidth, imgHeight, 1);
            Graphics2D gs = bufImg.createGraphics();
            gs.setBackground(Color.WHITE);
            gs.clearRect(0, 0, imgWidth, imgHeight);
            gs.setColor(color);
            int pixoff = 0;
            int qhX = imgWidth / 45;
            if (contentBytes.length > 0 && contentBytes.length < 120) {
                boolean[][] codeOut = qrcodeHandler.calQrcode(contentBytes);
                for (int i = 0; i < codeOut.length; ++i) {
                    for (int j = 0; j < codeOut.length; ++j) {
                        if (!codeOut[j][i]) continue;
                        gs.fillRect(j * qhX + pixoff, i * qhX + pixoff, qhX, qhX);
                    }
                }
            } else {
                System.err.println("QRCode content bytes length = " + contentBytes.length + " not in [ 0,120 ]. ");
            }
            if (StringUtils.isNotEmpty((CharSequence)logoPath)) {
                BufferedImage img = HttpUtil.downloadImage(logoPath);
                gs.drawImage(img, (imgWidth - loginWidth) / 2, (imgHeight - loginHeight) / 2, loginWidth, loginHeight, null);
            }
            gs.dispose();
            bufImg.flush();
            return bufImg;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static BufferedImage create1(HttpServletRequest request, String content, String logoPath, int recodeSize, Color color) {
        try {
            int loginWidth;
            int imgWidth;
            int imgHeight = imgWidth = recodeSize;
            int loginHeight = loginWidth = imgWidth / 3;
            Qrcode qrcodeHandler = new Qrcode();
            qrcodeHandler.setQrcodeErrorCorrect('M');
            qrcodeHandler.setQrcodeEncodeMode('B');
            qrcodeHandler.setQrcodeVersion(7);
            byte[] contentBytes = content.getBytes("gbk");
            BufferedImage bufImg = new BufferedImage(imgWidth, imgHeight, 1);
            Graphics2D gs = bufImg.createGraphics();
            gs.setBackground(Color.WHITE);
            gs.clearRect(0, 0, imgWidth, imgHeight);
            gs.setColor(color);
            int pixoff = 0;
            int qhX = imgWidth / 45;
            int maxCircleDiameter = qhX * 7 - 4;
            int minCircleDiameter = qhX * 3;
            if (contentBytes.length > 0 && contentBytes.length < 120) {
                boolean[][] codeOut = qrcodeHandler.calQrcode(contentBytes);
                for (int i = 0; i < codeOut.length; ++i) {
                    for (int j = 0; j < codeOut.length; ++j) {
                        BasicStroke stroke;
                        if (i == 0 && j == 0) {
                            stroke = new BasicStroke(7.0f);
                            gs.setStroke(stroke);
                            gs.drawOval(i * qhX + 4, j * qhX + 4, maxCircleDiameter, maxCircleDiameter);
                            continue;
                        }
                        if (i == 37 && j == 0) {
                            stroke = new BasicStroke(7.0f);
                            gs.setStroke(stroke);
                            gs.drawOval(i * qhX + 8, j * qhX + 4, maxCircleDiameter, maxCircleDiameter);
                            continue;
                        }
                        if (i == 0 && j == 37) {
                            stroke = new BasicStroke(7.0f);
                            gs.setStroke(stroke);
                            gs.drawOval(i * qhX + 4, j * qhX + 8, maxCircleDiameter, maxCircleDiameter);
                            continue;
                        }
                        if (i == 2 && j == 2) {
                            gs.fillOval(i * qhX + 2, j * qhX + 2, minCircleDiameter, minCircleDiameter);
                            continue;
                        }
                        if (i == 39 && j == 2) {
                            gs.fillOval(i * qhX + 6, j * qhX + 2, minCircleDiameter, minCircleDiameter);
                            continue;
                        }
                        if (i == 2 && j == 39) {
                            gs.fillOval(i * qhX + 2, j * qhX + 6, minCircleDiameter, minCircleDiameter);
                            continue;
                        }
                        if (i < 7 && j < 7 || i >= 37 && j < 7 || i < 7 && j >= 37 || !codeOut[j][i]) continue;
                        gs.fillOval(j * qhX + pixoff, i * qhX + pixoff, qhX, qhX);
                    }
                }
            } else {
                System.err.println("QRCode content bytes length = " + contentBytes.length + " not in [ 0,120 ]. ");
            }
            if (StringUtils.isNotEmpty((CharSequence)logoPath)) {
                BufferedImage img = HttpUtil.downloadImage(logoPath);
                gs.drawImage(img, (imgWidth - loginWidth) / 2, (imgHeight - loginHeight) / 2, loginWidth, loginHeight, null);
            }
            gs.dispose();
            bufImg.flush();
            return bufImg;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static BufferedImage create2(HttpServletRequest request, String content, String logoPath, int recodeSize, Color color) {
        try {
            int loginWidth;
            int j;
            int i;
            int whiteCircleWidth;
            int backgroundWidth;
            int backgroundHeight = backgroundWidth = (int)((double)recodeSize * 1.6);
            int whiteCircleHeight = whiteCircleWidth = (int)((double)recodeSize * 1.5);
            BufferedImage background = new BufferedImage(backgroundWidth, backgroundHeight, 1);
            Graphics2D gs = background.createGraphics();
            gs.setColor(Color.WHITE);
            gs.fillOval((backgroundWidth - whiteCircleWidth) / 2, (backgroundHeight - whiteCircleHeight) / 2, whiteCircleWidth, whiteCircleHeight);
            gs.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            gs.setColor(color);
            gs.setPaint(new GradientPaint(whiteCircleWidth / 2, 0.0f, new Color(185, 104, 255), whiteCircleWidth / 2, whiteCircleHeight, color));
            int qhX = recodeSize / 45;
            int count = backgroundWidth / qhX;
            int begin = (backgroundWidth - recodeSize) / 2 / qhX;
            int end = ((backgroundWidth - recodeSize) / 2 + recodeSize) / qhX;
            for (i = 0; i < count; ++i) {
                for (j = 0; j < count; ++j) {
                    int y;
                    int x;
                    int rgb;
                    if (i >= begin && i <= end && j >= begin && j <= end || ((rgb = background.getRGB(x = i * qhX == 0 ? 0 : i * qhX + 4, y = j * qhX == 0 ? 0 : j * qhX + 4)) >> 16 & 0xFF) <= 240 || (rgb >> 8 & 0xFF) <= 240 || (rgb & 0xFF) <= 240) continue;
                    int nextInt = new Random().nextInt(20);
                    if ((j > i || nextInt >= 14) && (j <= i || nextInt >= 8)) continue;
                    gs.fillOval(j * qhX, i * qhX, qhX, qhX);
                }
            }
            for (i = 0; i < backgroundWidth; ++i) {
                for (j = 0; j < backgroundHeight; ++j) {
                    int rgb = background.getRGB(i, j);
                    if ((rgb >> 16 & 0xFF) != 0 || (rgb >> 8 & 0xFF) != 0 || (rgb & 0xFF) != 0) continue;
                    background.setRGB(i, j, -1);
                }
            }
            int loginHeight = loginWidth = recodeSize / 3;
            int start = (backgroundWidth - recodeSize) / 2;
            Qrcode qrcodeHandler = new Qrcode();
            qrcodeHandler.setQrcodeErrorCorrect('M');
            qrcodeHandler.setQrcodeEncodeMode('B');
            qrcodeHandler.setQrcodeVersion(7);
            byte[] contentBytes = content.getBytes("gbk");
            int pixoff = 0;
            int maxCircleDiameter = qhX * 7 - 4;
            int minCircleDiameter = qhX * 3;
            if (contentBytes.length > 0 && contentBytes.length < 120) {
                boolean[][] codeOut = qrcodeHandler.calQrcode(contentBytes);
                for (int i2 = 0; i2 < codeOut.length; ++i2) {
                    for (int j2 = 0; j2 < codeOut.length; ++j2) {
                        BasicStroke stroke;
                        if (i2 == 0 && j2 == 0) {
                            stroke = new BasicStroke(7.0f);
                            gs.setStroke(stroke);
                            gs.drawOval(i2 * qhX + 2 + start, j2 * qhX + 3 + start, maxCircleDiameter, maxCircleDiameter);
                            continue;
                        }
                        if (i2 == 37 && j2 == 0) {
                            stroke = new BasicStroke(7.0f);
                            gs.setStroke(stroke);
                            gs.drawOval(i2 * qhX + 9 + start, j2 * qhX + 3 + start, maxCircleDiameter, maxCircleDiameter);
                            continue;
                        }
                        if (i2 == 0 && j2 == 37) {
                            stroke = new BasicStroke(7.0f);
                            gs.setStroke(stroke);
                            gs.drawOval(i2 * qhX + 2 + start, j2 * qhX + 9 + start, maxCircleDiameter, maxCircleDiameter);
                            continue;
                        }
                        if (i2 == 2 && j2 == 2) {
                            gs.fillOval(i2 * qhX + 1 + start, j2 * qhX + 1 + start, minCircleDiameter, minCircleDiameter);
                            continue;
                        }
                        if (i2 == 39 && j2 == 2) {
                            gs.fillOval(i2 * qhX + 8 + start, j2 * qhX + 1 + start, minCircleDiameter, minCircleDiameter);
                            continue;
                        }
                        if (i2 == 2 && j2 == 39) {
                            gs.fillOval(i2 * qhX + 1 + start, j2 * qhX + 8 + start, minCircleDiameter, minCircleDiameter);
                            continue;
                        }
                        if (i2 < 7 && j2 < 7 || i2 >= 37 && j2 < 7 || i2 < 7 && j2 >= 37 || !codeOut[j2][i2]) continue;
                        gs.fillOval(j2 * qhX + pixoff + start, i2 * qhX + pixoff + start, qhX, qhX);
                    }
                }
            } else {
                System.err.println("QRCode content bytes length = " + contentBytes.length + " not in [ 0,120 ]. ");
            }
            if (StringUtils.isNotEmpty((CharSequence)logoPath)) {
                BufferedImage img = HttpUtil.downloadImage(logoPath);
                gs.drawImage(img, (backgroundWidth - loginWidth) / 2, (backgroundHeight - loginHeight) / 2, loginWidth, loginHeight, null);
            }
            background.flush();
            gs.dispose();
            return background;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static BufferedImage create3(HttpServletRequest request, String content, String logoPath, int recodeSize, Color color) {
        return null;
    }

    public static BufferedImage create4(HttpServletRequest request, String content, String logoPath, int recodeSize, Color color) {
        try {
            int loginWidth;
            int whiteCircleWidth;
            int backgroundWidth;
            int backgroundHeight = backgroundWidth = (int)((double)recodeSize * 1.6);
            int whiteCircleHeight = whiteCircleWidth = (int)((double)recodeSize * 1.5);
            BufferedImage background = new BufferedImage(backgroundWidth, backgroundHeight, 1);
            Graphics2D gs = background.createGraphics();
            background = gs.getDeviceConfiguration().createCompatibleImage(backgroundWidth, backgroundHeight, 3);
            gs.dispose();
            gs = background.createGraphics();
            BufferedImage shape = new BufferedImage(backgroundWidth, backgroundHeight, 1);
            Graphics2D shapeGs = shape.createGraphics();
            shapeGs.setColor(Color.WHITE);
            shapeGs.fillOval((backgroundWidth - whiteCircleWidth) / 2, (backgroundHeight - whiteCircleHeight) / 2, whiteCircleWidth, whiteCircleHeight);
            gs.setColor(color);
            gs.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            gs.setPaint(new GradientPaint(0.0f, 0.0f, new Color(199, 96, 185), whiteCircleWidth, whiteCircleHeight, new Color(132, 100, 238)));
            int qhX = recodeSize / 45;
            int count = backgroundWidth / qhX;
            int begin = (backgroundWidth - recodeSize) / 2 / qhX;
            int end = ((backgroundWidth - recodeSize) / 2 + recodeSize) / qhX;
            for (int i = 0; i < count; ++i) {
                for (int j = 0; j < count; ++j) {
                    int y;
                    int x;
                    int rgb;
                    if (i >= begin && i <= end && j >= begin && j <= end || ((rgb = shape.getRGB(x = i * qhX == 0 ? 0 : i * qhX + 4, y = j * qhX == 0 ? 0 : j * qhX + 4)) >> 16 & 0xFF) <= 240 || (rgb >> 8 & 0xFF) <= 240 || (rgb & 0xFF) <= 240) continue;
                    int nextInt = new Random().nextInt(20);
                    if ((j > i || nextInt >= 10) && (j <= i || nextInt >= 10)) continue;
                    gs.fillOval(j * qhX, i * qhX, qhX, qhX);
                }
            }
            int loginHeight = loginWidth = recodeSize / 3;
            int start = (backgroundWidth - recodeSize) / 2;
            Qrcode qrcodeHandler = new Qrcode();
            qrcodeHandler.setQrcodeErrorCorrect('M');
            qrcodeHandler.setQrcodeEncodeMode('B');
            qrcodeHandler.setQrcodeVersion(7);
            byte[] contentBytes = content.getBytes("gbk");
            int pixoff = 0;
            int maxCircleDiameter = qhX * 7 - 4;
            int minCircleDiameter = qhX * 3;
            if (contentBytes.length > 0 && contentBytes.length < 120) {
                boolean[][] codeOut = qrcodeHandler.calQrcode(contentBytes);
                for (int i = 0; i < codeOut.length; ++i) {
                    for (int j = 0; j < codeOut.length; ++j) {
                        BasicStroke stroke;
                        if (i == 0 && j == 0) {
                            stroke = new BasicStroke(7.0f);
                            gs.setStroke(stroke);
                            gs.drawOval(i * qhX + 2 + start, j * qhX + 3 + start, maxCircleDiameter, maxCircleDiameter);
                            continue;
                        }
                        if (i == 37 && j == 0) {
                            stroke = new BasicStroke(7.0f);
                            gs.setStroke(stroke);
                            gs.drawOval(i * qhX + 9 + start, j * qhX + 3 + start, maxCircleDiameter, maxCircleDiameter);
                            continue;
                        }
                        if (i == 0 && j == 37) {
                            stroke = new BasicStroke(7.0f);
                            gs.setStroke(stroke);
                            gs.drawOval(i * qhX + 2 + start, j * qhX + 9 + start, maxCircleDiameter, maxCircleDiameter);
                            continue;
                        }
                        if (i == 2 && j == 2) {
                            gs.fillOval(i * qhX + 1 + start, j * qhX + 1 + start, minCircleDiameter, minCircleDiameter);
                            continue;
                        }
                        if (i == 39 && j == 2) {
                            gs.fillOval(i * qhX + 8 + start, j * qhX + 1 + start, minCircleDiameter, minCircleDiameter);
                            continue;
                        }
                        if (i == 2 && j == 39) {
                            gs.fillOval(i * qhX + 1 + start, j * qhX + 8 + start, minCircleDiameter, minCircleDiameter);
                            continue;
                        }
                        if (i < 7 && j < 7 || i >= 37 && j < 7 || i < 7 && j >= 37 || !codeOut[j][i]) continue;
                        gs.fillOval(j * qhX + pixoff + start, i * qhX + pixoff + start, qhX, qhX);
                    }
                }
            } else {
                System.err.println("QRCode content bytes length = " + contentBytes.length + " not in [ 0,120 ]. ");
            }
            if (StringUtils.isNotEmpty((CharSequence)logoPath)) {
                BufferedImage img = HttpUtil.downloadImage(logoPath);
                gs.drawImage(img, (backgroundWidth - loginWidth) / 2, (backgroundHeight - loginHeight) / 2, loginWidth, loginHeight, null);
            }
            background.flush();
            gs.dispose();
            return background;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

