/*
 * Decompiled with CFR 0.152.
 */
package org.daijie.core.util.http;

import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.imageio.ImageIO;
import org.apache.commons.beanutils.BeanMap;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.SimpleHttpConnectionManager;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.lang3.StringUtils;

public class HttpUtil {
    private static final String POST = "POST";
    private static final String GET = "GET";
    private static final String PUT = "PUT";
    private static final String DELETE = "DELETE";
    private static final String TYPE_STRING = "string";
    private static final String TYPE_BYTEARRAY = "byte[]";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String requestURLGet(String urlStr) {
        URL url = null;
        BufferedReader in = null;
        StringBuffer sb = new StringBuffer();
        try {
            url = new URL(urlStr);
            in = new BufferedReader(new InputStreamReader(url.openStream(), "UTF-8"));
            String str = null;
            while ((str = in.readLine()) != null) {
                sb.append(str);
            }
        }
        catch (Exception str) {
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException str) {}
        }
        String result = sb.toString();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String requestURL(String urlStr, String params, String method) throws Exception {
        StringBuilder sb = new StringBuilder();
        byte[] data = params.getBytes("UTF-8");
        URL url = new URL(urlStr);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod(method);
        conn.setDoOutput(true);
        conn.setDoInput(true);
        conn.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
        conn.setRequestProperty("Content-Length", String.valueOf(data.length));
        OutputStream outStream = conn.getOutputStream();
        outStream.write(data);
        outStream.flush();
        BufferedReader in = null;
        try {
            in = new BufferedReader(new InputStreamReader(conn.getInputStream(), "UTF-8"));
            String str = null;
            while ((str = in.readLine()) != null) {
                sb.append(str);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                conn.disconnect();
                if (in != null) {
                    in.close();
                }
                if (outStream != null) {
                    outStream.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return sb.toString();
    }

    public static Object requestMethod(String method, String urlStr, Object params, String responseType, Class<?> resultBeanClass) throws Exception {
        if (POST.equals(method.toUpperCase())) {
            return HttpUtil.requestPost(urlStr, params, responseType, resultBeanClass);
        }
        if (GET.equals(method.toUpperCase())) {
            return HttpUtil.requestGet(urlStr, params, responseType, resultBeanClass);
        }
        if (PUT.equals(method.toUpperCase())) {
            return HttpUtil.requestPut(urlStr, params, responseType, resultBeanClass);
        }
        if (DELETE.equals(method.toUpperCase())) {
            return HttpUtil.requestDelete(urlStr, params, responseType, resultBeanClass);
        }
        throw new HttpException("mothod is error!");
    }

    private static Object requestPost(String urlStr, Object params, String responseType, Class<?> resultBeanClass) throws Exception {
        PostMethod method = new PostMethod(urlStr);
        method.addParameters(HttpUtil.getNameValuePair(params));
        return HttpUtil.requestExecute((HttpMethod)method, responseType, resultBeanClass);
    }

    private static Object requestGet(String urlStr, Object params, String responseType, Class<?> resultBeanClass) throws Exception {
        GetMethod method = new GetMethod(HttpUtil.getHttpParams(urlStr, params, "UTF-8"));
        return HttpUtil.requestExecute((HttpMethod)method, responseType, resultBeanClass);
    }

    private static Object requestPut(String urlStr, Object params, String responseType, Class<?> resultBeanClass) throws Exception {
        PutMethod method = new PutMethod(HttpUtil.getHttpParams(urlStr, params, "UTF-8"));
        return HttpUtil.requestExecute((HttpMethod)method, responseType, resultBeanClass);
    }

    private static Object requestDelete(String urlStr, Object params, String responseType, Class<?> resultBeanClass) throws Exception {
        DeleteMethod method = new DeleteMethod(HttpUtil.getHttpParams(urlStr, params, "UTF-8"));
        return HttpUtil.requestExecute((HttpMethod)method, responseType, resultBeanClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object requestExecute(HttpMethod method, String responseType, Class<?> resultBeanClass) {
        HttpClient client = null;
        SimpleHttpConnectionManager connectionManager = null;
        Object responseResult = null;
        try {
            responseResult = resultBeanClass.newInstance();
            connectionManager = new SimpleHttpConnectionManager(true);
            connectionManager.getParams().setConnectionTimeout(3000);
            connectionManager.getParams().setSoTimeout(60000);
            connectionManager.getParams().setParameter("http.protocol.content-charset", (Object)"UTF-8");
            client = new HttpClient(new HttpClientParams(), (HttpConnectionManager)connectionManager);
            method.getParams().setContentCharset("UTF-8");
            method.setRequestHeader("Connection", "close");
            int sendStatus = client.executeMethod(method);
            if (sendStatus == 200) {
                if (StringUtils.equals((CharSequence)TYPE_STRING, (CharSequence)responseType)) {
                    responseResult = method.getResponseBodyAsString();
                } else if (StringUtils.equals((CharSequence)TYPE_BYTEARRAY, (CharSequence)responseType)) {
                    responseResult = method.getResponseBody();
                }
            } else {
                responseResult = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
            if (connectionManager != null) {
                connectionManager.shutdown();
            }
        }
        return responseResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage downloadImage(String urlStr) {
        URL url = null;
        HttpURLConnection httpConn = null;
        BufferedImage image = null;
        try {
            url = new URL(urlStr);
            httpConn = (HttpURLConnection)url.openConnection();
            InputStream inputStream = httpConn.getInputStream();
            image = ImageIO.read(inputStream);
        }
        catch (Exception exception) {
        }
        finally {
            if (httpConn != null) {
                httpConn.disconnect();
            }
        }
        return image;
    }

    private static String getHttpParams(String url, Object params, String encode) {
        StringBuffer buf = new StringBuffer(url);
        if (params != null) {
            if (!(params instanceof Map)) {
                params = new BeanMap(params);
            }
            String flag = url.indexOf(63) == -1 ? "?" : "&";
            for (String name : ((Map)params).keySet()) {
                buf.append(flag);
                buf.append(name);
                buf.append("=");
                try {
                    String param = ((Map)params).get(name).toString();
                    if (param == null) {
                        param = "";
                    }
                    buf.append(URLEncoder.encode(param, encode));
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
                flag = "&";
            }
        }
        return buf.toString();
    }

    private static NameValuePair[] getNameValuePair(Object params) {
        NameValuePair[] nameValuePairArr = null;
        if (params != null) {
            if (!(params instanceof Map)) {
                params = new BeanMap(params);
            }
            nameValuePairArr = new NameValuePair[((Map)params).size()];
            Set key = ((Map)params).keySet();
            Iterator keyIte = key.iterator();
            int index = 0;
            while (keyIte.hasNext()) {
                NameValuePair pair;
                Object paramName = keyIte.next();
                Object paramValue = ((Map)params).get(paramName);
                if (!(paramName instanceof String) || !(paramValue instanceof String)) continue;
                nameValuePairArr[index] = pair = new NameValuePair((String)paramName, (String)paramValue);
                ++index;
            }
        }
        return nameValuePairArr;
    }
}

