/*
 * Decompiled with CFR 0.152.
 */
package org.daijie.core.swagger.web;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.daijie.core.result.factory.ModelResultInitialFactory;
import org.daijie.core.swagger.web.SwaggerCache;
import org.daijie.core.swagger.web.ZuulSwaggerProperties;
import org.daijie.core.util.IdWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;
import springfox.documentation.spring.web.PropertySourcedMapping;
import springfox.documentation.swagger.web.SwaggerResource;

@RestController
public class FocusSwaggerController
implements Serializable {
    protected Logger logger = LoggerFactory.getLogger(FocusSwaggerController.class);
    public static final String SWAGGER_RESOURCES_URL = "/swagger-resources";
    public static final String SWAGGER_RESOURCES_UI_URL = "/swagger-resources/configuration/ui";
    public static final String DEFAULT_URL = "/focus/api-docs";
    public static final String RESOURCES_URL = "/focus-resources";
    public static final String API_DEFAULT_URL = "/api-focus/api-docs";
    public static final String API_RESOURCES_URL = "/api-focus-resources";
    public static final String PARAM = "?group=";
    private static final String HAL_MEDIA_TYPE = "application/hal+json";
    private static final String SPLIT = ".";
    private static Map<String, SwaggerCache> swaggerCaches = new HashMap<String, SwaggerCache>();
    private final RestTemplate restTemplate;
    private final ZuulSwaggerProperties zuulSwaggerProperties;

    @Autowired
    public FocusSwaggerController(RestTemplate restTemplate, ZuulSwaggerProperties zuulSwaggerProperties) {
        this.restTemplate = restTemplate;
        this.zuulSwaggerProperties = zuulSwaggerProperties;
    }

    @RequestMapping(value={"/focus/api-docs"}, method={RequestMethod.GET}, produces={"application/json", "application/hal+json"})
    @PropertySourcedMapping(value="${springfox.documentation.swagger.v2.path}", propertyKey="springfox.documentation.swagger.v2.path")
    public Object getDocumentation(@RequestParam(value="group", required=false) String swaggerGroup, HttpServletRequest servletRequest) {
        if (!swaggerGroup.contains(SPLIT)) {
            return null;
        }
        String[] split = swaggerGroup.split("\\.");
        if (swaggerCaches.get(split[0]) != null) {
            split[1] = swaggerCaches.get(split[0]).getValue(split[1]);
        }
        Map documentation = null;
        try {
            int request = 0;
            while (request < 3) {
                try {
                    documentation = (Map)this.restTemplate.getForObject("http://" + split[0] + "/v2/api-docs" + PARAM + split[1], Map.class, new Object[0]);
                    request = 3;
                }
                catch (Exception e) {
                    ++request;
                }
            }
            if (!this.zuulSwaggerProperties.getRoutes().isEmpty()) {
                for (Map.Entry<String, ZuulSwaggerProperties.ZuulRoute> next : this.zuulSwaggerProperties.getRoutes().entrySet()) {
                    if (!split[0].equals(next.getValue().getServiceId())) continue;
                    documentation.put("basePath", "/" + next.getKey());
                    documentation.put("host", servletRequest.getServerName() + ":" + servletRequest.getServerPort());
                }
            }
        }
        catch (Exception e) {
            this.logger.error("API\u670d\u52a1\u540d{}\u52a0\u8f7d\u6587\u6863\u5931\u8d25\uff01", (Object)swaggerGroup);
            this.logger.error("", (Throwable)e);
        }
        return documentation;
    }

    @RequestMapping(value={"/focus-resources"}, method={RequestMethod.GET}, produces={"application/json", "application/hal+json"})
    public Object swaggerResources() {
        Iterator<Map.Entry<String, ZuulSwaggerProperties.ZuulRoute>> iterator = this.zuulSwaggerProperties.getRoutes().entrySet().iterator();
        ArrayList list = new ArrayList();
        while (iterator.hasNext()) {
            Map.Entry<String, ZuulSwaggerProperties.ZuulRoute> next = iterator.next();
            try {
                Iterable datas = null;
                this.swaggerResourcesUI(next.getValue().getServiceId());
                int request = 0;
                while (request < 3) {
                    try {
                        datas = (List)this.restTemplate.getForObject("http://" + next.getValue().getServiceId() + SWAGGER_RESOURCES_URL, List.class, new Object[0]);
                        request = 3;
                    }
                    catch (Exception e) {
                        ++request;
                    }
                }
                if (datas == null) continue;
                datas.forEach(data -> {
                    SwaggerCache swaggerCache;
                    String name = null;
                    SwaggerResource swaggerResource = new SwaggerResource();
                    if (swaggerCaches == null) {
                        swaggerCaches = new HashMap<String, SwaggerCache>();
                    }
                    if (swaggerCaches.get(((ZuulSwaggerProperties.ZuulRoute)next.getValue()).getServiceId()) == null) {
                        name = IdWorker.getDayId();
                        swaggerCache = new SwaggerCache();
                        swaggerCache.set(name, (String)data.get("name"));
                        swaggerCaches.put(((ZuulSwaggerProperties.ZuulRoute)next.getValue()).getServiceId(), swaggerCache);
                    } else {
                        swaggerCache = swaggerCaches.get(((ZuulSwaggerProperties.ZuulRoute)next.getValue()).getServiceId());
                        name = swaggerCache.getKey((String)data.get("name"));
                        if (name == null) {
                            name = IdWorker.getDayId();
                            swaggerCache.set(name, (String)data.get("name"));
                        }
                    }
                    String location = null;
                    location = ((String)data.get("location")).contains(PARAM) ? ((String)data.get("location")).replace(PARAM, PARAM + ((ZuulSwaggerProperties.ZuulRoute)next.getValue()).getServiceId() + SPLIT) : (String)data.get("location") + PARAM + ((ZuulSwaggerProperties.ZuulRoute)next.getValue()).getServiceId() + SPLIT + name;
                    location = ((String)data.get("url")).contains(PARAM) ? ((String)data.get("url")).replace(PARAM, PARAM + ((ZuulSwaggerProperties.ZuulRoute)next.getValue()).getServiceId() + SPLIT) : (String)data.get("url") + PARAM + ((ZuulSwaggerProperties.ZuulRoute)next.getValue()).getServiceId() + SPLIT + name;
                    location = location.replace(location.substring(location.lastIndexOf(SPLIT) + 1), name);
                    swaggerResource.setLocation(location);
                    swaggerResource.setSwaggerVersion((String)data.get("swaggerVersion"));
                    swaggerResource.setName(((ZuulSwaggerProperties.ZuulRoute)next.getValue()).getServiceName() + SPLIT + (String)data.get("name"));
                    list.add(swaggerResource);
                });
            }
            catch (Exception e) {
                this.logger.error("API\u670d\u52a1\u540d{}\u52a0\u8f7d\u8d44\u6e90\u5931\u8d25\uff01", (Object)next.getValue().getServiceId());
                this.logger.error("", (Throwable)e);
            }
        }
        return list;
    }

    private Object swaggerResourcesUI(String serviceId) {
        return this.restTemplate.getForObject("http://" + serviceId + SWAGGER_RESOURCES_UI_URL, Object.class, new Object[0]);
    }

    @RequestMapping(value={"/api-focus-resources"}, method={RequestMethod.GET})
    public Object swaggerResourcesApi() {
        return ModelResultInitialFactory.Result.build(this.swaggerResources());
    }

    @RequestMapping(value={"/api-focus/api-docs"}, method={RequestMethod.GET})
    public Object getDocumentationApi(@RequestParam(value="group", required=false) String swaggerGroup, HttpServletRequest servletRequest) {
        return ModelResultInitialFactory.Result.build(this.getDocumentation(swaggerGroup, servletRequest));
    }
}

