/*
 * Decompiled with CFR 0.152.
 */
package org.daijie.core.process;

import java.lang.reflect.Array;
import org.daijie.core.factory.IEnumFactory;
import org.daijie.core.process.Edge;
import org.daijie.core.process.Process;
import org.daijie.core.process.ProcessHandle;
import org.daijie.core.process.Vertex;

public class MapOrthogonalEnumProcess<E extends IEnumFactory<E>>
implements ProcessHandle<E> {
    private static final long serialVersionUID = -3676220248726358481L;
    private Vertex<E>[] vertexs;
    private int vertexSize;
    private int edgeSize;

    public MapOrthogonalEnumProcess(int index) {
        this.vertexs = (Vertex[])Array.newInstance(Vertex.class, index);
    }

    private int check(E element) {
        for (int i = 0; i < this.vertexSize; ++i) {
            if (!element.equals(this.vertexs[i].element)) continue;
            return i;
        }
        Vertex<E> newVertex = new Vertex<E>(element);
        this.vertexs[this.vertexSize++] = newVertex;
        return this.vertexSize - 1;
    }

    private void link(E from, E to, Process processEnum) {
        Edge edge;
        int indexFrom = this.check(from);
        int indexTo = this.check(to);
        Edge edgeOut = this.vertexs[indexFrom].firstOut;
        Edge edgeIn = this.vertexs[indexTo].firstIn;
        this.vertexs[indexFrom].firstOut = edge = new Edge(processEnum, indexFrom, indexTo, edgeIn, edgeOut);
        this.vertexs[indexTo].firstIn = edge;
        ++this.edgeSize;
    }

    private E nextNode(E element) {
        return this.nextNode(element, Process.THROUGH);
    }

    private E nextNode(E element, Process processEnum) {
        int index = this.check(element);
        Edge edge = this.vertexs[index].firstOut;
        while (edge != null) {
            if (edge.process.equals((Object)processEnum)) {
                return (E)((IEnumFactory)this.vertexs[edge.toVertexIndex].element);
            }
            edge = edge.toVertexLink;
        }
        return null;
    }

    private E preNode(E element) {
        int index = this.check(element);
        Edge edge = this.vertexs[index].firstIn;
        if (edge != null) {
            return (E)((IEnumFactory)this.vertexs[edge.fromVertexIndex].element);
        }
        return null;
    }

    private E preNode(E element, Process processEnum) {
        int index = this.check(element);
        Edge edge = this.vertexs[index].firstIn;
        while (edge != null) {
            if (edge.process.equals((Object)processEnum)) {
                return (E)((IEnumFactory)this.vertexs[edge.fromVertexIndex].element);
            }
            edge = edge.fromVertexLink;
        }
        return null;
    }

    @Override
    public boolean add(E element) {
        if (this.vertexSize == 0) {
            this.check(element);
        } else if (this.vertexSize < 2) {
            this.link((IEnumFactory)this.vertexs[this.vertexSize - 1].element, element, null);
        } else {
            for (int i = this.vertexSize - 1; i >= 0; --i) {
                Edge edge = this.vertexs[i].firstIn;
                while (edge != null) {
                    if (edge.process.equals((Object)Process.THROUGH)) {
                        this.link((IEnumFactory)this.vertexs[edge.toVertexIndex].element, element, null);
                        return true;
                    }
                    edge = edge.fromVertexLink;
                }
            }
        }
        return false;
    }

    @Override
    public boolean add(E[] elements) {
        for (int i = 0; i < elements.length; ++i) {
            this.add(elements[i]);
        }
        return true;
    }

    public boolean add(E from, E to, Process processEnum) {
        this.link(from, to, processEnum);
        return true;
    }

    public int line() {
        return this.edgeSize;
    }

    @Override
    public int size() {
        return this.vertexSize;
    }

    @Override
    public boolean isEmpty() {
        return this.vertexSize == 0;
    }

    public E next(E element) {
        return this.nextNode(element);
    }

    @Override
    public E next(E element, Process processEnum) {
        return this.nextNode(element, processEnum);
    }

    public E pre(E element) {
        return this.preNode(element);
    }

    @Override
    public E pre(E element, Process processEnum) {
        return this.preNode(element, processEnum);
    }
}

