/*
 * Decompiled with CFR 0.152.
 */
package org.daijie.core.lock.zk;

import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.locks.InterProcessMutex;
import org.daijie.core.lock.DistributedReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkReentrantLock
implements DistributedReentrantLock {
    private static final Logger logger = LoggerFactory.getLogger(ZkReentrantLock.class);
    private static final ScheduledExecutorService executorService = Executors.newScheduledThreadPool(10);
    public static final String ROOT_PATH = "/ROOT_LOCK/";
    private long delayTimeForClean = 1000L;
    private InterProcessMutex interProcessMutex = null;
    private String path;
    private CuratorFramework client;

    public ZkReentrantLock(CuratorFramework client, String lockId) {
        this.init(client, lockId);
    }

    public void init(CuratorFramework client, String lockId) {
        this.client = client;
        this.path = ROOT_PATH + lockId;
        this.interProcessMutex = new InterProcessMutex(client, this.path);
    }

    @Override
    public boolean tryLock(long timeout, TimeUnit unit) throws InterruptedException {
        try {
            return this.interProcessMutex.acquire(timeout, unit);
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public void unlock() {
        try {
            this.interProcessMutex.release();
        }
        catch (Throwable e) {
            logger.error(e.getMessage(), e);
        }
        finally {
            executorService.schedule(new Cleaner(this.client, this.path), this.delayTimeForClean, TimeUnit.MILLISECONDS);
        }
    }

    static class Cleaner
    implements Runnable {
        CuratorFramework client;
        String path;

        public Cleaner(CuratorFramework client, String path) {
            this.client = client;
            this.path = path;
        }

        @Override
        public void run() {
            try {
                List list = (List)this.client.getChildren().forPath(this.path);
                if (list == null || list.isEmpty()) {
                    this.client.delete().forPath(this.path);
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

