/*
 * Decompiled with CFR 0.152.
 */
package org.daijie.core.lock.zk;

import java.util.concurrent.TimeUnit;
import org.apache.curator.framework.CuratorFramework;
import org.daijie.core.lock.Callback;
import org.daijie.core.lock.DistributedLockTemplate;
import org.daijie.core.lock.zk.ZkReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkDistributedLockTemplate
implements DistributedLockTemplate {
    private static final Logger logger = LoggerFactory.getLogger(ZkDistributedLockTemplate.class);
    private CuratorFramework client;

    public ZkDistributedLockTemplate(CuratorFramework client) {
        this.client = client;
    }

    private boolean tryLock(ZkReentrantLock distributedReentrantLock, Long timeout) throws Exception {
        return distributedReentrantLock.tryLock(timeout, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object execute(String lockId, int timeout, Callback callback) {
        ZkReentrantLock distributedReentrantLock = null;
        boolean getLock = false;
        try {
            distributedReentrantLock = new ZkReentrantLock(this.client, lockId);
            if (this.tryLock(distributedReentrantLock, new Long(timeout))) {
                getLock = true;
                Object object = callback.onGetLock();
                return object;
            }
            Object object = callback.onTimeout();
            return object;
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            logger.debug(e.getMessage(), (Throwable)e);
            Object object = callback.onError(e);
            return object;
        }
        finally {
            if (getLock) {
                distributedReentrantLock.unlock();
            }
        }
    }
}

