/*
 * Decompiled with CFR 0.152.
 */
package org.daijie.core.lock.redis;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisPool;

class RedisLockInternals {
    private static final Logger logger = LoggerFactory.getLogger(RedisLockInternals.class);
    private JedisPool jedisPool;
    private JedisCluster jedisCluster;
    private int retryAwait = 300;
    private int lockTimeout = 2000;
    private static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};

    RedisLockInternals(Object jedisLock) {
        if (jedisLock instanceof JedisPool) {
            this.jedisPool = (JedisPool)jedisLock;
        } else if (jedisLock instanceof JedisCluster) {
            this.jedisCluster = (JedisCluster)jedisLock;
        }
    }

    String tryRedisLock(String lockId, long time, TimeUnit unit) {
        long startMillis = System.currentTimeMillis();
        Long millisToWait = unit != null ? Long.valueOf(unit.toMillis(time)) : null;
        String lockValue = null;
        while (lockValue == null && (lockValue = this.createRedisKey(lockId)) == null && System.currentTimeMillis() - startMillis - (long)this.retryAwait <= millisToWait) {
            LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(this.retryAwait));
        }
        return lockValue;
    }

    private String createRedisKey(String lockId) {
        String value = lockId + this.randomId(1);
        String luaScript = "\nlocal r = tonumber(redis.call('SETNX', KEYS[1],ARGV[1]));\nredis.call('PEXPIRE',KEYS[1],ARGV[2]);\nreturn r";
        ArrayList<String> keys = new ArrayList<String>();
        keys.add(lockId);
        ArrayList<String> args = new ArrayList<String>();
        args.add(value);
        args.add(this.lockTimeout + "");
        Long ret = this.eval(luaScript, keys, args);
        if (new Long(1L).equals(ret)) {
            return value;
        }
        return null;
    }

    void unlockRedisLock(String key, String value) {
        String luaScript = "\nlocal v = redis.call('GET', KEYS[1]);\nlocal r= 0;\nif v == ARGV[1] then\nr =redis.call('DEL',KEYS[1]);\nend\nreturn r";
        ArrayList<String> keys = new ArrayList<String>();
        keys.add(key);
        ArrayList<String> args = new ArrayList<String>();
        args.add(value);
        this.eval(luaScript, keys, args);
    }

    private String randomId(int size) {
        char[] cs = new char[size];
        for (int i = 0; i < cs.length; ++i) {
            cs[i] = digits[ThreadLocalRandom.current().nextInt(digits.length)];
        }
        return new String(cs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Long eval(String script, List<String> keys, List<String> args) {
        if (this.jedisPool != null) {
            try (Jedis jedis = null;){
                jedis = this.jedisPool.getResource();
                Long l = (Long)jedis.eval(script, keys, args);
                return l;
            }
        }
        if (this.jedisCluster != null) {
            try {
                Long l = (Long)this.jedisCluster.eval(script, keys, args);
                return l;
            }
            finally {
                if (this.jedisCluster != null) {
                    try {
                        this.jedisCluster.close();
                    }
                    catch (IOException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
        return 0L;
    }
}

