/*
 * Decompiled with CFR 0.152.
 */
package org.daijie.core.lock;

import java.lang.reflect.Method;
import org.daijie.core.factory.proxy.BeforeHardlerFactory;
import org.daijie.core.lock.Callback;
import org.daijie.core.lock.Lock;
import org.daijie.core.lock.LockTool;
import org.daijie.core.result.ModelResult;
import org.daijie.core.result.factory.ModelResultInitialFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class LockHardler
extends BeforeHardlerFactory {
    private static final Logger logger = LoggerFactory.getLogger(LockHardler.class);

    @Override
    public void before(Object proxy, Method method, Object[] args) {
        ModelResult<Object> locking;
        String lockId;
        logger.debug("\u8fdb\u5165\u5206\u5e03\u5f0f\u9501\uff0c\u6267\u884c\u65b9\u6cd5{}", (Object)method.toGenericString());
        Class<?>[] parameterNames = method.getParameterTypes();
        Lock lock = method.getAnnotation(Lock.class);
        if (lock == null) {
            lock = proxy.getClass().getAnnotation(Lock.class);
        }
        if (StringUtils.isEmpty((Object)(lockId = lock.lockId()))) {
            if (!StringUtils.isEmpty((Object)lock.argName())) {
                for (int i = 0; i < args.length; ++i) {
                    if (!parameterNames[i].getName().contains(lock.argName())) continue;
                    lockId = (String)args[i];
                }
            } else {
                lockId = method.getName();
            }
        }
        if (!(locking = this.tryLock(lockId, lock)).isSuccess()) {
            throw new RuntimeException();
        }
    }

    @Override
    public Object throwing(Object proxy, Method method, Object[] args, Exception exception) {
        Class<?> returnType = method.getReturnType();
        try {
            if (returnType.newInstance() instanceof ModelResult) {
                return ModelResultInitialFactory.Result.build(exception.getMessage(), false);
            }
        }
        catch (Exception exception2) {
            // empty catch block
        }
        return null;
    }

    private ModelResult<Object> tryLock(String lockId, final Lock lock) {
        return (ModelResult)LockTool.execute(lockId, lock.timeout(), new Callback(){

            @Override
            public ModelResult<Object> onTimeout() throws InterruptedException {
                String timeOutMethodName = lock.timeOutMethodName();
                if (timeOutMethodName != null) {
                    return LockHardler.this.execute(timeOutMethodName);
                }
                return ModelResultInitialFactory.Result.build(false);
            }

            @Override
            public ModelResult<Object> onGetLock() throws InterruptedException {
                return ModelResultInitialFactory.Result.build();
            }

            @Override
            public ModelResult<Object> onError(Exception exception) {
                String errorMethodName = lock.errorMethodName();
                if (errorMethodName != null) {
                    return LockHardler.this.execute(errorMethodName);
                }
                return ModelResultInitialFactory.Result.build(false);
            }
        });
    }

    private ModelResult<Object> execute(String serviceName) {
        String str1 = serviceName.substring(0, serviceName.indexOf("("));
        String className = str1.substring(0, str1.lastIndexOf("."));
        String methodName = str1.substring(str1.lastIndexOf(".") + 1);
        String args = serviceName.substring(serviceName.lastIndexOf("(") + 1, serviceName.indexOf(")"));
        try {
            Object result = null;
            Class<?> clz = Class.forName(className);
            if (StringUtils.isEmpty((Object)args)) {
                Method method = clz.getDeclaredMethod(methodName, new Class[0]);
                result = method.invoke(clz.newInstance(), new Object[0]);
            } else {
                String[] argNames = args.split(",");
                Object[] argObjects = new Object[argNames.length];
                Class[] argClasses = new Class[argNames.length];
                for (int i = 0; i < argClasses.length; ++i) {
                    if (argNames[i].trim().length() <= 0) continue;
                    argClasses[i] = Class.forName(argNames[i].trim());
                    argObjects[i] = argClasses[i].newInstance();
                }
                Method method = clz.getDeclaredMethod(methodName, argClasses);
                result = method.invoke(clz.newInstance(), argObjects);
            }
            return ModelResultInitialFactory.Result.build(result);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

