/*
 * Decompiled with CFR 0.152.
 */
package org.daijie.core.filter;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.daijie.core.controller.enums.JSONType;
import org.daijie.core.util.http.HttpConversationUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.handler.AbstractHandlerMethodMapping;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.util.UrlPathHelper;

public class BodyReaderHttpServletRequestWrapper
extends HttpServletRequestWrapper {
    private static Logger logger = LoggerFactory.getLogger(BodyReaderHttpServletRequestWrapper.class);
    private final byte[] body;
    private final AntPathMatcher matcher = new AntPathMatcher();
    private final UrlPathHelper pathHelper = new UrlPathHelper();
    private Map<Object, Object> params = new HashMap<Object, Object>();

    public BodyReaderHttpServletRequestWrapper(HttpServletRequest request, AbstractHandlerMethodMapping<RequestMappingInfo> objHandlerMethodMapping) throws IOException {
        super(request);
        this.params.putAll(request.getParameterMap());
        String bodyString = HttpConversationUtil.getBodyString();
        if (StringUtils.isEmpty((Object)bodyString) || JSONType.getJSONType(bodyString).equals((Object)JSONType.JSON_TYPE_ERROR)) {
            this.body = new byte[0];
            Set mappings = objHandlerMethodMapping.getHandlerMethods().keySet();
            mappings.forEach(mapping -> {
                String pattern;
                RequestMappingInfo requestMappingInfo = mapping.getMatchingCondition(request);
                if (requestMappingInfo != null && (pattern = (String)requestMappingInfo.getPatternsCondition().getPatterns().iterator().next()).contains("{") && pattern.contains("}")) {
                    Map result = this.matcher.extractUriTemplateVariables(pattern, this.pathHelper.getLookupPathForRequest(request));
                    for (Map.Entry next : result.entrySet()) {
                        if (((String)next.getValue()).contains("{") && ((String)next.getValue()).contains("}")) continue;
                        this.params.put(next.getKey(), next.getValue());
                    }
                }
            });
        } else {
            this.body = request.getMethod().equals(HttpMethod.GET.name()) ? new byte[0] : bodyString.getBytes(Charset.forName("UTF-8"));
            if (request.getContentType().contains("application/json")) {
                ObjectMapper mapper = new ObjectMapper();
                if (JSONType.getJSONType(bodyString).equals((Object)JSONType.JSON_TYPE_OBJECT)) {
                    this.params.putAll((Map)mapper.readValue(bodyString, Map.class));
                }
            }
        }
        logger.info("params = {}", this.params);
    }

    public BufferedReader getReader() throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream()));
    }

    public ServletInputStream getInputStream() throws IOException {
        final ByteArrayInputStream bais = new ByteArrayInputStream(this.body);
        return new ServletInputStream(){

            public boolean isFinished() {
                return false;
            }

            public boolean isReady() {
                return false;
            }

            public void setReadListener(ReadListener listener) {
            }

            public int read() throws IOException {
                return bais.read();
            }
        };
    }

    public String getHeader(String name) {
        return super.getHeader(name);
    }

    public Enumeration<String> getHeaderNames() {
        return super.getHeaderNames();
    }

    public Enumeration<String> getHeaders(String name) {
        return super.getHeaders(name);
    }

    public Map getParameterMap() {
        return this.params;
    }

    public Enumeration getParameterNames() {
        Vector<Object> l = new Vector<Object>(this.params.keySet());
        return l.elements();
    }

    public String[] getParameterValues(String name) {
        Object v = this.params.get(name);
        if (v == null) {
            return null;
        }
        if (v instanceof String[]) {
            return (String[])v;
        }
        if (v instanceof String) {
            return new String[]{(String)v};
        }
        if (v instanceof Collection) {
            Object[] array = ((Collection)v).toArray();
            String[] strs = new String[array.length];
            for (int i = 0; i < strs.length; ++i) {
                if (array[i] == null) {
                    strs[i] = null;
                    continue;
                }
                if (array[i] instanceof Map || array[i] instanceof Collection) {
                    logger.info("param\u8bf7\u6c42\u53c2\u6570{}\u6570\u7ec4{}\u53ea\u5141\u8bb8\u662f\u57fa\u672c\u6570\u636e\u7c7b\u578b", (Object)name, (Object)i);
                    strs[i] = null;
                    continue;
                }
                strs[i] = array[i].toString();
            }
            return strs;
        }
        if (v instanceof Map) {
            logger.info("param\u8bf7\u6c42\u53c2\u6570\u5c5e\u6027{}\u53ea\u5141\u8bb8\u662f\u57fa\u672c\u6570\u636e\u7c7b\u578b", (Object)name);
            return new String[0];
        }
        return new String[]{v.toString()};
    }

    public String getParameter(String name) {
        Object v = this.params.get(name);
        if (v == null) {
            return null;
        }
        if (v instanceof String[]) {
            String[] strArr = (String[])v;
            if (strArr.length > 0) {
                return strArr[0];
            }
            return null;
        }
        if (v instanceof String) {
            return (String)v;
        }
        return v.toString();
    }

    public String[] generatorObject(Map map) {
        String[] array = new String[map.size()];
        Iterator iterator = map.keySet().iterator();
        int index = 0;
        while (iterator.hasNext()) {
            Object next = iterator.next();
            if (next instanceof Map) {
                this.generatorObject((Map)next);
            } else {
                array[index] = next.toString();
            }
            ++index;
        }
        return array;
    }
}

