/*
 * Decompiled with CFR 0.152.
 */
package org.daijie.core.util.validate;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ValidateUtil {
    public static String toSBC(String input) {
        char[] c = input.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            if (c[i] == ' ') {
                c[i] = 12288;
                continue;
            }
            if (c[i] >= '\u007f') continue;
            c[i] = (char)(c[i] + 65248);
        }
        return new String(c);
    }

    public static String toDBC(String input) {
        char[] c = input.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            if (c[i] == '\u3000') {
                c[i] = 32;
                continue;
            }
            if (c[i] <= '\uff00' || c[i] >= '\uff5f') continue;
            c[i] = (char)(c[i] - 65248);
        }
        return new String(c);
    }

    public static boolean isNotNull(String str) {
        if (str == null) {
            return false;
        }
        return !"".equals(str.trim());
    }

    public static boolean isZnCh(String str) {
        boolean bl = true;
        if (!ValidateUtil.isEmpty(str)) {
            for (int i = 0; i < str.length(); ++i) {
                String s = str.substring(i, i + 1);
                byte[] b = s.getBytes();
                if (b.length != 1) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }

    public static boolean isHasChinese(String str) {
        if (!ValidateUtil.isEmpty(str)) {
            String regex = ".*[\u4e00-\u9fa5]+.*";
            return ValidateUtil.matText(regex, str);
        }
        return false;
    }

    public static boolean isMail(String mail) {
        if (!ValidateUtil.isEmpty(mail)) {
            String regex = "\\w+([-+.]\\w+)*@\\w+([-.]\\w+)*\\.\\w+([-.]\\w+)*";
            return ValidateUtil.matText(regex, mail);
        }
        return false;
    }

    public static boolean isMobile(String mobile) {
        if (!ValidateUtil.isEmpty(mobile)) {
            String regex = "^(13[0-9]|14[0-9]|15[0-9]|18[0-9]|17[0-9])\\d{8}$";
            return ValidateUtil.matText(regex, mobile);
        }
        return false;
    }

    public static boolean isNum(String num) {
        if (!ValidateUtil.isEmpty(num)) {
            String regex = "[0-9]*";
            return ValidateUtil.matText(regex, num);
        }
        return false;
    }

    public static boolean isNum(String num, int diag) {
        int index = num.indexOf(".");
        if (index < 0 || diag == 0) {
            return ValidateUtil.isNum(num);
        }
        String num1 = num.substring(0, index);
        String num2 = num.substring(index + 1);
        if (num2.length() != diag) {
            return false;
        }
        return ValidateUtil.isNum(num1) && ValidateUtil.isNum(num2);
    }

    public static boolean isNum(String num, double min, double max, int diag) {
        if (!ValidateUtil.isNum(num, diag)) {
            return false;
        }
        if (Double.valueOf(num) < min) {
            return false;
        }
        return !(Double.valueOf(num) > max);
    }

    public static boolean isInArray(String param, String[] params) {
        if (ValidateUtil.isEmpty(param)) {
            return false;
        }
        for (String p : params) {
            if (!param.equals(p)) continue;
            return true;
        }
        return false;
    }

    public static boolean isInLength(String str, int min, int max) {
        return !ValidateUtil.isEmpty(str) && str.length() > min && str.length() <= max;
    }

    public static boolean isDate(String date) {
        if (!ValidateUtil.isEmpty(date)) {
            String dp1 = "\\d{4}-\\d{2}-\\d{2}";
            String dp2 = "^((\\d{2}(([02468][048])|([13579][26]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])))))|(\\d{2}(([02468][1235679])|([13579][01345789]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|(1[0-9])|(2[0-8]))))))";
            if (ValidateUtil.matText(dp1, date) && ValidateUtil.matText(dp2, date)) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                try {
                    sdf.parse(date);
                    return true;
                }
                catch (ParseException e) {
                    return false;
                }
            }
        }
        return false;
    }

    public static boolean isEmpty(String str) {
        return str == null || "".equals(str.trim());
    }

    public static boolean isNotEmpty(String str) {
        return !ValidateUtil.isEmpty(str);
    }

    public static boolean isBoolean(String str) {
        return !ValidateUtil.isEmpty(str) && ("true".equals(str.toLowerCase()) || "false".equals(str.toLowerCase()));
    }

    public static boolean isInEnum(String str, Class<?> c) {
        if (!ValidateUtil.isEmpty(str)) {
            for (Object o : c.getEnumConstants()) {
                if (!o.toString().equals(str)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean matText(String expression, String text) {
        Pattern p = Pattern.compile(expression);
        Matcher m = p.matcher(text);
        boolean b = m.matches();
        return b;
    }

    public static boolean isInEnumName(String str, Class<?> c) {
        if (!ValidateUtil.isEmpty(str)) {
            for (Object o : c.getEnumConstants()) {
                if (!((Enum)o).name().equals(str)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isBankCard(String cardId) {
        char bit = ValidateUtil.getBankCardCode(cardId.substring(0, cardId.length() - 1));
        if (bit == 'N') {
            return false;
        }
        return cardId.charAt(cardId.length() - 1) == bit;
    }

    public static char getBankCardCode(String cardId) {
        if (cardId == null || cardId.trim().length() == 0 || !cardId.matches("\\d+")) {
            return 'N';
        }
        char[] chs = cardId.trim().toCharArray();
        int luhmSum = 0;
        int i = chs.length - 1;
        int j = 0;
        while (i >= 0) {
            int k = chs[i] - 48;
            if (j % 2 == 0) {
                k *= 2;
                k = k / 10 + k % 10;
            }
            luhmSum += k;
            --i;
            ++j;
        }
        return luhmSum % 10 == 0 ? (char)'0' : (char)(10 - luhmSum % 10 + 48);
    }

    public static boolean isCreditCard(String number) {
        int i;
        int sumOdd = 0;
        int sumEven = 0;
        int length = number.length();
        int[] wei = new int[length];
        for (i = 0; i < number.length(); ++i) {
            wei[i] = Integer.parseInt(number.substring(length - i - 1, length - i));
        }
        for (i = 0; i < length / 2; ++i) {
            sumOdd += wei[2 * i];
            if (wei[2 * i + 1] * 2 > 9) {
                wei[2 * i + 1] = wei[2 * i + 1] * 2 - 9;
            } else {
                int n = 2 * i + 1;
                wei[n] = wei[n] * 2;
            }
            sumEven += wei[2 * i + 1];
        }
        return (sumOdd + sumEven) % 10 == 0;
    }

    public static boolean isNumber(String num) {
        int index = num.indexOf(".");
        if (index < 0) {
            return ValidateUtil.isNum(num);
        }
        String num1 = num.substring(0, index);
        String num2 = num.substring(index + 1);
        return ValidateUtil.isNum(num1) && ValidateUtil.isNum(num2);
    }
}

