/*
 * Decompiled with CFR 0.152.
 */
package org.daijie.core.util.image;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import org.daijie.core.util.http.HttpUtil;

public class ImageUtil {
    public static BufferedImage resizeImg(String sfile, int newWidth, int newHeight, float quality) throws IOException {
        Image srcImg = HttpUtil.downloadImage(sfile);
        if (srcImg == null) {
            srcImg = new ImageIcon(sfile).getImage();
        }
        return ImageUtil.resizeImg(srcImg, newWidth, newHeight, quality);
    }

    public static BufferedImage resizeImg(Image image, int newWidth, int newHeight, float quality) throws IOException {
        if (quality > 1.0f) {
            throw new IllegalArgumentException("Quality has to be between 0 and 1");
        }
        if (newWidth <= 0 || newHeight <= 0) {
            throw new IllegalArgumentException("Width or Height must greater than zero");
        }
        Image resizedImage = image.getScaledInstance(newWidth, newHeight, 4);
        Image temp = new ImageIcon(resizedImage).getImage();
        BufferedImage bufferedImage = new BufferedImage(newWidth, newHeight, 1);
        Graphics2D g = bufferedImage.createGraphics();
        g.setColor(Color.white);
        g.fillRect(0, 0, newWidth, newHeight);
        g.drawImage(temp, 0, 0, null);
        g.dispose();
        float softenFactor = 0.05f;
        float[] softenArray = new float[]{0.0f, softenFactor, 0.0f, softenFactor, 1.0f - softenFactor * 4.0f, softenFactor, 0.0f, softenFactor, 0.0f};
        Kernel kernel = new Kernel(3, 3, softenArray);
        ConvolveOp cOp = new ConvolveOp(kernel, 1, null);
        bufferedImage = cOp.filter(bufferedImage, null);
        return bufferedImage;
    }

    public static BufferedImage makeRoundedCornerImg(String sfile, int cornerRadius) throws IOException {
        BufferedImage image = ImageIO.read(new File(sfile));
        return ImageUtil.makeRoundedCornerImg(image, cornerRadius);
    }

    public static BufferedImage makeRoundedCornerImg(BufferedImage image, int cornerRadius) throws IOException {
        int w = image.getWidth();
        int h = image.getHeight();
        BufferedImage output = new BufferedImage(w, h, 2);
        Graphics2D g2 = output.createGraphics();
        g2.setComposite(AlphaComposite.Src);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(Color.WHITE);
        g2.fill(new RoundRectangle2D.Float(0.0f, 0.0f, w, h, cornerRadius, cornerRadius));
        g2.setComposite(AlphaComposite.SrcAtop);
        g2.drawImage((Image)image, 0, 0, null);
        g2.dispose();
        return output;
    }

    public static void write(BufferedImage image, String tfile) throws IOException {
        try {
            ImageIO.write((RenderedImage)image, "png", new File(tfile));
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
    }
}

