/*
 * Decompiled with CFR 0.152.
 */
package org.daijie.core.util.http;

import com.baomidou.kisso.common.util.EnvUtil;
import com.xiaoleilu.hutool.json.JSONObject;
import com.xiaoleilu.hutool.json.JSONUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;

public class MacAddressUtil {
    public static String callCmd(String[] cmd) {
        String result = "";
        String line = "";
        try {
            Process proc = Runtime.getRuntime().exec(cmd);
            InputStreamReader is = new InputStreamReader(proc.getInputStream());
            BufferedReader br = new BufferedReader(is);
            while ((line = br.readLine()) != null) {
                result = result + line;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static String callCmd(String[] cmd, String[] another) {
        String result = "";
        String line = "";
        try {
            Runtime rt = Runtime.getRuntime();
            Process proc = rt.exec(cmd);
            proc.waitFor();
            proc = rt.exec(another);
            InputStreamReader is = new InputStreamReader(proc.getInputStream());
            BufferedReader br = new BufferedReader(is);
            while ((line = br.readLine()) != null) {
                result = result + line;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static String filterMacAddress(String ip, String sourceString, String macSeparator) {
        String result = "";
        String regExp = "((([0-9,A-F,a-f]{1,2}" + macSeparator + "){1,5})[0-9,A-F,a-f]{1,2})";
        Pattern pattern = Pattern.compile(regExp);
        Matcher matcher = pattern.matcher(sourceString);
        while (matcher.find()) {
            result = matcher.group(1);
            if (sourceString.indexOf(ip) > sourceString.lastIndexOf(matcher.group(1))) continue;
            break;
        }
        return result;
    }

    public static String getMacInWindows(String ip) {
        String result = "";
        String[] cmd = new String[]{"cmd", "/c", "ping " + ip};
        String[] another = new String[]{"cmd", "/c", "arp -a"};
        String cmdResult = MacAddressUtil.callCmd(cmd, another);
        result = MacAddressUtil.filterMacAddress(ip, cmdResult, "-");
        return result;
    }

    public static String getMacInLinux(String ip) {
        String result = "";
        String[] cmd = new String[]{"/bin/sh", "-c", "ping " + ip + " -c 2 && arp -a"};
        String cmdResult = MacAddressUtil.callCmd(cmd);
        result = MacAddressUtil.filterMacAddress(ip, cmdResult, ":");
        return result;
    }

    public static String getMacAddress(String ip) {
        String macAddress = "";
        if (EnvUtil.isLinux()) {
            macAddress = MacAddressUtil.getMacInLinux(ip).trim();
        }
        if (macAddress == null || "".equals(macAddress)) {
            macAddress = MacAddressUtil.getMacInWindows(ip).trim();
        }
        return macAddress;
    }

    public static String getIpAddr(HttpServletRequest request) throws Exception {
        String ipAddress = request.getHeader("x-forwarded-for");
        if (ipAddress == null || ipAddress.length() == 0 || "unknown".equalsIgnoreCase(ipAddress)) {
            ipAddress = request.getHeader("Proxy-Client-IP");
        }
        if (ipAddress == null || ipAddress.length() == 0 || "unknown".equalsIgnoreCase(ipAddress)) {
            ipAddress = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ipAddress == null || ipAddress.length() == 0 || "unknown".equalsIgnoreCase(ipAddress)) {
            ipAddress = request.getHeader("HTTP_CLIENT_IP");
        }
        if (ipAddress == null || ipAddress.length() == 0 || "unknown".equalsIgnoreCase(ipAddress)) {
            ipAddress = request.getHeader("HTTP_X_FORWARDED_FOR");
        }
        if (ipAddress == null || ipAddress.length() == 0 || "unknown".equalsIgnoreCase(ipAddress)) {
            ipAddress = request.getRemoteAddr();
            if (ipAddress.startsWith("0")) {
                ipAddress = "127.0.0.1";
            }
            if (ipAddress.equals("127.0.0.1")) {
                InetAddress inet = null;
                try {
                    inet = InetAddress.getLocalHost();
                }
                catch (UnknownHostException e) {
                    e.printStackTrace();
                }
                ipAddress = inet.getHostAddress();
            }
        }
        if (ipAddress != null && ipAddress.length() > 15 && ipAddress.indexOf(",") > 0) {
            ipAddress = ipAddress.substring(0, ipAddress.indexOf(","));
        }
        return ipAddress;
    }

    public static String ip2Location(String ip) {
        String result = "";
        try {
            URLConnection connection = new URL("http://int.dpool.sina.com.cn/iplookup/iplookup.php?format=js&ip=" + ip).openConnection();
            connection.getInputStream();
            connection.setConnectTimeout(5000);
            try (BufferedReader br = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
                String s;
                while ((s = br.readLine()) != null) {
                    result = result + s;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String json = result.substring(result.indexOf("=") + 1, result.length() - 1);
        JSONObject jsonObject = JSONUtil.parseObj((String)json);
        StringBuilder location = new StringBuilder();
        if (jsonObject.getStr((Object)"country") != null) {
            location.append(jsonObject.getStr((Object)"country"));
        }
        if (jsonObject.getStr((Object)"province") != null) {
            location.append(jsonObject.getStr((Object)"province"));
        }
        if (jsonObject.getStr((Object)"city") != null) {
            location.append(jsonObject.getStr((Object)"city"));
        }
        return location.toString();
    }

    public static String getMACAddress1(String ip) throws Exception {
        String line = "";
        String macAddress = "";
        String MAC_ADDRESS_PREFIX = "MAC Address = ";
        String LOOPBACK_ADDRESS = "127.0.0.1";
        if ("127.0.0.1".equals(ip)) {
            InetAddress inetAddress = InetAddress.getLocalHost();
            byte[] mac = NetworkInterface.getByInetAddress(inetAddress).getHardwareAddress();
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < mac.length; ++i) {
                String s;
                if (i != 0) {
                    sb.append("-");
                }
                sb.append((s = Integer.toHexString(mac[i] & 0xFF)).length() == 1 ? 0 + s : s);
            }
            macAddress = sb.toString().trim().toUpperCase();
            return macAddress;
        }
        try {
            Process p = Runtime.getRuntime().exec("nbtstat -A " + ip);
            InputStreamReader isr = new InputStreamReader(p.getInputStream());
            BufferedReader br = new BufferedReader(isr);
            while ((line = br.readLine()) != null) {
                int index;
                if (line == null || (index = line.indexOf("MAC Address = ")) == -1) continue;
                macAddress = line.substring(index + "MAC Address = ".length()).trim().toUpperCase();
            }
            br.close();
        }
        catch (IOException e) {
            e.printStackTrace(System.out);
        }
        return macAddress;
    }
}

