/*
 * Decompiled with CFR 0.152.
 */
package org.daijie.core.util.http;

import com.baomidou.kisso.SSOHelper;
import com.baomidou.kisso.security.token.SSOToken;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.daijie.core.util.http.CookieUtil;
import org.daijie.core.util.http.MacAddressUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class HttpConversationUtil {
    private static Logger logger = LoggerFactory.getLogger(HttpConversationUtil.class);
    public static final String TOKEN_NAME = "token";

    public static HttpServletRequest getRequest() {
        return ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
    }

    public static HttpServletResponse getResponse() {
        return ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getResponse();
    }

    public static String getIP() {
        String ip = HttpConversationUtil.getRequest().getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = HttpConversationUtil.getRequest().getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = HttpConversationUtil.getRequest().getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = HttpConversationUtil.getRequest().getRemoteAddr();
        }
        return ip.equals("0:0:0:0:0:0:0:1") ? "127.0.0.1" : ip;
    }

    public String getIPAddress() {
        try {
            return MacAddressUtil.ip2Location(HttpConversationUtil.getIP());
        }
        catch (Exception e) {
            logger.error("IP Address not found!");
            return "IP Address not found!";
        }
    }

    public static String getToken() {
        if (HttpConversationUtil.getRequest() != null) {
            SSOToken ssoToken = null;
            try {
                ssoToken = SSOHelper.getSSOToken((HttpServletRequest)HttpConversationUtil.getRequest());
            }
            catch (Exception e) {
                logger.debug("ssoToken\u83b7\u53d6\u5931\u8d25");
            }
            if (ssoToken != null && !StringUtils.isEmpty((Object)ssoToken.getIssuer())) {
                return ssoToken.getIssuer();
            }
            if (!StringUtils.isEmpty((Object)HttpConversationUtil.getRequest().getAttribute(TOKEN_NAME))) {
                return HttpConversationUtil.getRequest().getAttribute(TOKEN_NAME).toString();
            }
            if (!StringUtils.isEmpty((Object)HttpConversationUtil.getRequest().getParameter(TOKEN_NAME))) {
                return HttpConversationUtil.getRequest().getParameter(TOKEN_NAME);
            }
            if (!StringUtils.isEmpty((Object)HttpConversationUtil.getRequest().getHeader(TOKEN_NAME))) {
                return HttpConversationUtil.getRequest().getHeader(TOKEN_NAME);
            }
            if (!StringUtils.isEmpty((Object)CookieUtil.get(TOKEN_NAME))) {
                return CookieUtil.get(TOKEN_NAME);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getBodyString() {
        StringBuilder sb = new StringBuilder();
        ServletInputStream inputStream = null;
        BufferedReader reader = null;
        try {
            inputStream = HttpConversationUtil.getRequest().getInputStream();
            reader = new BufferedReader(new InputStreamReader((InputStream)inputStream, Charset.forName("UTF-8")));
            String line = "";
            while ((line = reader.readLine()) != null) {
                sb.append(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return sb.toString();
    }

    public static Map<String, Object> handelRequest() {
        HashMap<String, Object> obj = new HashMap<String, Object>();
        Enumeration coll = HttpConversationUtil.getRequest().getParameterNames();
        while (coll.hasMoreElements()) {
            String key = (String)coll.nextElement();
            obj.put(key, HttpConversationUtil.getRequest().getParameter(key) == null ? "" : HttpConversationUtil.getRequest().getParameter(key));
        }
        if (obj.get("pageSize") != null || obj.get("pageNumber") != null) {
            int pageSize = Integer.valueOf(obj.get("pageSize").toString());
            int pageNumber = Integer.valueOf(obj.get("pageNumber").toString());
            int startIndex = (pageNumber - 1) * pageSize;
            obj.put("startIndex", startIndex);
            obj.put("pageSize", pageSize);
            obj.put("pageNumber", pageNumber);
        }
        return obj;
    }
}

