/*
 * Decompiled with CFR 0.152.
 */
package org.daijie.core.util.encrypt;

import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import org.apache.commons.codec.binary.Base64;

public class RSAUtil {
    private static byte[] pub_key = null;
    private static byte[] pri_key = null;
    private static final String RSA_KEY_ALGORITHM = "RSA";
    private static final String SIGNATURE_ALGORITHM = "MD5withRSA";
    private static final int KEY_SIZE = 1024;

    public static void init() {
        try {
            RSAUtil.initKey();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void set(byte[] pub_key, byte[] pri_key) {
        RSAUtil.pub_key = pub_key;
        RSAUtil.pri_key = pri_key;
        if (pub_key == null || pri_key == null) {
            try {
                RSAUtil.initKey();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void set(String pub_key, String pri_key) {
        RSAUtil.pri_key = Base64.decodeBase64((String)pub_key);
        RSAUtil.pub_key = Base64.decodeBase64((String)pri_key);
        if (pub_key == null || pri_key == null) {
            try {
                RSAUtil.initKey();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static void initKey() throws Exception {
        KeyPairGenerator keygen = KeyPairGenerator.getInstance(RSA_KEY_ALGORITHM);
        SecureRandom secrand = new SecureRandom();
        secrand.setSeed("initSeed".getBytes());
        keygen.initialize(1024, secrand);
        KeyPair keys = keygen.genKeyPair();
        pub_key = keys.getPublic().getEncoded();
        pri_key = keys.getPrivate().getEncoded();
    }

    public static String sign(byte[] data) throws Exception {
        PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(pri_key);
        KeyFactory keyFactory = KeyFactory.getInstance(RSA_KEY_ALGORITHM);
        PrivateKey priKey = keyFactory.generatePrivate(pkcs8KeySpec);
        Signature signature = Signature.getInstance(SIGNATURE_ALGORITHM);
        signature.initSign(priKey);
        signature.update(data);
        return Base64.encodeBase64String((byte[])signature.sign());
    }

    public static boolean verify(byte[] data, byte[] sign) throws Exception {
        KeyFactory keyFactory = KeyFactory.getInstance(RSA_KEY_ALGORITHM);
        X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(pub_key);
        PublicKey pubKey = keyFactory.generatePublic(x509KeySpec);
        Signature signature = Signature.getInstance(SIGNATURE_ALGORITHM);
        signature.initVerify(pubKey);
        signature.update(data);
        return signature.verify(sign);
    }

    public static byte[] encryptByPubKey(byte[] data) throws Exception {
        X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(pub_key);
        KeyFactory keyFactory = KeyFactory.getInstance(RSA_KEY_ALGORITHM);
        PublicKey publicKey = keyFactory.generatePublic(x509KeySpec);
        Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
        cipher.init(1, publicKey);
        return cipher.doFinal(data);
    }

    public static byte[] encryptByPubKey(byte[] data, byte[] pub_key) throws Exception {
        X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(pub_key);
        KeyFactory keyFactory = KeyFactory.getInstance(RSA_KEY_ALGORITHM);
        PublicKey publicKey = keyFactory.generatePublic(x509KeySpec);
        Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
        cipher.init(1, publicKey);
        return cipher.doFinal(data);
    }

    public static String encryptByPubKey(String data) throws Exception {
        byte[] enSign = RSAUtil.encryptByPubKey(data.getBytes());
        return Base64.encodeBase64String((byte[])enSign);
    }

    public static String encryptByPubKey(String data, String pub_key) throws Exception {
        byte[] enSign = RSAUtil.encryptByPubKey(data.getBytes(), Base64.decodeBase64((String)pub_key));
        return Base64.encodeBase64String((byte[])enSign);
    }

    public static byte[] encryptByPriKey(byte[] data) throws Exception {
        PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(pri_key);
        KeyFactory keyFactory = KeyFactory.getInstance(RSA_KEY_ALGORITHM);
        PrivateKey privateKey = keyFactory.generatePrivate(pkcs8KeySpec);
        Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
        cipher.init(1, privateKey);
        return cipher.doFinal(data);
    }

    public static byte[] encryptByPriKey(byte[] data, byte[] pri_key) throws Exception {
        PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(pri_key);
        KeyFactory keyFactory = KeyFactory.getInstance(RSA_KEY_ALGORITHM);
        PrivateKey privateKey = keyFactory.generatePrivate(pkcs8KeySpec);
        Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
        cipher.init(1, privateKey);
        return cipher.doFinal(data);
    }

    public static String encryptByPriKey(String data) throws Exception {
        byte[] enSign = RSAUtil.encryptByPriKey(data.getBytes());
        return Base64.encodeBase64String((byte[])enSign);
    }

    public static String encryptByPriKey(String data, String pri_key) throws Exception {
        byte[] enSign = RSAUtil.encryptByPriKey(data.getBytes(), Base64.decodeBase64((String)pri_key));
        return Base64.encodeBase64String((byte[])enSign);
    }

    public static byte[] decryptByPubKey(byte[] data) throws Exception {
        X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(pub_key);
        KeyFactory keyFactory = KeyFactory.getInstance(RSA_KEY_ALGORITHM);
        PublicKey publicKey = keyFactory.generatePublic(x509KeySpec);
        Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
        cipher.init(2, publicKey);
        return cipher.doFinal(data);
    }

    public static byte[] decryptByPubKey(byte[] data, byte[] pub_key) throws Exception {
        X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(pub_key);
        KeyFactory keyFactory = KeyFactory.getInstance(RSA_KEY_ALGORITHM);
        PublicKey publicKey = keyFactory.generatePublic(x509KeySpec);
        Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
        cipher.init(2, publicKey);
        return cipher.doFinal(data);
    }

    public static String decryptByPubKey(String data) throws Exception {
        byte[] design = RSAUtil.decryptByPubKey(Base64.decodeBase64((String)data));
        return new String(design);
    }

    public static String decryptByPubKey(String data, String pub_key) throws Exception {
        byte[] design = RSAUtil.decryptByPubKey(Base64.decodeBase64((String)data), Base64.decodeBase64((String)pub_key));
        return new String(design);
    }

    public static byte[] decryptByPriKey(byte[] data) throws Exception {
        PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(pri_key);
        KeyFactory keyFactory = KeyFactory.getInstance(RSA_KEY_ALGORITHM);
        PrivateKey privateKey = keyFactory.generatePrivate(pkcs8KeySpec);
        Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
        cipher.init(2, privateKey);
        return cipher.doFinal(data);
    }

    public static byte[] decryptByPriKey(byte[] data, byte[] pri_key) throws Exception {
        PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(pri_key);
        KeyFactory keyFactory = KeyFactory.getInstance(RSA_KEY_ALGORITHM);
        PrivateKey privateKey = keyFactory.generatePrivate(pkcs8KeySpec);
        Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
        cipher.init(2, privateKey);
        return cipher.doFinal(data);
    }

    public static String decryptByPriKey(String data) throws Exception {
        byte[] design = RSAUtil.decryptByPriKey(Base64.decodeBase64((String)data));
        return new String(design);
    }

    public static String decryptByPriKey(String data, String pri_key) throws Exception {
        byte[] design = RSAUtil.decryptByPriKey(Base64.decodeBase64((String)data), Base64.decodeBase64((String)pri_key));
        return new String(design);
    }

    public static String getPubKey() {
        return Base64.encodeBase64String((byte[])pub_key);
    }

    public static String getPriKey() {
        return Base64.encodeBase64String((byte[])pri_key);
    }
}

